/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamesparks.model.ExtensionDetails;
import software.amazon.awssdk.services.gamesparks.model.ExtensionDetailsListCopier;
import software.amazon.awssdk.services.gamesparks.model.GameSparksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExtensionsResponse
extends GameSparksResponse
implements ToCopyableBuilder<Builder, ListExtensionsResponse> {
    private static final SdkField<List<ExtensionDetails>> EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Extensions").getter(ListExtensionsResponse.getter(ListExtensionsResponse::extensions)).setter(ListExtensionsResponse.setter(Builder::extensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExtensionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExtensionsResponse.getter(ListExtensionsResponse::nextToken)).setter(ListExtensionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExtensionDetails> extensions;
    private final String nextToken;

    private ListExtensionsResponse(BuilderImpl builder) {
        super(builder);
        this.extensions = builder.extensions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExtensions() {
        return this.extensions != null && !(this.extensions instanceof SdkAutoConstructList);
    }

    public final List<ExtensionDetails> extensions() {
        return this.extensions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtensions() ? this.extensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExtensionsResponse)) {
            return false;
        }
        ListExtensionsResponse other = (ListExtensionsResponse)((Object)obj);
        return this.hasExtensions() == other.hasExtensions() && Objects.equals(this.extensions(), other.extensions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExtensionsResponse").add("Extensions", this.hasExtensions() ? this.extensions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Extensions": {
                return Optional.ofNullable(clazz.cast(this.extensions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExtensionsResponse, T> g) {
        return obj -> g.apply((ListExtensionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksResponse.BuilderImpl
    implements Builder {
        private List<ExtensionDetails> extensions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExtensionsResponse model) {
            super(model);
            this.extensions(model.extensions);
            this.nextToken(model.nextToken);
        }

        public final List<ExtensionDetails.Builder> getExtensions() {
            List<ExtensionDetails.Builder> result = ExtensionDetailsListCopier.copyToBuilder(this.extensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtensions(Collection<ExtensionDetails.BuilderImpl> extensions) {
            this.extensions = ExtensionDetailsListCopier.copyFromBuilder(extensions);
        }

        @Override
        public final Builder extensions(Collection<ExtensionDetails> extensions) {
            this.extensions = ExtensionDetailsListCopier.copy(extensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensions(ExtensionDetails ... extensions) {
            this.extensions(Arrays.asList(extensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensions(Consumer<ExtensionDetails.Builder> ... extensions) {
            this.extensions(Stream.of(extensions).map(c -> (ExtensionDetails)((ExtensionDetails.Builder)ExtensionDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExtensionsResponse build() {
            return new ListExtensionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExtensionsResponse> {
        public Builder extensions(Collection<ExtensionDetails> var1);

        public Builder extensions(ExtensionDetails ... var1);

        public Builder extensions(Consumer<ExtensionDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

