/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSnapshotsRequest extends GameSparksRequest implements
        ToCopyableBuilder<ListSnapshotsRequest.Builder, ListSnapshotsRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameName").getter(getter(ListSnapshotsRequest::gameName)).setter(setter(Builder::gameName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSnapshotsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSnapshotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String gameName;

    private final Integer maxResults;

    private final String nextToken;

    private ListSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the game.
     * </p>
     * 
     * @return The name of the game.
     */
    public final String gameName() {
        return gameName;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * <p>
     * Use this parameter with NextToken to get results as a set of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return.</p>
     *         <p>
     *         Use this parameter with NextToken to get results as a set of sequential pages.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token that indicates the start of the next sequential page of results.
     * </p>
     * <p>
     * Use the token that is returned with a previous call to this operation. To start at the beginning of the result
     * set, do not specify a value.
     * </p>
     * 
     * @return The token that indicates the start of the next sequential page of results.</p>
     *         <p>
     *         Use the token that is returned with a previous call to this operation. To start at the beginning of the
     *         result set, do not specify a value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotsRequest)) {
            return false;
        }
        ListSnapshotsRequest other = (ListSnapshotsRequest) obj;
        return Objects.equals(gameName(), other.gameName()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSnapshotsRequest").add("GameName", gameName()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameName":
            return Optional.ofNullable(clazz.cast(gameName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotsRequest, T> g) {
        return obj -> g.apply((ListSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSnapshotsRequest> {
        /**
         * <p>
         * The name of the game.
         * </p>
         * 
         * @param gameName
         *        The name of the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameName(String gameName);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * <p>
         * Use this parameter with NextToken to get results as a set of sequential pages.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.</p>
         *        <p>
         *        Use this parameter with NextToken to get results as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token that indicates the start of the next sequential page of results.
         * </p>
         * <p>
         * Use the token that is returned with a previous call to this operation. To start at the beginning of the
         * result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        The token that indicates the start of the next sequential page of results.</p>
         *        <p>
         *        Use the token that is returned with a previous call to this operation. To start at the beginning of
         *        the result set, do not specify a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameSparksRequest.BuilderImpl implements Builder {
        private String gameName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotsRequest model) {
            super(model);
            gameName(model.gameName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getGameName() {
            return gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSnapshotsRequest build() {
            return new ListSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
