/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamesparks.model.GameSparksResponse;
import software.amazon.awssdk.services.gamesparks.model.StageDeploymentListCopier;
import software.amazon.awssdk.services.gamesparks.model.StageDeploymentSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStageDeploymentsResponse
extends GameSparksResponse
implements ToCopyableBuilder<Builder, ListStageDeploymentsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStageDeploymentsResponse.getter(ListStageDeploymentsResponse::nextToken)).setter(ListStageDeploymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<StageDeploymentSummary>> STAGE_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StageDeployments").getter(ListStageDeploymentsResponse.getter(ListStageDeploymentsResponse::stageDeployments)).setter(ListStageDeploymentsResponse.setter(Builder::stageDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageDeployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageDeploymentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STAGE_DEPLOYMENTS_FIELD));
    private final String nextToken;
    private final List<StageDeploymentSummary> stageDeployments;

    private ListStageDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.stageDeployments = builder.stageDeployments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStageDeployments() {
        return this.stageDeployments != null && !(this.stageDeployments instanceof SdkAutoConstructList);
    }

    public final List<StageDeploymentSummary> stageDeployments() {
        return this.stageDeployments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStageDeployments() ? this.stageDeployments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStageDeploymentsResponse)) {
            return false;
        }
        ListStageDeploymentsResponse other = (ListStageDeploymentsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStageDeployments() == other.hasStageDeployments() && Objects.equals(this.stageDeployments(), other.stageDeployments());
    }

    public final String toString() {
        return ToString.builder((String)"ListStageDeploymentsResponse").add("NextToken", (Object)this.nextToken()).add("StageDeployments", this.hasStageDeployments() ? this.stageDeployments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StageDeployments": {
                return Optional.ofNullable(clazz.cast(this.stageDeployments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStageDeploymentsResponse, T> g) {
        return obj -> g.apply((ListStageDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StageDeploymentSummary> stageDeployments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStageDeploymentsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.stageDeployments(model.stageDeployments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StageDeploymentSummary.Builder> getStageDeployments() {
            List<StageDeploymentSummary.Builder> result = StageDeploymentListCopier.copyToBuilder(this.stageDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStageDeployments(Collection<StageDeploymentSummary.BuilderImpl> stageDeployments) {
            this.stageDeployments = StageDeploymentListCopier.copyFromBuilder(stageDeployments);
        }

        @Override
        public final Builder stageDeployments(Collection<StageDeploymentSummary> stageDeployments) {
            this.stageDeployments = StageDeploymentListCopier.copy(stageDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageDeployments(StageDeploymentSummary ... stageDeployments) {
            this.stageDeployments(Arrays.asList(stageDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageDeployments(Consumer<StageDeploymentSummary.Builder> ... stageDeployments) {
            this.stageDeployments(Stream.of(stageDeployments).map(c -> (StageDeploymentSummary)((StageDeploymentSummary.Builder)StageDeploymentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStageDeploymentsResponse build() {
            return new ListStageDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStageDeploymentsResponse> {
        public Builder nextToken(String var1);

        public Builder stageDeployments(Collection<StageDeploymentSummary> var1);

        public Builder stageDeployments(StageDeploymentSummary ... var1);

        public Builder stageDeployments(Consumer<StageDeploymentSummary.Builder> ... var1);
    }
}

