/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.services.gamesparks.model.SectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGameConfigurationRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, GetGameConfigurationRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameName").getter(GetGameConfigurationRequest.getter(GetGameConfigurationRequest::gameName)).setter(GetGameConfigurationRequest.setter(Builder::gameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()}).build();
    private static final SdkField<List<String>> SECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sections").getter(GetGameConfigurationRequest.getter(GetGameConfigurationRequest::sections)).setter(GetGameConfigurationRequest.setter(Builder::sections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Sections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD, SECTIONS_FIELD));
    private final String gameName;
    private final List<String> sections;

    private GetGameConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.sections = builder.sections;
    }

    public final String gameName() {
        return this.gameName;
    }

    public final boolean hasSections() {
        return this.sections != null && !(this.sections instanceof SdkAutoConstructList);
    }

    public final List<String> sections() {
        return this.sections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSections() ? this.sections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGameConfigurationRequest)) {
            return false;
        }
        GetGameConfigurationRequest other = (GetGameConfigurationRequest)((Object)obj);
        return Objects.equals(this.gameName(), other.gameName()) && this.hasSections() == other.hasSections() && Objects.equals(this.sections(), other.sections());
    }

    public final String toString() {
        return ToString.builder((String)"GetGameConfigurationRequest").add("GameName", (Object)this.gameName()).add("Sections", this.hasSections() ? this.sections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameName": {
                return Optional.ofNullable(clazz.cast(this.gameName()));
            }
            case "Sections": {
                return Optional.ofNullable(clazz.cast(this.sections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGameConfigurationRequest, T> g) {
        return obj -> g.apply((GetGameConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String gameName;
        private List<String> sections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetGameConfigurationRequest model) {
            super(model);
            this.gameName(model.gameName);
            this.sections(model.sections);
        }

        public final String getGameName() {
            return this.gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final Collection<String> getSections() {
            if (this.sections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sections;
        }

        public final void setSections(Collection<String> sections) {
            this.sections = SectionListCopier.copy(sections);
        }

        @Override
        public final Builder sections(Collection<String> sections) {
            this.sections = SectionListCopier.copy(sections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sections(String ... sections) {
            this.sections(Arrays.asList(sections));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGameConfigurationRequest build() {
            return new GetGameConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGameConfigurationRequest> {
        public Builder gameName(String var1);

        public Builder sections(Collection<String> var1);

        public Builder sections(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

