/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gameliftstreams.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLaunchArgListCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.LocationListCopier;
import software.amazon.awssdk.services.gameliftstreams.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartStreamSessionRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, StartStreamSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::clientToken)).setter(StartStreamSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::description)).setter(StartStreamSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::identifier)).setter(StartStreamSessionRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::protocolAsString)).setter(StartStreamSessionRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> SIGNAL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignalRequest").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::signalRequest)).setter(StartStreamSessionRequest.setter(Builder::signalRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalRequest").build()}).build();
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationIdentifier").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::applicationIdentifier)).setter(StartStreamSessionRequest.setter(Builder::applicationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifier").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::userId)).setter(StartStreamSessionRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<List<String>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locations").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::locations)).setter(StartStreamSessionRequest.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CONNECTION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionTimeoutSeconds").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::connectionTimeoutSeconds)).setter(StartStreamSessionRequest.setter(Builder::connectionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeoutSeconds").build()}).build();
    private static final SdkField<Integer> SESSION_LENGTH_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionLengthSeconds").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::sessionLengthSeconds)).setter(StartStreamSessionRequest.setter(Builder::sessionLengthSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLengthSeconds").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_LAUNCH_ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalLaunchArgs").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::additionalLaunchArgs)).setter(StartStreamSessionRequest.setter(Builder::additionalLaunchArgs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLaunchArgs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalEnvironmentVariables").getter(StartStreamSessionRequest.getter(StartStreamSessionRequest::additionalEnvironmentVariables)).setter(StartStreamSessionRequest.setter(Builder::additionalEnvironmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, IDENTIFIER_FIELD, PROTOCOL_FIELD, SIGNAL_REQUEST_FIELD, APPLICATION_IDENTIFIER_FIELD, USER_ID_FIELD, LOCATIONS_FIELD, CONNECTION_TIMEOUT_SECONDS_FIELD, SESSION_LENGTH_SECONDS_FIELD, ADDITIONAL_LAUNCH_ARGS_FIELD, ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartStreamSessionRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String description;
    private final String identifier;
    private final String protocol;
    private final String signalRequest;
    private final String applicationIdentifier;
    private final String userId;
    private final List<String> locations;
    private final Integer connectionTimeoutSeconds;
    private final Integer sessionLengthSeconds;
    private final List<String> additionalLaunchArgs;
    private final Map<String, String> additionalEnvironmentVariables;

    private StartStreamSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.identifier = builder.identifier;
        this.protocol = builder.protocol;
        this.signalRequest = builder.signalRequest;
        this.applicationIdentifier = builder.applicationIdentifier;
        this.userId = builder.userId;
        this.locations = builder.locations;
        this.connectionTimeoutSeconds = builder.connectionTimeoutSeconds;
        this.sessionLengthSeconds = builder.sessionLengthSeconds;
        this.additionalLaunchArgs = builder.additionalLaunchArgs;
        this.additionalEnvironmentVariables = builder.additionalEnvironmentVariables;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String signalRequest() {
        return this.signalRequest;
    }

    public final String applicationIdentifier() {
        return this.applicationIdentifier;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<String> locations() {
        return this.locations;
    }

    public final Integer connectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public final Integer sessionLengthSeconds() {
        return this.sessionLengthSeconds;
    }

    public final boolean hasAdditionalLaunchArgs() {
        return this.additionalLaunchArgs != null && !(this.additionalLaunchArgs instanceof SdkAutoConstructList);
    }

    public final List<String> additionalLaunchArgs() {
        return this.additionalLaunchArgs;
    }

    public final boolean hasAdditionalEnvironmentVariables() {
        return this.additionalEnvironmentVariables != null && !(this.additionalEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEnvironmentVariables() {
        return this.additionalEnvironmentVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLengthSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalLaunchArgs() ? this.additionalLaunchArgs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEnvironmentVariables() ? this.additionalEnvironmentVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamSessionRequest)) {
            return false;
        }
        StartStreamSessionRequest other = (StartStreamSessionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.signalRequest(), other.signalRequest()) && Objects.equals(this.applicationIdentifier(), other.applicationIdentifier()) && Objects.equals(this.userId(), other.userId()) && this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations()) && Objects.equals(this.connectionTimeoutSeconds(), other.connectionTimeoutSeconds()) && Objects.equals(this.sessionLengthSeconds(), other.sessionLengthSeconds()) && this.hasAdditionalLaunchArgs() == other.hasAdditionalLaunchArgs() && Objects.equals(this.additionalLaunchArgs(), other.additionalLaunchArgs()) && this.hasAdditionalEnvironmentVariables() == other.hasAdditionalEnvironmentVariables() && Objects.equals(this.additionalEnvironmentVariables(), other.additionalEnvironmentVariables());
    }

    public final String toString() {
        return ToString.builder((String)"StartStreamSessionRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("Identifier", (Object)this.identifier()).add("Protocol", (Object)this.protocolAsString()).add("SignalRequest", (Object)(this.signalRequest() == null ? null : "*** Sensitive Data Redacted ***")).add("ApplicationIdentifier", (Object)this.applicationIdentifier()).add("UserId", (Object)this.userId()).add("Locations", this.hasLocations() ? this.locations() : null).add("ConnectionTimeoutSeconds", (Object)this.connectionTimeoutSeconds()).add("SessionLengthSeconds", (Object)this.sessionLengthSeconds()).add("AdditionalLaunchArgs", this.hasAdditionalLaunchArgs() ? this.additionalLaunchArgs() : null).add("AdditionalEnvironmentVariables", this.hasAdditionalEnvironmentVariables() ? this.additionalEnvironmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SignalRequest": {
                return Optional.ofNullable(clazz.cast(this.signalRequest()));
            }
            case "ApplicationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.applicationIdentifier()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
            case "ConnectionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.connectionTimeoutSeconds()));
            }
            case "SessionLengthSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionLengthSeconds()));
            }
            case "AdditionalLaunchArgs": {
                return Optional.ofNullable(clazz.cast(this.additionalLaunchArgs()));
            }
            case "AdditionalEnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.additionalEnvironmentVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("SignalRequest", SIGNAL_REQUEST_FIELD);
        map.put("ApplicationIdentifier", APPLICATION_IDENTIFIER_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        map.put("ConnectionTimeoutSeconds", CONNECTION_TIMEOUT_SECONDS_FIELD);
        map.put("SessionLengthSeconds", SESSION_LENGTH_SECONDS_FIELD);
        map.put("AdditionalLaunchArgs", ADDITIONAL_LAUNCH_ARGS_FIELD);
        map.put("AdditionalEnvironmentVariables", ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartStreamSessionRequest, T> g) {
        return obj -> g.apply((StartStreamSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String identifier;
        private String protocol;
        private String signalRequest;
        private String applicationIdentifier;
        private String userId;
        private List<String> locations = DefaultSdkAutoConstructList.getInstance();
        private Integer connectionTimeoutSeconds;
        private Integer sessionLengthSeconds;
        private List<String> additionalLaunchArgs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> additionalEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamSessionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.identifier(model.identifier);
            this.protocol(model.protocol);
            this.signalRequest(model.signalRequest);
            this.applicationIdentifier(model.applicationIdentifier);
            this.userId(model.userId);
            this.locations(model.locations);
            this.connectionTimeoutSeconds(model.connectionTimeoutSeconds);
            this.sessionLengthSeconds(model.sessionLengthSeconds);
            this.additionalLaunchArgs(model.additionalLaunchArgs);
            this.additionalEnvironmentVariables(model.additionalEnvironmentVariables);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getSignalRequest() {
            return this.signalRequest;
        }

        public final void setSignalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
        }

        @Override
        public final Builder signalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
            return this;
        }

        public final String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getLocations() {
            if (this.locations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.locations;
        }

        public final void setLocations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
        }

        @Override
        public final Builder locations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(String ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        public final Integer getConnectionTimeoutSeconds() {
            return this.connectionTimeoutSeconds;
        }

        public final void setConnectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        }

        @Override
        public final Builder connectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        public final Integer getSessionLengthSeconds() {
            return this.sessionLengthSeconds;
        }

        public final void setSessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
        }

        @Override
        public final Builder sessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
            return this;
        }

        public final Collection<String> getAdditionalLaunchArgs() {
            if (this.additionalLaunchArgs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalLaunchArgs;
        }

        public final void setAdditionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
        }

        @Override
        public final Builder additionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLaunchArgs(String ... additionalLaunchArgs) {
            this.additionalLaunchArgs(Arrays.asList(additionalLaunchArgs));
            return this;
        }

        public final Map<String, String> getAdditionalEnvironmentVariables() {
            if (this.additionalEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEnvironmentVariables;
        }

        public final void setAdditionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
        }

        @Override
        public final Builder additionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStreamSessionRequest build() {
            return new StartStreamSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartStreamSessionRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder identifier(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder signalRequest(String var1);

        public Builder applicationIdentifier(String var1);

        public Builder userId(String var1);

        public Builder locations(Collection<String> var1);

        public Builder locations(String ... var1);

        public Builder connectionTimeoutSeconds(Integer var1);

        public Builder sessionLengthSeconds(Integer var1);

        public Builder additionalLaunchArgs(Collection<String> var1);

        public Builder additionalLaunchArgs(String ... var1);

        public Builder additionalEnvironmentVariables(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

