/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.IdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateApplicationsRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, DisassociateApplicationsRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(DisassociateApplicationsRequest.getter(DisassociateApplicationsRequest::identifier)).setter(DisassociateApplicationsRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<List<String>> APPLICATION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationIdentifiers").getter(DisassociateApplicationsRequest.getter(DisassociateApplicationsRequest::applicationIdentifiers)).setter(DisassociateApplicationsRequest.setter(Builder::applicationIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, APPLICATION_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateApplicationsRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final List<String> applicationIdentifiers;

    private DisassociateApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.applicationIdentifiers = builder.applicationIdentifiers;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasApplicationIdentifiers() {
        return this.applicationIdentifiers != null && !(this.applicationIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> applicationIdentifiers() {
        return this.applicationIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationIdentifiers() ? this.applicationIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateApplicationsRequest)) {
            return false;
        }
        DisassociateApplicationsRequest other = (DisassociateApplicationsRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && this.hasApplicationIdentifiers() == other.hasApplicationIdentifiers() && Objects.equals(this.applicationIdentifiers(), other.applicationIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateApplicationsRequest").add("Identifier", (Object)this.identifier()).add("ApplicationIdentifiers", this.hasApplicationIdentifiers() ? this.applicationIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "ApplicationIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.applicationIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("ApplicationIdentifiers", APPLICATION_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateApplicationsRequest, T> g) {
        return obj -> g.apply((DisassociateApplicationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private List<String> applicationIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateApplicationsRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.applicationIdentifiers(model.applicationIdentifiers);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Collection<String> getApplicationIdentifiers() {
            if (this.applicationIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationIdentifiers;
        }

        public final void setApplicationIdentifiers(Collection<String> applicationIdentifiers) {
            this.applicationIdentifiers = IdentifiersCopier.copy(applicationIdentifiers);
        }

        @Override
        public final Builder applicationIdentifiers(Collection<String> applicationIdentifiers) {
            this.applicationIdentifiers = IdentifiersCopier.copy(applicationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIdentifiers(String ... applicationIdentifiers) {
            this.applicationIdentifiers(Arrays.asList(applicationIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateApplicationsRequest build() {
            return new DisassociateApplicationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateApplicationsRequest> {
        public Builder identifier(String var1);

        public Builder applicationIdentifiers(Collection<String> var1);

        public Builder applicationIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

