/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuntimeEnvironmentType {
    PROTON("PROTON"),
    WINDOWS("WINDOWS"),
    UBUNTU("UBUNTU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuntimeEnvironmentType> VALUE_MAP;
    private final String value;

    private RuntimeEnvironmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuntimeEnvironmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuntimeEnvironmentType> knownValues() {
        EnumSet<RuntimeEnvironmentType> knownValues = EnumSet.allOf(RuntimeEnvironmentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuntimeEnvironmentType.class, RuntimeEnvironmentType::toString);
    }
}

