/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFleetCapacityRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateFleetCapacityRequest.Builder, UpdateFleetCapacityRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(UpdateFleetCapacityRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<Integer> DESIRED_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredInstances").getter(getter(UpdateFleetCapacityRequest::desiredInstances))
            .setter(setter(Builder::desiredInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstances").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(UpdateFleetCapacityRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(UpdateFleetCapacityRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(UpdateFleetCapacityRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            DESIRED_INSTANCES_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetId;

    private final Integer desiredInstances;

    private final Integer minSize;

    private final Integer maxSize;

    private final String location;

    private UpdateFleetCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.desiredInstances = builder.desiredInstances;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.location = builder.location;
    }

    /**
     * <p>
     * A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN
     *         value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The number of Amazon EC2 instances you want to maintain in the specified fleet location. This value must fall
     * between the minimum and maximum size limits. Changes in desired instance value can take up to 1 minute to be
     * reflected when viewing the fleet's capacity settings.
     * </p>
     * 
     * @return The number of Amazon EC2 instances you want to maintain in the specified fleet location. This value must
     *         fall between the minimum and maximum size limits. Changes in desired instance value can take up to 1
     *         minute to be reflected when viewing the fleet's capacity settings.
     */
    public final Integer desiredInstances() {
        return desiredInstances;
    }

    /**
     * <p>
     * The minimum number of instances that are allowed in the specified fleet location. If this parameter is not set,
     * the default is 0.
     * </p>
     * 
     * @return The minimum number of instances that are allowed in the specified fleet location. If this parameter is
     *         not set, the default is 0.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum number of instances that are allowed in the specified fleet location. If this parameter is not set,
     * the default is 1.
     * </p>
     * 
     * @return The maximum number of instances that are allowed in the specified fleet location. If this parameter is
     *         not set, the default is 1.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The name of a remote location to update fleet capacity settings for, in the form of an Amazon Web Services Region
     * code such as <code>us-west-2</code>.
     * </p>
     * 
     * @return The name of a remote location to update fleet capacity settings for, in the form of an Amazon Web
     *         Services Region code such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(desiredInstances());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetCapacityRequest)) {
            return false;
        }
        UpdateFleetCapacityRequest other = (UpdateFleetCapacityRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(desiredInstances(), other.desiredInstances())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(maxSize(), other.maxSize())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFleetCapacityRequest").add("FleetId", fleetId())
                .add("DesiredInstances", desiredInstances()).add("MinSize", minSize()).add("MaxSize", maxSize())
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "DesiredInstances":
            return Optional.ofNullable(clazz.cast(desiredInstances()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("DesiredInstances", DESIRED_INSTANCES_FIELD);
        map.put("MinSize", MIN_SIZE_FIELD);
        map.put("MaxSize", MAX_SIZE_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetCapacityRequest, T> g) {
        return obj -> g.apply((UpdateFleetCapacityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFleetCapacityRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN
         * value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or
         *        ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The number of Amazon EC2 instances you want to maintain in the specified fleet location. This value must fall
         * between the minimum and maximum size limits. Changes in desired instance value can take up to 1 minute to be
         * reflected when viewing the fleet's capacity settings.
         * </p>
         * 
         * @param desiredInstances
         *        The number of Amazon EC2 instances you want to maintain in the specified fleet location. This value
         *        must fall between the minimum and maximum size limits. Changes in desired instance value can take up
         *        to 1 minute to be reflected when viewing the fleet's capacity settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInstances(Integer desiredInstances);

        /**
         * <p>
         * The minimum number of instances that are allowed in the specified fleet location. If this parameter is not
         * set, the default is 0.
         * </p>
         * 
         * @param minSize
         *        The minimum number of instances that are allowed in the specified fleet location. If this parameter is
         *        not set, the default is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum number of instances that are allowed in the specified fleet location. If this parameter is not
         * set, the default is 1.
         * </p>
         * 
         * @param maxSize
         *        The maximum number of instances that are allowed in the specified fleet location. If this parameter is
         *        not set, the default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The name of a remote location to update fleet capacity settings for, in the form of an Amazon Web Services
         * Region code such as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        The name of a remote location to update fleet capacity settings for, in the form of an Amazon Web
         *        Services Region code such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private Integer desiredInstances;

        private Integer minSize;

        private Integer maxSize;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetCapacityRequest model) {
            super(model);
            fleetId(model.fleetId);
            desiredInstances(model.desiredInstances);
            minSize(model.minSize);
            maxSize(model.maxSize);
            location(model.location);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final Integer getDesiredInstances() {
            return desiredInstances;
        }

        public final void setDesiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
        }

        @Override
        public final Builder desiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetCapacityRequest build() {
            return new UpdateFleetCapacityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
