/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateGameSessionResponse extends GameLiftResponse implements
        ToCopyableBuilder<TerminateGameSessionResponse.Builder, TerminateGameSessionResponse> {
    private static final SdkField<GameSession> GAME_SESSION_FIELD = SdkField.<GameSession> builder(MarshallingType.SDK_POJO)
            .memberName("GameSession").getter(getter(TerminateGameSessionResponse::gameSession))
            .setter(setter(Builder::gameSession)).constructor(GameSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GameSession gameSession;

    private TerminateGameSessionResponse(BuilderImpl builder) {
        super(builder);
        this.gameSession = builder.gameSession;
    }

    /**
     * Returns the value of the GameSession property for this object.
     * 
     * @return The value of the GameSession property for this object.
     */
    public final GameSession gameSession() {
        return gameSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateGameSessionResponse)) {
            return false;
        }
        TerminateGameSessionResponse other = (TerminateGameSessionResponse) obj;
        return Objects.equals(gameSession(), other.gameSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateGameSessionResponse").add("GameSession", gameSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSession":
            return Optional.ofNullable(clazz.cast(gameSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameSession", GAME_SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TerminateGameSessionResponse, T> g) {
        return obj -> g.apply((TerminateGameSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, TerminateGameSessionResponse> {
        /**
         * Sets the value of the GameSession property for this object.
         *
         * @param gameSession
         *        The new value for the GameSession property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSession(GameSession gameSession);

        /**
         * Sets the value of the GameSession property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GameSession.Builder} avoiding the need to
         * create one manually via {@link GameSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameSession.Builder#build()} is called immediately and its result
         * is passed to {@link #gameSession(GameSession)}.
         * 
         * @param gameSession
         *        a consumer that will call methods on {@link GameSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSession(GameSession)
         */
        default Builder gameSession(Consumer<GameSession.Builder> gameSession) {
            return gameSession(GameSession.builder().applyMutation(gameSession).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameSession gameSession;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateGameSessionResponse model) {
            super(model);
            gameSession(model.gameSession);
        }

        public final GameSession.Builder getGameSession() {
            return gameSession != null ? gameSession.toBuilder() : null;
        }

        public final void setGameSession(GameSession.BuilderImpl gameSession) {
            this.gameSession = gameSession != null ? gameSession.build() : null;
        }

        @Override
        public final Builder gameSession(GameSession gameSession) {
            this.gameSession = gameSession;
            return this;
        }

        @Override
        public TerminateGameSessionResponse build() {
            return new TerminateGameSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
