/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a UDP ping beacon that can be used to measure network latency between a player device and an Amazon
 * GameLift Servers hosting location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PingBeacon implements SdkPojo, Serializable, ToCopyableBuilder<PingBeacon.Builder, PingBeacon> {
    private static final SdkField<UDPEndpoint> UDP_ENDPOINT_FIELD = SdkField.<UDPEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("UDPEndpoint").getter(getter(PingBeacon::udpEndpoint)).setter(setter(Builder::udpEndpoint))
            .constructor(UDPEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UDPEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UDP_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UDPEndpoint udpEndpoint;

    private PingBeacon(BuilderImpl builder) {
        this.udpEndpoint = builder.udpEndpoint;
    }

    /**
     * <p>
     * The domain name and port of the UDP ping beacon.
     * </p>
     * 
     * @return The domain name and port of the UDP ping beacon.
     */
    public final UDPEndpoint udpEndpoint() {
        return udpEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(udpEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PingBeacon)) {
            return false;
        }
        PingBeacon other = (PingBeacon) obj;
        return Objects.equals(udpEndpoint(), other.udpEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PingBeacon").add("UDPEndpoint", udpEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UDPEndpoint":
            return Optional.ofNullable(clazz.cast(udpEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UDPEndpoint", UDP_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PingBeacon, T> g) {
        return obj -> g.apply((PingBeacon) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PingBeacon> {
        /**
         * <p>
         * The domain name and port of the UDP ping beacon.
         * </p>
         * 
         * @param udpEndpoint
         *        The domain name and port of the UDP ping beacon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpEndpoint(UDPEndpoint udpEndpoint);

        /**
         * <p>
         * The domain name and port of the UDP ping beacon.
         * </p>
         * This is a convenience method that creates an instance of the {@link UDPEndpoint.Builder} avoiding the need to
         * create one manually via {@link UDPEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UDPEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #udpEndpoint(UDPEndpoint)}.
         * 
         * @param udpEndpoint
         *        a consumer that will call methods on {@link UDPEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #udpEndpoint(UDPEndpoint)
         */
        default Builder udpEndpoint(Consumer<UDPEndpoint.Builder> udpEndpoint) {
            return udpEndpoint(UDPEndpoint.builder().applyMutation(udpEndpoint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UDPEndpoint udpEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(PingBeacon model) {
            udpEndpoint(model.udpEndpoint);
        }

        public final UDPEndpoint.Builder getUdpEndpoint() {
            return udpEndpoint != null ? udpEndpoint.toBuilder() : null;
        }

        public final void setUdpEndpoint(UDPEndpoint.BuilderImpl udpEndpoint) {
            this.udpEndpoint = udpEndpoint != null ? udpEndpoint.build() : null;
        }

        @Override
        public final Builder udpEndpoint(UDPEndpoint udpEndpoint) {
            this.udpEndpoint = udpEndpoint;
            return this;
        }

        @Override
        public PingBeacon build() {
            return new PingBeacon(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
