/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard output for each
 * container in logs, including game session logs. You can select from the following methods:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogConfiguration.Builder, LogConfiguration> {
    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogDestination").getter(getter(LogConfiguration::logDestinationAsString))
            .setter(setter(Builder::logDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestination").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(LogConfiguration::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupArn").getter(getter(LogConfiguration::logGroupArn)).setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_DESTINATION_FIELD,
            S3_BUCKET_NAME_FIELD, LOG_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logDestination;

    private final String s3BucketName;

    private final String logGroupArn;

    private LogConfiguration(BuilderImpl builder) {
        this.logDestination = builder.logDestination;
        this.s3BucketName = builder.s3BucketName;
        this.logGroupArn = builder.logGroupArn;
    }

    /**
     * <p>
     * The type of log collection to use for a fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each
     * container emits a log stream, which is organized in the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home
     * Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> -- Don't collect container logs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logDestination}
     * will return {@link LogDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logDestinationAsString}.
     * </p>
     * 
     * @return The type of log collection to use for a fleet.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define.
     *         Each container emits a log stream, which is organized in the log group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the
     *         fleet's home Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> -- Don't collect container logs.
     *         </p>
     *         </li>
     * @see LogDestination
     */
    public final LogDestination logDestination() {
        return LogDestination.fromValue(logDestination);
    }

    /**
     * <p>
     * The type of log collection to use for a fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each
     * container emits a log stream, which is organized in the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home
     * Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> -- Don't collect container logs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logDestination}
     * will return {@link LogDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logDestinationAsString}.
     * </p>
     * 
     * @return The type of log collection to use for a fleet.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define.
     *         Each container emits a log stream, which is organized in the log group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the
     *         fleet's home Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> -- Don't collect container logs.
     *         </p>
     *         </li>
     * @see LogDestination
     */
    public final String logDestinationAsString() {
        return logDestination;
    }

    /**
     * <p>
     * If log destination is <code>S3</code>, logs are sent to the specified Amazon S3 bucket name.
     * </p>
     * 
     * @return If log destination is <code>S3</code>, logs are sent to the specified Amazon S3 bucket name.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * If log destination is <code>CLOUDWATCH</code>, logs are sent to the specified log group in Amazon CloudWatch.
     * </p>
     * 
     * @return If log destination is <code>CLOUDWATCH</code>, logs are sent to the specified log group in Amazon
     *         CloudWatch.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logDestinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration) obj;
        return Objects.equals(logDestinationAsString(), other.logDestinationAsString())
                && Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(logGroupArn(), other.logGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfiguration").add("LogDestination", logDestinationAsString())
                .add("S3BucketName", s3BucketName()).add("LogGroupArn", logGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogDestination":
            return Optional.ofNullable(clazz.cast(logDestinationAsString()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "LogGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogDestination", LOG_DESTINATION_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("LogGroupArn", LOG_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfiguration> {
        /**
         * <p>
         * The type of log collection to use for a fleet.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each
         * container emits a log stream, which is organized in the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's
         * home Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> -- Don't collect container logs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param logDestination
         *        The type of log collection to use for a fleet.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you
         *        define. Each container emits a log stream, which is organized in the log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the
         *        fleet's home Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> -- Don't collect container logs.
         *        </p>
         *        </li>
         * @see LogDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDestination
         */
        Builder logDestination(String logDestination);

        /**
         * <p>
         * The type of log collection to use for a fleet.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each
         * container emits a log stream, which is organized in the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's
         * home Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> -- Don't collect container logs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param logDestination
         *        The type of log collection to use for a fleet.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you
         *        define. Each container emits a log stream, which is organized in the log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the
         *        fleet's home Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> -- Don't collect container logs.
         *        </p>
         *        </li>
         * @see LogDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDestination
         */
        Builder logDestination(LogDestination logDestination);

        /**
         * <p>
         * If log destination is <code>S3</code>, logs are sent to the specified Amazon S3 bucket name.
         * </p>
         * 
         * @param s3BucketName
         *        If log destination is <code>S3</code>, logs are sent to the specified Amazon S3 bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * If log destination is <code>CLOUDWATCH</code>, logs are sent to the specified log group in Amazon CloudWatch.
         * </p>
         * 
         * @param logGroupArn
         *        If log destination is <code>CLOUDWATCH</code>, logs are sent to the specified log group in Amazon
         *        CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String logDestination;

        private String s3BucketName;

        private String logGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            logDestination(model.logDestination);
            s3BucketName(model.s3BucketName);
            logGroupArn(model.logGroupArn);
        }

        public final String getLogDestination() {
            return logDestination;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        @Override
        public final Builder logDestination(LogDestination logDestination) {
            this.logDestination(logDestination == null ? null : logDestination.toString());
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        @Override
        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
