/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComputeResponse extends GameLiftResponse implements
        ToCopyableBuilder<ListComputeResponse.Builder, ListComputeResponse> {
    private static final SdkField<List<Compute>> COMPUTE_LIST_FIELD = SdkField
            .<List<Compute>> builder(MarshallingType.LIST)
            .memberName("ComputeList")
            .getter(getter(ListComputeResponse::computeList))
            .setter(setter(Builder::computeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Compute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Compute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListComputeResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Compute> computeList;

    private final String nextToken;

    private ListComputeResponse(BuilderImpl builder) {
        super(builder);
        this.computeList = builder.computeList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputeList() {
        return computeList != null && !(computeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of compute resources in the specified fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeList} method.
     * </p>
     * 
     * @return A list of compute resources in the specified fleet.
     */
    public final List<Compute> computeList() {
        return computeList;
    }

    /**
     * <p>
     * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return A token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeList() ? computeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputeResponse)) {
            return false;
        }
        ListComputeResponse other = (ListComputeResponse) obj;
        return hasComputeList() == other.hasComputeList() && Objects.equals(computeList(), other.computeList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComputeResponse").add("ComputeList", hasComputeList() ? computeList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeList":
            return Optional.ofNullable(clazz.cast(computeList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputeList", COMPUTE_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputeResponse, T> g) {
        return obj -> g.apply((ListComputeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListComputeResponse> {
        /**
         * <p>
         * A list of compute resources in the specified fleet.
         * </p>
         * 
         * @param computeList
         *        A list of compute resources in the specified fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeList(Collection<Compute> computeList);

        /**
         * <p>
         * A list of compute resources in the specified fleet.
         * </p>
         * 
         * @param computeList
         *        A list of compute resources in the specified fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeList(Compute... computeList);

        /**
         * <p>
         * A list of compute resources in the specified fleet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.Compute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.Compute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.Compute.Builder#build()} is called immediately and its
         * result is passed to {@link #computeList(List<Compute>)}.
         * 
         * @param computeList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.Compute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeList(java.util.Collection<Compute>)
         */
        Builder computeList(Consumer<Compute.Builder>... computeList);

        /**
         * <p>
         * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<Compute> computeList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputeResponse model) {
            super(model);
            computeList(model.computeList);
            nextToken(model.nextToken);
        }

        public final List<Compute.Builder> getComputeList() {
            List<Compute.Builder> result = ComputeListCopier.copyToBuilder(this.computeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeList(Collection<Compute.BuilderImpl> computeList) {
            this.computeList = ComputeListCopier.copyFromBuilder(computeList);
        }

        @Override
        public final Builder computeList(Collection<Compute> computeList) {
            this.computeList = ComputeListCopier.copy(computeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeList(Compute... computeList) {
            computeList(Arrays.asList(computeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeList(Consumer<Compute.Builder>... computeList) {
            computeList(Stream.of(computeList).map(c -> Compute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComputeResponse build() {
            return new ListComputeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
