/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetLocationUtilizationResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetLocationUtilizationResponse.Builder, DescribeFleetLocationUtilizationResponse> {
    private static final SdkField<FleetUtilization> FLEET_UTILIZATION_FIELD = SdkField
            .<FleetUtilization> builder(MarshallingType.SDK_POJO).memberName("FleetUtilization")
            .getter(getter(DescribeFleetLocationUtilizationResponse::fleetUtilization)).setter(setter(Builder::fleetUtilization))
            .constructor(FleetUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetUtilization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_UTILIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FleetUtilization fleetUtilization;

    private DescribeFleetLocationUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.fleetUtilization = builder.fleetUtilization;
    }

    /**
     * <p>
     * Utilization information for the requested fleet location. Utilization objects are returned only for fleets and
     * locations that currently exist.
     * </p>
     * 
     * @return Utilization information for the requested fleet location. Utilization objects are returned only for
     *         fleets and locations that currently exist.
     */
    public final FleetUtilization fleetUtilization() {
        return fleetUtilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetUtilization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetLocationUtilizationResponse)) {
            return false;
        }
        DescribeFleetLocationUtilizationResponse other = (DescribeFleetLocationUtilizationResponse) obj;
        return Objects.equals(fleetUtilization(), other.fleetUtilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetLocationUtilizationResponse").add("FleetUtilization", fleetUtilization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetUtilization":
            return Optional.ofNullable(clazz.cast(fleetUtilization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetUtilization", FLEET_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetLocationUtilizationResponse, T> g) {
        return obj -> g.apply((DescribeFleetLocationUtilizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetLocationUtilizationResponse> {
        /**
         * <p>
         * Utilization information for the requested fleet location. Utilization objects are returned only for fleets
         * and locations that currently exist.
         * </p>
         * 
         * @param fleetUtilization
         *        Utilization information for the requested fleet location. Utilization objects are returned only for
         *        fleets and locations that currently exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetUtilization(FleetUtilization fleetUtilization);

        /**
         * <p>
         * Utilization information for the requested fleet location. Utilization objects are returned only for fleets
         * and locations that currently exist.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetUtilization.Builder} avoiding the
         * need to create one manually via {@link FleetUtilization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetUtilization.Builder#build()} is called immediately and its
         * result is passed to {@link #fleetUtilization(FleetUtilization)}.
         * 
         * @param fleetUtilization
         *        a consumer that will call methods on {@link FleetUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetUtilization(FleetUtilization)
         */
        default Builder fleetUtilization(Consumer<FleetUtilization.Builder> fleetUtilization) {
            return fleetUtilization(FleetUtilization.builder().applyMutation(fleetUtilization).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private FleetUtilization fleetUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetLocationUtilizationResponse model) {
            super(model);
            fleetUtilization(model.fleetUtilization);
        }

        public final FleetUtilization.Builder getFleetUtilization() {
            return fleetUtilization != null ? fleetUtilization.toBuilder() : null;
        }

        public final void setFleetUtilization(FleetUtilization.BuilderImpl fleetUtilization) {
            this.fleetUtilization = fleetUtilization != null ? fleetUtilization.build() : null;
        }

        @Override
        public final Builder fleetUtilization(FleetUtilization fleetUtilization) {
            this.fleetUtilization = fleetUtilization;
            return this;
        }

        @Override
        public DescribeFleetLocationUtilizationResponse build() {
            return new DescribeFleetLocationUtilizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
