/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGameServerGroupRequest extends GameLiftRequest implements
        ToCopyableBuilder<DeleteGameServerGroupRequest.Builder, DeleteGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(DeleteGameServerGroupRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> DELETE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeleteOption").getter(getter(DeleteGameServerGroupRequest::deleteOptionAsString))
            .setter(setter(Builder::deleteOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            DELETE_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gameServerGroupName;

    private final String deleteOption;

    private DeleteGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.deleteOption = builder.deleteOption;
    }

    /**
     * <p>
     * A unique identifier for the game server group. Use either the name or ARN value.
     * </p>
     * 
     * @return A unique identifier for the game server group. Use either the name or ARN value.
     */
    public final String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * The type of delete to perform. Options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling group only when
     * it has no game servers that are in <code>UTILIZED</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers regardless of
     * their utilization status, and the Amazon EC2 Auto Scaling group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto Scaling group
     * as is.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deleteOption} will
     * return {@link GameServerGroupDeleteOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deleteOptionAsString}.
     * </p>
     * 
     * @return The type of delete to perform. Options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling group
     *         only when it has no game servers that are in <code>UTILIZED</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers
     *         regardless of their utilization status, and the Amazon EC2 Auto Scaling group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto Scaling
     *         group as is.
     *         </p>
     *         </li>
     * @see GameServerGroupDeleteOption
     */
    public final GameServerGroupDeleteOption deleteOption() {
        return GameServerGroupDeleteOption.fromValue(deleteOption);
    }

    /**
     * <p>
     * The type of delete to perform. Options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling group only when
     * it has no game servers that are in <code>UTILIZED</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers regardless of
     * their utilization status, and the Amazon EC2 Auto Scaling group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto Scaling group
     * as is.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deleteOption} will
     * return {@link GameServerGroupDeleteOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deleteOptionAsString}.
     * </p>
     * 
     * @return The type of delete to perform. Options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling group
     *         only when it has no game servers that are in <code>UTILIZED</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers
     *         regardless of their utilization status, and the Amazon EC2 Auto Scaling group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto Scaling
     *         group as is.
     *         </p>
     *         </li>
     * @see GameServerGroupDeleteOption
     */
    public final String deleteOptionAsString() {
        return deleteOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGameServerGroupRequest)) {
            return false;
        }
        DeleteGameServerGroupRequest other = (DeleteGameServerGroupRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName())
                && Objects.equals(deleteOptionAsString(), other.deleteOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGameServerGroupRequest").add("GameServerGroupName", gameServerGroupName())
                .add("DeleteOption", deleteOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "DeleteOption":
            return Optional.ofNullable(clazz.cast(deleteOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
        map.put("DeleteOption", DELETE_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGameServerGroupRequest, T> g) {
        return obj -> g.apply((DeleteGameServerGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGameServerGroupRequest> {
        /**
         * <p>
         * A unique identifier for the game server group. Use either the name or ARN value.
         * </p>
         * 
         * @param gameServerGroupName
         *        A unique identifier for the game server group. Use either the name or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * The type of delete to perform. Options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling group only
         * when it has no game servers that are in <code>UTILIZED</code> status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers regardless of
         * their utilization status, and the Amazon EC2 Auto Scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto Scaling
         * group as is.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deleteOption
         *        The type of delete to perform. Options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling
         *        group only when it has no game servers that are in <code>UTILIZED</code> status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers
         *        regardless of their utilization status, and the Amazon EC2 Auto Scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto
         *        Scaling group as is.
         *        </p>
         *        </li>
         * @see GameServerGroupDeleteOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerGroupDeleteOption
         */
        Builder deleteOption(String deleteOption);

        /**
         * <p>
         * The type of delete to perform. Options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling group only
         * when it has no game servers that are in <code>UTILIZED</code> status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers regardless of
         * their utilization status, and the Amazon EC2 Auto Scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto Scaling
         * group as is.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deleteOption
         *        The type of delete to perform. Options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling
         *        group only when it has no game servers that are in <code>UTILIZED</code> status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers
         *        regardless of their utilization status, and the Amazon EC2 Auto Scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto
         *        Scaling group as is.
         *        </p>
         *        </li>
         * @see GameServerGroupDeleteOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerGroupDeleteOption
         */
        Builder deleteOption(GameServerGroupDeleteOption deleteOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String deleteOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGameServerGroupRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            deleteOption(model.deleteOption);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getDeleteOption() {
            return deleteOption;
        }

        public final void setDeleteOption(String deleteOption) {
            this.deleteOption = deleteOption;
        }

        @Override
        public final Builder deleteOption(String deleteOption) {
            this.deleteOption = deleteOption;
            return this;
        }

        @Override
        public final Builder deleteOption(GameServerGroupDeleteOption deleteOption) {
            this.deleteOption(deleteOption == null ? null : deleteOption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGameServerGroupRequest build() {
            return new DeleteGameServerGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
