/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.gamelift.internal.GameLiftServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.gamelift.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchResponse;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.ConflictException;
import software.amazon.awssdk.services.gamelift.model.CreateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.CreateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.CreateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.CreateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.CreateContainerFleetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateContainerFleetResponse;
import software.amazon.awssdk.services.gamelift.model.CreateContainerGroupDefinitionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateContainerGroupDefinitionResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreateLocationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateLocationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.CreateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteContainerFleetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteContainerFleetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteContainerGroupDefinitionRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteContainerGroupDefinitionResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteLocationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest;
import software.amazon.awssdk.services.gamelift.model.DeregisterComputeResponse;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeComputeRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeContainerFleetRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeContainerFleetResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeContainerGroupDefinitionRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeContainerGroupDefinitionResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetDeploymentRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetDeploymentResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.gamelift.model.FleetCapacityExceededException;
import software.amazon.awssdk.services.gamelift.model.GameLiftException;
import software.amazon.awssdk.services.gamelift.model.GameSessionFullException;
import software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse;
import software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenRequest;
import software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse;
import software.amazon.awssdk.services.gamelift.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.gamelift.model.InternalServiceException;
import software.amazon.awssdk.services.gamelift.model.InvalidFleetStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidGameSessionStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidRequestException;
import software.amazon.awssdk.services.gamelift.model.LimitExceededException;
import software.amazon.awssdk.services.gamelift.model.ListAliasesRequest;
import software.amazon.awssdk.services.gamelift.model.ListAliasesResponse;
import software.amazon.awssdk.services.gamelift.model.ListBuildsRequest;
import software.amazon.awssdk.services.gamelift.model.ListBuildsResponse;
import software.amazon.awssdk.services.gamelift.model.ListComputeRequest;
import software.amazon.awssdk.services.gamelift.model.ListComputeResponse;
import software.amazon.awssdk.services.gamelift.model.ListContainerFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerFleetsResponse;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionVersionsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionVersionsResponse;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse;
import software.amazon.awssdk.services.gamelift.model.ListFleetDeploymentsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetDeploymentsResponse;
import software.amazon.awssdk.services.gamelift.model.ListFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServersRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServersResponse;
import software.amazon.awssdk.services.gamelift.model.ListLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.ListLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.ListScriptsRequest;
import software.amazon.awssdk.services.gamelift.model.ListScriptsResponse;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gamelift.model.NotFoundException;
import software.amazon.awssdk.services.gamelift.model.NotReadyException;
import software.amazon.awssdk.services.gamelift.model.OutOfCapacityException;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest;
import software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsRequest;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.TagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.TagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.TaggingFailedException;
import software.amazon.awssdk.services.gamelift.model.TerminalRoutingStrategyException;
import software.amazon.awssdk.services.gamelift.model.TerminateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.TerminateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.UnauthorizedException;
import software.amazon.awssdk.services.gamelift.model.UnsupportedRegionException;
import software.amazon.awssdk.services.gamelift.model.UntagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.UntagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateContainerFleetRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateContainerFleetResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateContainerGroupDefinitionRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateContainerGroupDefinitionResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.transform.AcceptMatchRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ClaimGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateContainerFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateContainerGroupDefinitionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateFleetLocationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateGameSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateLocationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateMatchmakingRuleSetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreatePlayerSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreatePlayerSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateVpcPeeringAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.CreateVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteContainerFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteContainerGroupDefinitionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteFleetLocationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteLocationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteMatchmakingRuleSetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteVpcPeeringAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeleteVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeregisterComputeRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DeregisterGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeComputeRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeContainerFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeContainerGroupDefinitionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeEc2InstanceLimitsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetAttributesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetCapacityRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetEventsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetLocationAttributesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetLocationCapacityRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetLocationUtilizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetPortSettingsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeFleetUtilizationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameServerInstancesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionDetailsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionQueuesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeGameSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeMatchmakingRuleSetsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribePlayerSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeScalingPoliciesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeVpcPeeringAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetComputeAccessRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetComputeAuthTokenRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetGameSessionLogUrlRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.GetInstanceAccessRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListBuildsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListComputeRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListContainerFleetsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListContainerGroupDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListContainerGroupDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListFleetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListGameServerGroupsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListGameServersRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListLocationsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListScriptsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.RegisterComputeRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.RegisterGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.RequestUploadCredentialsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ResolveAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ResumeGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.SearchGameSessionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartFleetActionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartMatchBackfillRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StartMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopFleetActionsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopGameSessionPlacementRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.StopMatchmakingRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.SuspendGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.TerminateGameSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateBuildRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateContainerFleetRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateContainerGroupDefinitionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetAttributesRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetCapacityRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateFleetPortSettingsRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameServerGroupRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameServerRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameSessionQueueRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateGameSessionRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateMatchmakingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.UpdateScriptRequestMarshaller;
import software.amazon.awssdk.services.gamelift.transform.ValidateMatchmakingRuleSetRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link GameLiftAsyncClient}.
 *
 * @see GameLiftAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGameLiftAsyncClient implements GameLiftAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultGameLiftAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGameLiftAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "GameLift" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may
     * require player acceptance; if so, then matches built with that configuration cannot be completed unless all
     * players accept the proposed match within a specified time limit.
     * </p>
     * <p>
     * When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status
     * <code>REQUIRES_ACCEPTANCE</code>. This is a trigger for your game to get acceptance from all players in each
     * ticket. Calls to this action are only valid for tickets that are in this status; calls for tickets not in this
     * status result in an error.
     * </p>
     * <p>
     * To register acceptance, specify the ticket ID, one or more players, and an acceptance response. When all players
     * have accepted, Amazon GameLift Servers advances the matchmaking tickets to status <code>PLACING</code>, and
     * attempts to create a new game session for the match.
     * </p>
     * <p>
     * If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed
     * match is dropped. Each matchmaking ticket in the failed match is handled as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the ticket has one or more players who rejected the match or failed to respond, the ticket status is set
     * <code>CANCELLED</code> and processing is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * If all players in the ticket accepted the match, the ticket status is returned to <code>SEARCHING</code> to find
     * a new match.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> FlexMatch events</a>
     * (reference)
     * </p>
     *
     * @param acceptMatchRequest
     * @return A Java Future containing the result of the AcceptMatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.AcceptMatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptMatchResponse> acceptMatch(AcceptMatchRequest acceptMatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptMatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptMatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptMatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptMatchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AcceptMatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AcceptMatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptMatchRequest, AcceptMatchResponse>()
                            .withOperationName("AcceptMatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptMatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptMatchRequest));
            CompletableFuture<AcceptMatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Locates an available game server and temporarily reserves it to host gameplay and players. This operation is
     * called from a game client or client service (such as a matchmaker) to request hosting resources for a new game
     * session. In response, Amazon GameLift Servers FleetIQ locates an available game server, places it in
     * <code>CLAIMED</code> status for 60 seconds, and returns connection information that players can use to connect to
     * the game server.
     * </p>
     * <p>
     * To claim a game server, identify a game server group. You can also specify a game server ID, although this
     * approach bypasses Amazon GameLift Servers FleetIQ placement optimization. Optionally, include game data to pass
     * to the game server at the start of a game session, such as a game map or player information. Add filter options
     * to further restrict how a game server is chosen, such as only allowing game servers on <code>ACTIVE</code>
     * instances to be claimed.
     * </p>
     * <p>
     * When a game server is successfully claimed, connection information is returned. A claimed game server's
     * utilization status remains <code>AVAILABLE</code> while the claim status is set to <code>CLAIMED</code> for up to
     * 60 seconds. This time period gives the game server time to update its status to <code>UTILIZED</code> after
     * players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed
     * status and is available to be claimed by another request. The claim time period is a fixed value and is not
     * configurable.
     * </p>
     * <p>
     * If you try to claim a specific game server, this request will fail in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the game server utilization status is <code>UTILIZED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server claim status is <code>CLAIMED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server is running on an instance in <code>DRAINING</code> status and the provided filter option does
     * not allow placing on <code>DRAINING</code> instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param claimGameServerRequest
     * @return A Java Future containing the result of the ClaimGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>OutOfCapacityException The specified game server group has no available game servers to fulfill a
     *         <code>ClaimGameServer</code> request. Clients can retry such requests immediately or after a waiting
     *         period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ClaimGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ClaimGameServerResponse> claimGameServer(ClaimGameServerRequest claimGameServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(claimGameServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, claimGameServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClaimGameServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ClaimGameServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ClaimGameServerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ClaimGameServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ClaimGameServerRequest, ClaimGameServerResponse>()
                            .withOperationName("ClaimGameServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ClaimGameServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(claimGameServerRequest));
            CompletableFuture<ClaimGameServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias
     * provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to
     * another, such as when updating your game build.
     * </p>
     * <p>
     * Amazon GameLift Servers supports two types of routing strategies for aliases: simple and terminal. A simple alias
     * points to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing
     * players to an active fleet. For example, you might use a terminal alias when a game version is no longer
     * supported and you want to direct players to an upgrade site.
     * </p>
     * <p>
     * To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can
     * point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned,
     * including an alias ID and an ARN. You can reassign an alias to another fleet by calling <code>UpdateAlias</code>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                            .withOperationName("CreateAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAliasRequest));
            CompletableFuture<CreateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere
     * </p>
     * <p>
     * Creates a new Amazon GameLift Servers build resource for your game server binary files. Combine game server
     * binaries into a zip file for use with Amazon GameLift Servers.
     * </p>
     * <important>
     * <p>
     * When setting up a new game build for Amazon GameLift Servers, we recommend using the CLI command <b> <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html">upload-build</a> </b>. This
     * helper command combines two tasks: (1) it uploads your build files from a file directory to an Amazon GameLift
     * Servers Amazon S3 location, and (2) it creates a new build resource.
     * </p>
     * </important>
     * <p>
     * You can use the <code>CreateBuild</code> operation in the following scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account
     * that you control. To use this option, you give Amazon GameLift Servers access to the Amazon S3 bucket. With
     * permissions in place, specify a build name, operating system, and the Amazon S3 storage location of your game
     * build.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your build files to a Amazon GameLift Servers Amazon S3 location. To use this option, specify a build name
     * and operating system. This operation creates a new build resource and also returns an Amazon S3 location with
     * temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3
     * location. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html">Uploading Objects</a> in the
     * <i>Amazon S3 Developer Guide</i>. After you upload build files to the Amazon GameLift Servers Amazon S3 location,
     * you can't update them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new build resource with a unique build ID and places it in
     * <code>INITIALIZED</code> status. A build must be in <code>READY</code> status before you can create fleets with
     * it.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">Uploading Your
     * Game</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in Amazon S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createBuildRequest
     * @return A Java Future containing the result of the CreateBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBuildResponse> createBuild(CreateBuildRequest createBuildRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBuildRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBuild");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBuildResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBuildResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateBuildResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBuildRequest, CreateBuildResponse>()
                            .withOperationName("CreateBuild").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBuildRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBuildRequest));
            CompletableFuture<CreateBuildResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Creates a managed fleet of Amazon Elastic Compute Cloud (Amazon EC2) instances to host your containerized game
     * servers. Use this operation to define how to deploy a container architecture onto each fleet instance and
     * configure fleet settings. You can create a container fleet in any Amazon Web Services Regions that Amazon
     * GameLift Servers supports for multi-location fleets. A container fleet can be deployed to a single location or
     * multiple locations. Container fleets are deployed with Amazon Linux 2023 as the instance operating system.
     * </p>
     * <p>
     * Define the fleet's container architecture using container group definitions. Each fleet can have one of the
     * following container group types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The game server container group runs your game server build and dependent software. Amazon GameLift Servers
     * deploys one or more replicas of this container group to each fleet instance. The number of replicas depends on
     * the computing capabilities of the fleet instance in use.
     * </p>
     * </li>
     * <li>
     * <p>
     * An optional per-instance container group might be used to run other software that only needs to run once per
     * instance, such as background services, logging, or test processes. One per-instance container group is deployed
     * to each fleet instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each container group can include the definition for one or more containers. A container definition specifies a
     * container image that is stored in an Amazon Elastic Container Registry (Amazon ECR) public or private repository.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <p>
     * Use this operation to make the following types of requests. Most fleet settings have default values, so you can
     * create a working fleet with a minimal configuration and default values, which you can customize later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a fleet with no container groups. You can configure a container fleet and then add container group
     * definitions later. In this scenario, no fleet instances are deployed, and the fleet can't host game sessions
     * until you add a game server container group definition. Provide the following required parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FleetRoleArn</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a fleet with a game server container group. Provide the following required parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FleetRoleArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GameServerContainerGroupDefinitionName</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a fleet with a game server container group and a per-instance container group. Provide the following
     * required parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FleetRoleArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GameServerContainerGroupDefinitionName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PerInstanceContainerGroupDefinitionName</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, this operation creates a new container fleet resource, places it in <code>PENDING</code> status,
     * and initiates the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>. For fleets with container groups, this workflow starts a fleet deployment and
     * transitions the status to <code>ACTIVE</code>. Fleets without a container group are placed in
     * <code>CREATED</code> status.
     * </p>
     * <p>
     * You can update most of the properties of a fleet, including container group definitions, and deploy the update
     * across all fleet instances. Use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerFleet.html"
     * >UpdateContainerFleet</a> to deploy a new game server version update across the container fleet.
     * </p>
     * <note>
     * <p>
     * A managed fleet's runtime environment depends on the Amazon Machine Image (AMI) version it uses. When a new fleet
     * is created, Amazon GameLift Servers assigns the latest available AMI version to the fleet, and all compute
     * instances in that fleet are deployed with that version. To update the AMI version, you must create a new fleet.
     * As a best practice, we recommend replacing your managed fleets every 30 days to maintain a secure and up-to-date
     * runtime environment for your hosted game servers. For guidance, see <a
     * href="https://docs.aws.amazon.com/gameliftservers/latest/developerguide/security-best-practices.html"> Security
     * best practices for Amazon GameLift Servers</a>.
     * </p>
     * </note>
     *
     * @param createContainerFleetRequest
     * @return A Java Future containing the result of the CreateContainerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateContainerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateContainerFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContainerFleetResponse> createContainerFleet(
            CreateContainerFleetRequest createContainerFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContainerFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContainerFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContainerFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContainerFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateContainerFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContainerFleetRequest, CreateContainerFleetResponse>()
                            .withOperationName("CreateContainerFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateContainerFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContainerFleetRequest));
            CompletableFuture<CreateContainerFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Creates a <code>ContainerGroupDefinition</code> that describes a set of containers for hosting your game server
     * with Amazon GameLift Servers managed containers hosting. An Amazon GameLift Servers container group is similar to
     * a container task or pod. Use container group definitions when you create a container fleet with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerFleet.html"
     * >CreateContainerFleet</a>.
     * </p>
     * <p>
     * A container group definition determines how Amazon GameLift Servers deploys your containers to each instance in a
     * container fleet. You can maintain multiple versions of a container group definition.
     * </p>
     * <p>
     * There are two types of container groups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <b>game server container group</b> has the containers that run your game server application and supporting
     * software. A game server container group can have these container types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Game server container. This container runs your game server. You can define one game server container in a game
     * server container group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Support container. This container runs software in parallel with your game server. You can define up to 8 support
     * containers in a game server group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When building a game server container group definition, you can choose to bundle your game server executable and
     * all dependent software into a single game server container. Alternatively, you can separate the software into one
     * game server container and one or more support containers.
     * </p>
     * <p>
     * On a container fleet instance, a game server container group can be deployed multiple times (depending on the
     * compute resources of the instance). This means that all containers in the container group are replicated
     * together.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <b>per-instance container group</b> has containers for processes that aren't replicated on a container fleet
     * instance. This might include background services, logging, test processes, or processes that need to persist
     * independently of the game server container group. When building a per-instance container group, you can define up
     * to 10 support containers.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This operation requires Identity and Access Management (IAM) permissions to access container images in Amazon ECR
     * repositories. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html"> IAM
     * permissions for Amazon GameLift Servers</a> for help setting the appropriate permissions.
     * </p>
     * </note>
     * <p>
     * <b>Request options</b>
     * </p>
     * <p>
     * Use this operation to make the following types of requests. You can specify values for the minimum required
     * parameters and customize optional values later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a game server container group definition. Provide the following required parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContainerGroupType</code> (<code>GAME_SERVER</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OperatingSystem</code> (omit to use default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalMemoryLimitMebibytes</code> (omit to use default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalVcpuLimit </code>(omit to use default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * At least one <code>GameServerContainerDefinition</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ContainerName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ImageUrl</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PortConfiguration</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ServerSdkVersion</code> (omit to use default value)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a per-instance container group definition. Provide the following required parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContainerGroupType</code> (<code>PER_INSTANCE</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OperatingSystem</code> (omit to use default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalMemoryLimitMebibytes</code> (omit to use default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalVcpuLimit </code>(omit to use default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * At least one <code>SupportContainerDefinition</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ContainerName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ImageUrl</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, this request creates a <code>ContainerGroupDefinition</code> resource and assigns a unique ARN
     * value. You can update most properties of a container group definition by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
     * >UpdateContainerGroupDefinition</a>, and optionally save the update as a new version.
     * </p>
     *
     * @param createContainerGroupDefinitionRequest
     * @return A Java Future containing the result of the CreateContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContainerGroupDefinitionResponse> createContainerGroupDefinition(
            CreateContainerGroupDefinitionRequest createContainerGroupDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContainerGroupDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createContainerGroupDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerGroupDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContainerGroupDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContainerGroupDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateContainerGroupDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContainerGroupDefinitionRequest, CreateContainerGroupDefinitionResponse>()
                            .withOperationName("CreateContainerGroupDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateContainerGroupDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContainerGroupDefinitionRequest));
            CompletableFuture<CreateContainerGroupDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Creates a fleet of compute resources to host your game servers. Use this operation to set up a fleet for the
     * following compute types:
     * </p>
     * <p>
     * <b>Managed EC2 fleet</b>
     * </p>
     * <p>
     * An EC2 fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances. Your game server build is deployed
     * to each fleet instance. Amazon GameLift Servers manages the fleet's instances and controls the lifecycle of game
     * server processes, which host game sessions for players. EC2 fleets can have instances in multiple locations. Each
     * instance in the fleet is designated a <code>Compute</code>.
     * </p>
     * <p>
     * To create an EC2 fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Either <code>BuildId</code> or <code>ScriptId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>EC2</code> (the default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InboundPermissions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InstanceType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FleetType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RuntimeConfiguration</code> with at least one <code>ServerProcesses</code> configuration
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>NEW</code> status while Amazon
     * GameLift Servers initiates the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>. To debug your fleet, fetch logs, view performance metrics or other actions on the
     * fleet, create a development fleet with port 22/3389 open. As a best practice, we recommend opening ports for
     * remote access only when you need them and closing them when you're finished.
     * </p>
     * <p>
     * When the fleet status is ACTIVE, you can adjust capacity settings and turn autoscaling on/off for each location.
     * </p>
     * <note>
     * <p>
     * A managed fleet's runtime environment depends on the Amazon Machine Image (AMI) version it uses. When a new fleet
     * is created, Amazon GameLift Servers assigns the latest available AMI version to the fleet, and all compute
     * instances in that fleet are deployed with that version. To update the AMI version, you must create a new fleet.
     * As a best practice, we recommend replacing your managed fleets every 30 days to maintain a secure and up-to-date
     * runtime environment for your hosted game servers. For guidance, see <a
     * href="https://docs.aws.amazon.com/gameliftservers/latest/developerguide/security-best-practices.html"> Security
     * best practices for Amazon GameLift Servers</a>.
     * </p>
     * </note>
     * <p>
     * <b>Anywhere fleet</b>
     * </p>
     * <p>
     * An Anywhere fleet represents compute resources that are not owned or managed by Amazon GameLift Servers. You
     * might create an Anywhere fleet with your local machine for testing, or use one to host game servers with
     * on-premises hardware or other game hosting solutions.
     * </p>
     * <p>
     * To create an Anywhere fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>ANYWHERE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Locations</code> specifying a custom location
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>ACTIVE</code> status. You can
     * register computes with a fleet in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation"
     * >Debug fleet creation issues</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a>
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift Servers has not yet finished
     *         validating this compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                            .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFleetRequest));
            CompletableFuture<CreateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Adds remote locations to an EC2 and begins populating the new locations with instances. The new instances conform
     * to the fleet's instance type, auto-scaling, and other configuration settings.
     * </p>
     * <note>
     * <p>
     * You can't add remote locations to a fleet that resides in an Amazon Web Services Region that doesn't support
     * multiple locations. Fleets created prior to March 2021 can't support multiple locations.
     * </p>
     * </note>
     * <p>
     * To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.
     * </p>
     * <p>
     * If successful, this operation returns the list of added locations with their status set to <code>NEW</code>.
     * Amazon GameLift Servers initiates the process of starting an instance in each added location. You can track the
     * status of each new location by monitoring location creation events using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-editing.html#fleets-update-locations">
     * Update fleet locations</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * Servers service locations</a> for managed hosting.
     * </p>
     *
     * @param createFleetLocationsRequest
     * @return A Java Future containing the result of the CreateFleetLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift Servers has not yet finished
     *         validating this compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetLocationsResponse> createFleetLocations(
            CreateFleetLocationsRequest createFleetLocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetLocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleetLocations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFleetLocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFleetLocationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFleetLocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetLocationsRequest, CreateFleetLocationsResponse>()
                            .withOperationName("CreateFleetLocations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFleetLocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFleetLocationsRequest));
            CompletableFuture<CreateFleetLocationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Creates a Amazon GameLift Servers FleetIQ game server group for managing game hosting on a collection of Amazon
     * Elastic Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto
     * Scaling group in your Amazon Web Services account, and establishes a link between the two groups. You can view
     * the status of your game server groups in the Amazon GameLift Servers console. Game server group metrics and
     * events are emitted to Amazon CloudWatch.
     * </p>
     * <p>
     * Before creating a new game server group, you must have the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud
     * instances with your game server build. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html"> Launching an Instance from
     * a Launch Template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An IAM role that extends limited access to your Amazon Web Services account to allow Amazon GameLift Servers
     * FleetIQ to create and interact with the Auto Scaling group. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html">Create IAM roles
     * for cross-service interaction</a> in the <i>Amazon GameLift Servers FleetIQ Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch
     * template, and provide a list of instance types that can be used in the group. You must also set initial maximum
     * and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target
     * tracking based on a Amazon GameLift Servers FleetIQ metric.
     * </p>
     * <p>
     * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the
     * Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group,
     * including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling
     * group. Keep in mind that some Auto Scaling group properties are periodically updated by Amazon GameLift Servers
     * FleetIQ as part of its balancing activities to optimize for availability and cost.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param createGameServerGroupRequest
     * @return A Java Future containing the result of the CreateGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGameServerGroupResponse> createGameServerGroup(
            CreateGameServerGroupRequest createGameServerGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGameServerGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGameServerGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGameServerGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGameServerGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGameServerGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGameServerGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGameServerGroupRequest, CreateGameServerGroupResponse>()
                            .withOperationName("CreateGameServerGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGameServerGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGameServerGroupRequest));
            CompletableFuture<CreateGameServerGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available
     * server process to start a game session and retrieves connection information for the new game session. As an
     * alternative, consider using the Amazon GameLift Servers game session placement feature with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a>, which uses the FleetIQ algorithm and queues to optimize the placement process.
     * </p>
     * <p>
     * When creating a game session, you specify exactly where you want to place it and provide a set of game session
     * configuration settings. The target fleet must be in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * You can use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your
     * game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location
     * name, along with your game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in an Anywhere fleet, specify the fleet's custom location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, Amazon GameLift Servers initiates a workflow to start a new game session and returns a
     * <code>GameSession</code> object containing the game session configuration and status. When the game session
     * status is <code>ACTIVE</code>, it is updated with connection information and you can create player sessions for
     * the game session. By default, newly created game sessions are open to new players. You can restrict new player
     * access by using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>
     * to change the game session's player session creation policy.
     * </p>
     * <p>
     * Amazon GameLift Servers retains logs for active for 14 days. To access the logs, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html"
     * >GetGameSessionLogUrl</a> to download the log files.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Servers Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createGameSessionRequest
     * @return A Java Future containing the result of the CreateGameSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>FleetCapacityExceededException The specified fleet has no available instances to fulfill a
     *         <code>CreateGameSession</code> request. Clients can retry such requests immediately or after a waiting
     *         period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>IdempotentParameterMismatchException A game session with this custom ID string already exists in this
     *         fleet. Resolve this conflict before retrying this request.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGameSessionResponse> createGameSession(CreateGameSessionRequest createGameSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGameSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGameSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGameSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGameSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGameSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGameSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGameSessionRequest, CreateGameSessionResponse>()
                            .withOperationName("CreateGameSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGameSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGameSessionRequest));
            CompletableFuture<CreateGameSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to
     * locate the best available placement locations for a new game session, and then prompts the game server process to
     * start a new game session.
     * </p>
     * <p>
     * A game session queue is configured with a set of destinations (Amazon GameLift Servers fleets or aliases) that
     * determine where the queue can place new game sessions. These destinations can span multiple Amazon Web Services
     * Regions, can use different instance types, and can include both Spot and On-Demand fleets. If the queue includes
     * multi-location fleets, the queue can place game sessions in any of a fleet's remote locations.
     * </p>
     * <p>
     * You can configure a queue to determine how it selects the best available placement for a new game session. Queues
     * can prioritize placement decisions based on a combination of location, hosting cost, and player latency. You can
     * set up the queue to use the default prioritization or provide alternate instructions using
     * <code>PriorityConfiguration</code>.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <p>
     * Use this operation to make these common types of requests.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a queue with the minimum required parameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Destinations</code> (This parameter isn't required, but a queue can't make placements without at least one
     * destination.)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a queue with placement notification. Queues that have high placement activity must use a notification
     * system, such as with Amazon Simple Notification Service (Amazon SNS) or Amazon CloudWatch.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required parameters <code>Name</code> and <code>Destinations</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NotificationTarget</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a queue with custom prioritization settings. These custom settings replace the default prioritization
     * configuration for a queue.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required parameters <code>Name</code> and <code>Destinations</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PriorityConfiguration</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a queue with special rules for processing player latency data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required parameters <code>Name</code> and <code>Destinations</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PlayerLatencyPolicies</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, this operation returns a new <code>GameSessionQueue</code> object with an assigned queue ARN. Use
     * the queue's name or ARN when submitting new game session requests with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> or <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html">StartMatchmaking</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html"> Design a game session
     * queue</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html"> Create a game session
     * queue</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">
     * CreateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html"
     * >DescribeGameSessionQueues</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html"
     * >UpdateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html"
     * >DeleteGameSessionQueue</a> | <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createGameSessionQueueRequest
     * @return A Java Future containing the result of the CreateGameSessionQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGameSessionQueueResponse> createGameSessionQueue(
            CreateGameSessionQueueRequest createGameSessionQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGameSessionQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGameSessionQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGameSessionQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGameSessionQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGameSessionQueueResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGameSessionQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGameSessionQueueRequest, CreateGameSessionQueueResponse>()
                            .withOperationName("CreateGameSessionQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGameSessionQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGameSessionQueueRequest));
            CompletableFuture<CreateGameSessionQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Anywhere
     * </p>
     * <p>
     * Creates a custom location for use in an Anywhere fleet.
     * </p>
     *
     * @param createLocationRequest
     * @return A Java Future containing the result of the CreateLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateLocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLocationResponse> createLocation(CreateLocationRequest createLocationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLocationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLocationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLocationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateLocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLocationRequest, CreateLocationResponse>()
                            .withOperationName("CreateLocation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLocationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLocationRequest));
            CompletableFuture<CreateLocationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with Amazon
     * GameLift Servers hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for
     * matching players and forming teams. If you're also using Amazon GameLift Servers hosting, it defines how to start
     * game sessions for each match. Your matchmaking system can use multiple configurations to handle different game
     * scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes
     * consistent with that configuration.
     * </p>
     * <p>
     * To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode
     * (with or without Amazon GameLift Servers hosting); a rule set that specifies how to evaluate players and find
     * acceptable matches; whether player acceptance is required; and the maximum time allowed for a matchmaking
     * attempt. When using FlexMatch with Amazon GameLift Servers hosting, you also need to identify the game session
     * queue to use when starting a game session for the match.
     * </p>
     * <p>
     * In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications.
     * Provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html"> Design a FlexMatch
     * matchmaker</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set up FlexMatch
     * event notification</a>
     * </p>
     *
     * @param createMatchmakingConfigurationRequest
     * @return A Java Future containing the result of the CreateMatchmakingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMatchmakingConfigurationResponse> createMatchmakingConfiguration(
            CreateMatchmakingConfigurationRequest createMatchmakingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMatchmakingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMatchmakingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMatchmakingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMatchmakingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMatchmakingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateMatchmakingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMatchmakingConfigurationRequest, CreateMatchmakingConfigurationResponse>()
                            .withOperationName("CreateMatchmakingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMatchmakingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMatchmakingConfigurationRequest));
            CompletableFuture<CreateMatchmakingConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the
     * number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level
     * or character type.
     * </p>
     * <p>
     * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets
     * must be defined in the same Region as the matchmaking configuration they are used with.
     * </p>
     * <p>
     * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html"
     * >ValidateMatchmakingRuleSet</a> before creating a new rule set.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html">Design a
     * matchmaker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html">Matchmaking with
     * FlexMatch</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createMatchmakingRuleSetRequest
     * @return A Java Future containing the result of the CreateMatchmakingRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMatchmakingRuleSetResponse> createMatchmakingRuleSet(
            CreateMatchmakingRuleSetRequest createMatchmakingRuleSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMatchmakingRuleSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMatchmakingRuleSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMatchmakingRuleSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMatchmakingRuleSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMatchmakingRuleSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateMatchmakingRuleSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMatchmakingRuleSetRequest, CreateMatchmakingRuleSetResponse>()
                            .withOperationName("CreateMatchmakingRuleSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMatchmakingRuleSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMatchmakingRuleSetRequest));
            CompletableFuture<CreateMatchmakingRuleSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Reserves an open player slot in a game session for a player. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. You can add a group of players to a game session with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html"
     * >CreatePlayerSessions</a> .
     * </p>
     * <p>
     * To create a player session, specify a game session ID, player ID, and optionally a set of player data.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for the player and a new <code>PlayerSessions</code> object
     * is returned with a player session ID. The player references the player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift Servers service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createPlayerSessionRequest
     * @return A Java Future containing the result of the CreatePlayerSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidGameSessionStatusException The requested operation would cause a conflict with the current
     *         state of a resource associated with the request and/or the game instance. Resolve the conflict before
     *         retrying.</li>
     *         <li>GameSessionFullException The game instance is currently full and cannot allow the requested player(s)
     *         to join. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreatePlayerSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePlayerSessionResponse> createPlayerSession(
            CreatePlayerSessionRequest createPlayerSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPlayerSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPlayerSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePlayerSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePlayerSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePlayerSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreatePlayerSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePlayerSessionRequest, CreatePlayerSessionResponse>()
                            .withOperationName("CreatePlayerSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePlayerSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPlayerSessionRequest));
            CompletableFuture<CreatePlayerSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Reserves open slots in a game session for a group of players. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. To add a single player to a game session, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html"
     * >CreatePlayerSession</a>
     * </p>
     * <p>
     * To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of
     * player data for each player ID.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for each player, and new <code>PlayerSession</code> objects
     * are returned with player session IDs. Each player references their player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift Servers service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createPlayerSessionsRequest
     * @return A Java Future containing the result of the CreatePlayerSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidGameSessionStatusException The requested operation would cause a conflict with the current
     *         state of a resource associated with the request and/or the game instance. Resolve the conflict before
     *         retrying.</li>
     *         <li>GameSessionFullException The game instance is currently full and cannot allow the requested player(s)
     *         to join. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreatePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePlayerSessionsResponse> createPlayerSessions(
            CreatePlayerSessionsRequest createPlayerSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPlayerSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPlayerSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePlayerSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePlayerSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePlayerSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreatePlayerSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePlayerSessionsRequest, CreatePlayerSessionsResponse>()
                            .withOperationName("CreatePlayerSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePlayerSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPlayerSessionsRequest));
            CompletableFuture<CreatePlayerSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere
     * </p>
     * <p>
     * Creates a new script record for your Amazon GameLift Servers Realtime script. Realtime scripts are JavaScript
     * that provide configuration settings and optional custom game logic for your game. The script is deployed when you
     * create a Amazon GameLift Servers Realtime fleet to host your game sessions. Script logic is executed during an
     * active game session.
     * </p>
     * <p>
     * To create a new script record, specify a script name and provide the script file(s). The script files and all
     * dependencies must be zipped into a single file. You can pull the zip file from either of these locations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A locally available directory. Use the <i>ZipFile</i> parameter for this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the
     * <i>StorageLocation</i> parameter for this option. You'll need to have an Identity Access Management (IAM) role
     * that allows the Amazon GameLift Servers service to access your S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the call is successful, a new script record is created with a unique script ID. If the script file is provided
     * as a local file, the file is uploaded to an Amazon GameLift Servers-owned S3 bucket and the script record's
     * storage location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift Servers
     * accesses the file at this storage location as needed for deployment.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Servers
     * Amazon GameLift Servers Realtime</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set Up a Role for
     * Amazon GameLift Servers Access</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createScriptRequest
     * @return A Java Future containing the result of the CreateScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateScriptResponse> createScript(CreateScriptRequest createScriptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createScriptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createScriptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScript");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateScriptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateScriptResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateScriptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateScriptRequest, CreateScriptResponse>()
                            .withOperationName("CreateScript").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateScriptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createScriptRequest));
            CompletableFuture<CreateScriptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Requests authorization to create or delete a peer connection between the VPC for your Amazon GameLift Servers
     * fleet and a virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers
     * on your fleet to communicate directly with other Amazon Web Services resources. After you've received
     * authorization, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html"
     * >CreateVpcPeeringConnection</a> to establish the peering connection. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Servers Fleets</a>.
     * </p>
     * <p>
     * You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the
     * account that you use to manage your Amazon GameLift Servers fleets. You cannot peer with VPCs that are in
     * different Regions.
     * </p>
     * <p>
     * To request authorization to create a connection, call this operation from the Amazon Web Services account with
     * the VPC that you want to peer to your Amazon GameLift Servers fleet. For example, to enable your game servers to
     * retrieve data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following
     * values: (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that
     * you use to manage Amazon GameLift Servers. If successful, VPC peering is authorized for the specified VPC.
     * </p>
     * <p>
     * To request authorization to delete a connection, call this operation from the Amazon Web Services account with
     * the VPC that is peered with your Amazon GameLift Servers fleet. Identify the following values: (1) VPC ID that
     * you want to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to
     * manage Amazon GameLift Servers.
     * </p>
     * <p>
     * The authorization remains valid for 24 hours unless it is canceled. You must create or delete the peering
     * connection while the authorization is valid.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createVpcPeeringAuthorizationRequest
     * @return A Java Future containing the result of the CreateVpcPeeringAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcPeeringAuthorizationResponse> createVpcPeeringAuthorization(
            CreateVpcPeeringAuthorizationRequest createVpcPeeringAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcPeeringAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVpcPeeringAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcPeeringAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVpcPeeringAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVpcPeeringAuthorizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateVpcPeeringAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcPeeringAuthorizationRequest, CreateVpcPeeringAuthorizationResponse>()
                            .withOperationName("CreateVpcPeeringAuthorization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcPeeringAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcPeeringAuthorizationRequest));
            CompletableFuture<CreateVpcPeeringAuthorizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with
     * the VPC for your Amazon GameLift Servers fleet. VPC peering enables the game servers on your fleet to communicate
     * directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that
     * you have access to, including the account that you use to manage your Amazon GameLift Servers fleets. You cannot
     * peer with VPCs that are in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Servers Fleets</a>.
     * </p>
     * <p>
     * Before calling this operation to establish the peering connection, you first need to use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a> and identify the VPC you want to peer with. Once the authorization for the
     * specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks
     * necessary to peer the two VPCs, including acceptance, updating routing tables, etc.
     * </p>
     * <p>
     * To establish the connection, call this operation from the Amazon Web Services account that is used to manage the
     * Amazon GameLift Servers fleets. Identify the following values: (1) The ID of the fleet you want to be enable a
     * VPC peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3)
     * The ID of the VPC you want to peer with. This operation is asynchronous. If successful, a connection request is
     * created. You can use continuous polling to track the request's status using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html"
     * >DescribeVpcPeeringConnections</a> , or by monitoring fleet events for success or failure using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a> .
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcPeeringConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVpcPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVpcPeeringConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateVpcPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResponse>()
                            .withOperationName("CreateVpcPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcPeeringConnectionRequest));
            CompletableFuture<CreateVpcPeeringConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server
     * process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                            .withOperationName("DeleteAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAliasRequest));
            CompletableFuture<DeleteAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a
     * build does not affect the status of any active fleets using the build, but you can no longer create new fleets
     * with the deleted build.
     * </p>
     * <p>
     * To delete a build, specify the build ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteBuildRequest
     * @return A Java Future containing the result of the DeleteBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBuildResponse> deleteBuild(DeleteBuildRequest deleteBuildRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBuildRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBuild");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBuildResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBuildResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteBuildResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBuildRequest, DeleteBuildResponse>()
                            .withOperationName("DeleteBuild").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBuildRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBuildRequest));
            CompletableFuture<DeleteBuildResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Deletes all resources and information related to a container fleet and shuts down currently running fleet
     * instances, including those in remote locations. The container fleet must be in <code>ACTIVE</code> status to be
     * deleted.
     * </p>
     * <p>
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is
     * changed to <code>DELETING</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers Fleets</a>
     * </p>
     *
     * @param deleteContainerFleetRequest
     * @return A Java Future containing the result of the DeleteContainerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteContainerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteContainerFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContainerFleetResponse> deleteContainerFleet(
            DeleteContainerFleetRequest deleteContainerFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContainerFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContainerFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContainerFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContainerFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteContainerFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContainerFleetRequest, DeleteContainerFleetResponse>()
                            .withOperationName("DeleteContainerFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteContainerFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContainerFleetRequest));
            CompletableFuture<DeleteContainerFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * <b>Request options:</b>
     * </p>
     * <p>
     * Deletes a container group definition.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delete an entire container group definition, including all versions. Specify the container group definition name,
     * or use an ARN value without the version number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a particular version. Specify the container group definition name and a version number, or use an ARN
     * value that includes the version number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keep the newest versions and delete all older versions. Specify the container group definition name and the
     * number of versions to retain. For example, set <code>VersionCountToRetain</code> to 5 to delete all but the five
     * most recent versions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Result</b>
     * </p>
     * <p>
     * If successful, Amazon GameLift Servers removes the container group definition versions that you request deletion
     * for. This request will fail for any requested versions if the following is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the version is being used in an active fleet
     * </p>
     * </li>
     * <li>
     * <p>
     * If the version is being deployed to a fleet in a deployment that's currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the version is designated as a rollback definition in a fleet deployment that's currently in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteContainerGroupDefinitionRequest
     * @return A Java Future containing the result of the DeleteContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContainerGroupDefinitionResponse> deleteContainerGroupDefinition(
            DeleteContainerGroupDefinitionRequest deleteContainerGroupDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContainerGroupDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteContainerGroupDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerGroupDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContainerGroupDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContainerGroupDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteContainerGroupDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContainerGroupDefinitionRequest, DeleteContainerGroupDefinitionResponse>()
                            .withOperationName("DeleteContainerGroupDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteContainerGroupDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContainerGroupDefinitionRequest));
            CompletableFuture<DeleteContainerGroupDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Deletes all resources and information related to a fleet and shuts down any currently running fleet instances,
     * including those in remote locations.
     * </p>
     * <note>
     * <p>
     * If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24
     * hours) by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a>. You don't need to explicitly delete the VPC peering connection.
     * </p>
     * </note>
     * <p>
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is
     * changed to <code>DELETING</code>. When completed, the status switches to <code>TERMINATED</code> and the fleet
     * event <code>FLEET_DELETED</code> is emitted.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers Fleets</a>
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                            .withOperationName("DeleteFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFleetRequest));
            CompletableFuture<DeleteFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Removes locations from a multi-location fleet. When deleting a location, all game server process and all
     * instances that are still active in the location are shut down.
     * </p>
     * <p>
     * To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.
     * </p>
     * <p>
     * If successful, GameLift sets the location status to <code>DELETING</code>, and begins to shut down existing
     * server processes and terminate instances in each location being deleted. When completed, the location status
     * changes to <code>TERMINATED</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     *
     * @param deleteFleetLocationsRequest
     * @return A Java Future containing the result of the DeleteFleetLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetLocationsResponse> deleteFleetLocations(
            DeleteFleetLocationsRequest deleteFleetLocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetLocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleetLocations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetLocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFleetLocationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFleetLocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetLocationsRequest, DeleteFleetLocationsResponse>()
                            .withOperationName("DeleteFleetLocations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetLocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFleetLocationsRequest));
            CompletableFuture<DeleteFleetLocationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Terminates a game server group and permanently deletes the game server group record. You have several options for
     * how these resources are impacted when deleting the game server group. Depending on the type of delete operation
     * selected, this operation might affect these resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The game server group
     * </p>
     * </li>
     * <li>
     * <p>
     * The corresponding Auto Scaling group
     * </p>
     * </li>
     * <li>
     * <p>
     * All game servers that are currently running in the group
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a game server group, identify the game server group to delete and specify the type of delete operation
     * to initiate. Game server groups can only be deleted if they are in <code>ACTIVE</code> or <code>ERROR</code>
     * status.
     * </p>
     * <p>
     * If the delete request is successful, a series of operations are kicked off. The game server group status is
     * changed to <code>DELETE_SCHEDULED</code>, which prevents new game servers from being registered and stops
     * automatic scaling activity. Once all game servers in the game server group are deregistered, Amazon GameLift
     * Servers FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is
     * placed in <code>ERROR</code> status.
     * </p>
     * <p>
     * Amazon GameLift Servers FleetIQ emits delete events to Amazon CloudWatch.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param deleteGameServerGroupRequest
     * @return A Java Future containing the result of the DeleteGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGameServerGroupResponse> deleteGameServerGroup(
            DeleteGameServerGroupRequest deleteGameServerGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGameServerGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGameServerGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGameServerGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGameServerGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGameServerGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGameServerGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGameServerGroupRequest, DeleteGameServerGroupResponse>()
                            .withOperationName("DeleteGameServerGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGameServerGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGameServerGroupRequest));
            CompletableFuture<DeleteGameServerGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Deletes a game session queue. Once a queue is successfully deleted, unfulfilled <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> requests that reference the queue will fail. To delete a queue, specify the queue
     * name.
     * </p>
     *
     * @param deleteGameSessionQueueRequest
     * @return A Java Future containing the result of the DeleteGameSessionQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGameSessionQueueResponse> deleteGameSessionQueue(
            DeleteGameSessionQueueRequest deleteGameSessionQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGameSessionQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGameSessionQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGameSessionQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGameSessionQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGameSessionQueueResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGameSessionQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGameSessionQueueRequest, DeleteGameSessionQueueResponse>()
                            .withOperationName("DeleteGameSessionQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGameSessionQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGameSessionQueueRequest));
            CompletableFuture<DeleteGameSessionQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Anywhere
     * </p>
     * <p>
     * Deletes a custom location.
     * </p>
     * <p>
     * Before deleting a custom location, review any fleets currently using the custom location and deregister the
     * location if it is in use. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html">DeregisterCompute</a>.
     * </p>
     *
     * @param deleteLocationRequest
     * @return A Java Future containing the result of the DeleteLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLocationResponse> deleteLocation(DeleteLocationRequest deleteLocationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLocationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLocationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLocationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteLocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLocationRequest, DeleteLocationResponse>()
                            .withOperationName("DeleteLocation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLocationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLocationRequest));
            CompletableFuture<DeleteLocationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A
     * matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.
     * </p>
     *
     * @param deleteMatchmakingConfigurationRequest
     * @return A Java Future containing the result of the DeleteMatchmakingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMatchmakingConfigurationResponse> deleteMatchmakingConfiguration(
            DeleteMatchmakingConfigurationRequest deleteMatchmakingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMatchmakingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMatchmakingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMatchmakingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMatchmakingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMatchmakingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteMatchmakingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMatchmakingConfigurationRequest, DeleteMatchmakingConfigurationResponse>()
                            .withOperationName("DeleteMatchmakingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMatchmakingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMatchmakingConfigurationRequest));
            CompletableFuture<DeleteMatchmakingConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be
     * deleted if they are currently being used by a matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteMatchmakingRuleSetRequest
     * @return A Java Future containing the result of the DeleteMatchmakingRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMatchmakingRuleSetResponse> deleteMatchmakingRuleSet(
            DeleteMatchmakingRuleSetRequest deleteMatchmakingRuleSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMatchmakingRuleSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMatchmakingRuleSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMatchmakingRuleSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMatchmakingRuleSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMatchmakingRuleSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteMatchmakingRuleSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMatchmakingRuleSetRequest, DeleteMatchmakingRuleSetResponse>()
                            .withOperationName("DeleteMatchmakingRuleSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMatchmakingRuleSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMatchmakingRuleSetRequest));
            CompletableFuture<DeleteMatchmakingRuleSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and Amazon GameLift Servers
     * removes all record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is
     * associated with.
     * </p>
     * <p>
     * To temporarily suspend scaling policies, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html">StopFleetActions</a>.
     * This operation suspends all policies for the fleet.
     * </p>
     *
     * @param deleteScalingPolicyRequest
     * @return A Java Future containing the result of the DeleteScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteScalingPolicyResponse> deleteScalingPolicy(
            DeleteScalingPolicyRequest deleteScalingPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteScalingPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteScalingPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteScalingPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteScalingPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteScalingPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteScalingPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteScalingPolicyRequest, DeleteScalingPolicyResponse>()
                            .withOperationName("DeleteScalingPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteScalingPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteScalingPolicyRequest));
            CompletableFuture<DeleteScalingPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded,
     * they are also deleted (files stored in an S3 bucket are not deleted).
     * </p>
     * <p>
     * To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are
     * deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script
     * record no longer exists, the instance will go into an error state and be unable to host game sessions.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Servers
     * Amazon GameLift Servers Realtime</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteScriptRequest
     * @return A Java Future containing the result of the DeleteScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScript" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteScriptResponse> deleteScript(DeleteScriptRequest deleteScriptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteScriptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteScriptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteScript");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteScriptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteScriptResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteScriptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteScriptRequest, DeleteScriptResponse>()
                            .withOperationName("DeleteScript").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteScriptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteScriptRequest));
            CompletableFuture<DeleteScriptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering
     * connection, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html"
     * >DeleteVpcPeeringConnection</a>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteVpcPeeringAuthorizationRequest
     * @return A Java Future containing the result of the DeleteVpcPeeringAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcPeeringAuthorizationResponse> deleteVpcPeeringAuthorization(
            DeleteVpcPeeringAuthorizationRequest deleteVpcPeeringAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcPeeringAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVpcPeeringAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcPeeringAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVpcPeeringAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVpcPeeringAuthorizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteVpcPeeringAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcPeeringAuthorizationRequest, DeleteVpcPeeringAuthorizationResponse>()
                            .withOperationName("DeleteVpcPeeringAuthorization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVpcPeeringAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVpcPeeringAuthorizationRequest));
            CompletableFuture<DeleteVpcPeeringAuthorizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC
     * peering connection that you want to delete..
     * </p>
     * <p>
     * Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift Servers fleets. Identify the connection to delete by the connection ID and fleet ID.
     * If successful, the connection is removed.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcPeeringConnectionResponse> deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcPeeringConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVpcPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVpcPeeringConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteVpcPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResponse>()
                            .withOperationName("DeleteVpcPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVpcPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVpcPeeringConnectionRequest));
            CompletableFuture<DeleteVpcPeeringConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Anywhere
     * </p>
     * <p>
     * Removes a compute resource from an Anywhere fleet. Deregistered computes can no longer host game sessions through
     * Amazon GameLift Servers. Use this operation with an Anywhere fleet that doesn't use the Amazon GameLift Servers
     * Agent For Anywhere fleets with the Agent, the Agent handles all compute registry tasks for you.
     * </p>
     * <p>
     * To deregister a compute, call this operation from the compute that's being deregistered and specify the compute
     * name and the fleet ID.
     * </p>
     *
     * @param deregisterComputeRequest
     * @return A Java Future containing the result of the DeregisterCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeregisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterCompute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterComputeResponse> deregisterCompute(DeregisterComputeRequest deregisterComputeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterComputeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterComputeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterCompute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterComputeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterComputeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterComputeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterComputeRequest, DeregisterComputeResponse>()
                            .withOperationName("DeregisterCompute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterComputeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterComputeRequest));
            CompletableFuture<DeregisterComputeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Removes the game server from a game server group. As a result of this operation, the deregistered game server can
     * no longer be claimed and will not be returned in a list of active game servers.
     * </p>
     * <p>
     * To deregister a game server, specify the game server group and game server ID. If successful, this operation
     * emits a CloudWatch event with termination timestamp and reason.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param deregisterGameServerRequest
     * @return A Java Future containing the result of the DeregisterGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeregisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterGameServerResponse> deregisterGameServer(
            DeregisterGameServerRequest deregisterGameServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterGameServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterGameServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterGameServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterGameServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterGameServerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterGameServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterGameServerRequest, DeregisterGameServerResponse>()
                            .withOperationName("DeregisterGameServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterGameServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterGameServerRequest));
            CompletableFuture<DeregisterGameServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's
     * target fleet ID only, use <code>ResolveAlias</code>.
     * </p>
     * <p>
     * To get alias properties, specify the alias ID. If successful, the requested alias record is returned.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeAliasRequest
     * @return A Java Future containing the result of the DescribeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAliasResponse> describeAlias(DescribeAliasRequest describeAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAliasRequest, DescribeAliasResponse>()
                            .withOperationName("DescribeAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAliasRequest));
            CompletableFuture<DescribeAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an
     * object containing the build properties is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeBuildRequest
     * @return A Java Future containing the result of the DescribeBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBuildResponse> describeBuild(DescribeBuildRequest describeBuildRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBuildRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBuild");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBuildResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeBuildResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeBuildResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBuildRequest, DescribeBuildResponse>()
                            .withOperationName("DescribeBuild").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBuildRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeBuildRequest));
            CompletableFuture<DescribeBuildResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves properties for a specific compute resource in an Amazon GameLift Servers fleet. You can list all
     * computes in a fleet by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute.html">ListCompute</a>.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <p>
     * Provide the fleet ID and compute name. The compute name varies depending on the type of fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a compute in a managed EC2 fleet, provide an instance ID. Each instance in the fleet is a compute.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a compute in a managed container fleet, provide a compute name. In a container fleet, each game server
     * container group on a fleet instance is assigned a compute name.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a compute in an Anywhere fleet, provide a registered compute name. Anywhere fleet computes are created when
     * you register a hosting resource with the fleet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, this operation returns details for the requested compute resource. Depending on the fleet's
     * compute type, the result includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a managed EC2 fleet, this operation returns information about the EC2 instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an Anywhere fleet, this operation returns information about the registered compute.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComputeRequest
     * @return A Java Future containing the result of the DescribeCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeComputeResponse> describeCompute(DescribeComputeRequest describeComputeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeComputeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeComputeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCompute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeComputeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeComputeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeComputeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeComputeRequest, DescribeComputeResponse>()
                            .withOperationName("DescribeCompute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeComputeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeComputeRequest));
            CompletableFuture<DescribeComputeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Retrieves the properties for a container fleet. When requesting attributes for multiple fleets, use the
     * pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Get container fleet properties for a single fleet. Provide either the fleet ID or ARN value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, a <code>ContainerFleet</code> object is returned. This object includes the fleet properties,
     * including information about the most recent deployment.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     *
     * @param describeContainerFleetRequest
     * @return A Java Future containing the result of the DescribeContainerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeContainerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeContainerFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeContainerFleetResponse> describeContainerFleet(
            DescribeContainerFleetRequest describeContainerFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeContainerFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeContainerFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeContainerFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeContainerFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeContainerFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeContainerFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeContainerFleetRequest, DescribeContainerFleetResponse>()
                            .withOperationName("DescribeContainerFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeContainerFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeContainerFleetRequest));
            CompletableFuture<DescribeContainerFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Retrieves the properties of a container group definition, including all container definitions in the group.
     * </p>
     * <p>
     * <b>Request options:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Retrieve the latest version of a container group definition. Specify the container group definition name only, or
     * use an ARN value without a version number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Retrieve a particular version. Specify the container group definition name and a version number, or use an ARN
     * value that includes the version number.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results:</b>
     * </p>
     * <p>
     * If successful, this operation returns the complete properties of a container group definition version.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeContainerGroupDefinitionRequest
     * @return A Java Future containing the result of the DescribeContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeContainerGroupDefinitionResponse> describeContainerGroupDefinition(
            DescribeContainerGroupDefinitionRequest describeContainerGroupDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeContainerGroupDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeContainerGroupDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeContainerGroupDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeContainerGroupDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeContainerGroupDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeContainerGroupDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeContainerGroupDefinitionRequest, DescribeContainerGroupDefinitionResponse>()
                            .withOperationName("DescribeContainerGroupDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeContainerGroupDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeContainerGroupDefinitionRequest));
            CompletableFuture<DescribeContainerGroupDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance
     * limits control the number of instances, per instance type, per location, that your Amazon Web Services account
     * can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The
     * information returned includes the maximum number of instances allowed and your account's current usage across all
     * fleets. This information can affect your ability to scale your Amazon GameLift Servers fleets. You can request a
     * limit increase for your account by using the <b>Service limits</b> page in the Amazon GameLift Servers console.
     * </p>
     * <p>
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote
     * location. For remote locations, limits also differ based on the combination of home Region and remote location.
     * All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get
     * the limit for a remote location, you must also specify the location. For example, the following requests all
     * return different results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on
     * all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in
     * <code>ap-northeast-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to
     * <code>ca-central-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>eu-west-1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets
     * that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve
     * information for.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside
     * in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location.
     * Optionally, specify a single instance type to retrieve information for.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested
     * instance type.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     *
     * @param describeEc2InstanceLimitsRequest
     * @return A Java Future containing the result of the DescribeEC2InstanceLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeEC2InstanceLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEc2InstanceLimitsResponse> describeEC2InstanceLimits(
            DescribeEc2InstanceLimitsRequest describeEc2InstanceLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEc2InstanceLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEc2InstanceLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEC2InstanceLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEc2InstanceLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEc2InstanceLimitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEc2InstanceLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEc2InstanceLimitsRequest, DescribeEc2InstanceLimitsResponse>()
                            .withOperationName("DescribeEC2InstanceLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEc2InstanceLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEc2InstanceLimitsRequest));
            CompletableFuture<DescribeEc2InstanceLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves core fleet-wide properties for fleets in an Amazon Web Services Region. Properties include the
     * computing hardware and deployment configuration for instances in the fleet.
     * </p>
     * <p>
     * You can use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     *
     * @param describeFleetAttributesRequest
     * @return A Java Future containing the result of the DescribeFleetAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetAttributesResponse> describeFleetAttributes(
            DescribeFleetAttributesRequest describeFleetAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetAttributesRequest, DescribeFleetAttributesResponse>()
                            .withOperationName("DescribeFleetAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetAttributesRequest));
            CompletableFuture<DescribeFleetAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. For a container fleet, this operation also
     * returns counts for game server container groups.
     * </p>
     * <p>
     * With multi-location fleets, this operation retrieves data for the fleet's home Region only. To retrieve capacity
     * for remote locations, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html"
     * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html</a>.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each
     * <code>FleetCapacity</code> object includes a <code>Location</code> property, which is set to the fleet's home
     * Region. Capacity values are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetCapacityRequest
     * @return A Java Future containing the result of the DescribeFleetCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetCapacityResponse> describeFleetCapacity(
            DescribeFleetCapacityRequest describeFleetCapacityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetCapacityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetCapacityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetCapacity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetCapacityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetCapacityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetCapacityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetCapacityRequest, DescribeFleetCapacityResponse>()
                            .withOperationName("DescribeFleetCapacity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetCapacityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetCapacityRequest));
            CompletableFuture<DescribeFleetCapacityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Retrieves information about a managed container fleet deployment.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Get information about the latest deployment for a specific fleet. Provide the fleet ID or ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * Get information about a specific deployment. Provide the fleet ID or ARN and the deployment ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, a <code>FleetDeployment</code> object is returned.
     * </p>
     *
     * @param describeFleetDeploymentRequest
     * @return A Java Future containing the result of the DescribeFleetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetDeploymentResponse> describeFleetDeployment(
            DescribeFleetDeploymentRequest describeFleetDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetDeploymentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetDeploymentRequest, DescribeFleetDeploymentResponse>()
                            .withOperationName("DescribeFleetDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetDeploymentRequest));
            CompletableFuture<DescribeFleetDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet
     * creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated
     * by changes to status and capacity in remote locations.
     * </p>
     * <p>
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set
     * of sequential pages.
     * </p>
     * <p>
     * If successful, a collection of event log entries matching the request are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     *
     * @param describeFleetEventsRequest
     * @return A Java Future containing the result of the DescribeFleetEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetEventsResponse> describeFleetEvents(
            DescribeFleetEventsRequest describeFleetEventsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetEventsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetEventsRequest, DescribeFleetEventsResponse>()
                            .withOperationName("DescribeFleetEvents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetEventsRequest));
            CompletableFuture<DescribeFleetEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet
     * activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned
     * in the order that it is requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet
     * does not have a requested location, no information is returned. This operation does not return the home Region.
     * To get information on a fleet's home Region, call <code>DescribeFleetAttributes</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * Servers service locations</a> for managed hosting
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     * @return A Java Future containing the result of the DescribeFleetLocationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetLocationAttributesResponse> describeFleetLocationAttributes(
            DescribeFleetLocationAttributesRequest describeFleetLocationAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetLocationAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFleetLocationAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetLocationAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetLocationAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetLocationAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetLocationAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetLocationAttributesRequest, DescribeFleetLocationAttributesResponse>()
                            .withOperationName("DescribeFleetLocationAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetLocationAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetLocationAttributesRequest));
            CompletableFuture<DescribeFleetLocationAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity
     * (number of EC2 instances) and some scaling settings for the requested fleet location. For a managed container
     * fleet, this operation also returns counts for game server container groups.
     * </p>
     * <p>
     * Use this operation to retrieve capacity information for a fleet's remote location or home Region (you can also
     * retrieve home Region capacity by calling <code>DescribeFleetCapacity</code>).
     * </p>
     * <p>
     * To retrieve capacity data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * Servers service locations</a> for managed hosting
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetLocationCapacityRequest
     * @return A Java Future containing the result of the DescribeFleetLocationCapacity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetLocationCapacityResponse> describeFleetLocationCapacity(
            DescribeFleetLocationCapacityRequest describeFleetLocationCapacityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetLocationCapacityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFleetLocationCapacityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetLocationCapacity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetLocationCapacityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetLocationCapacityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetLocationCapacityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetLocationCapacityRequest, DescribeFleetLocationCapacityResponse>()
                            .withOperationName("DescribeFleetLocationCapacity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetLocationCapacityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetLocationCapacityRequest));
            CompletableFuture<DescribeFleetLocationCapacityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting
     * activity at the requested location. Use this operation to retrieve utilization information for a fleet's remote
     * location or home Region (you can also retrieve home Region utilization by calling
     * <code>DescribeFleetUtilization</code>).
     * </p>
     * <p>
     * To retrieve utilization data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetUtilization</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * Servers service locations</a> for managed hosting
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetLocationUtilizationRequest
     * @return A Java Future containing the result of the DescribeFleetLocationUtilization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetLocationUtilizationResponse> describeFleetLocationUtilization(
            DescribeFleetLocationUtilizationRequest describeFleetLocationUtilizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetLocationUtilizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFleetLocationUtilizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetLocationUtilization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetLocationUtilizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeFleetLocationUtilizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetLocationUtilizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetLocationUtilizationRequest, DescribeFleetLocationUtilizationResponse>()
                            .withOperationName("DescribeFleetLocationUtilization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetLocationUtilizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetLocationUtilizationRequest));
            CompletableFuture<DescribeFleetLocationUtilizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Retrieves a fleet's inbound connection permissions. Connection permissions specify IP addresses and port settings
     * that incoming traffic can use to access server processes in the fleet. Game server processes that are running in
     * the fleet must use a port that falls within this range.
     * </p>
     * <p>
     * Use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve the port settings for a fleet, identify the fleet's unique identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port
     * setting updates can take time to propagate across all locations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a set of <code>IpPermission</code> objects is returned for the requested fleet ID. When specifying
     * a location, this operation returns a pending status. If the requested fleet has been deleted, the result set is
     * empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     *
     * @param describeFleetPortSettingsRequest
     * @return A Java Future containing the result of the DescribeFleetPortSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetPortSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetPortSettingsResponse> describeFleetPortSettings(
            DescribeFleetPortSettingsRequest describeFleetPortSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetPortSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetPortSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetPortSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetPortSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetPortSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetPortSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetPortSettingsRequest, DescribeFleetPortSettingsResponse>()
                            .withOperationName("DescribeFleetPortSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetPortSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetPortSettingsRequest));
            CompletableFuture<DescribeFleetPortSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     *
     * @param describeFleetUtilizationRequest
     * @return A Java Future containing the result of the DescribeFleetUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetUtilizationResponse> describeFleetUtilization(
            DescribeFleetUtilizationRequest describeFleetUtilizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetUtilizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetUtilizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetUtilization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetUtilizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetUtilizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetUtilizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetUtilizationRequest, DescribeFleetUtilizationResponse>()
                            .withOperationName("DescribeFleetUtilization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetUtilizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetUtilizationRequest));
            CompletableFuture<DescribeFleetUtilizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Retrieves information for a registered game server. Information includes game server status, health check info,
     * and the instance that the game server is running on.
     * </p>
     * <p>
     * To retrieve game server information, specify the game server ID. If successful, the requested game server object
     * is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerRequest
     * @return A Java Future containing the result of the DescribeGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGameServerResponse> describeGameServer(DescribeGameServerRequest describeGameServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGameServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGameServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGameServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGameServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGameServerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGameServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGameServerRequest, DescribeGameServerResponse>()
                            .withOperationName("DescribeGameServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGameServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGameServerRequest));
            CompletableFuture<DescribeGameServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Retrieves information on a game server group. This operation returns only properties related to Amazon GameLift
     * Servers FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template,
     * auto scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.
     * </p>
     * <p>
     * To get attributes for a game server group, provide a group name or ARN value. If successful, a
     * <code>GameServerGroup</code> object is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerGroupRequest
     * @return A Java Future containing the result of the DescribeGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGameServerGroupResponse> describeGameServerGroup(
            DescribeGameServerGroupRequest describeGameServerGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGameServerGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGameServerGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGameServerGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGameServerGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGameServerGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGameServerGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGameServerGroupRequest, DescribeGameServerGroupResponse>()
                            .withOperationName("DescribeGameServerGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGameServerGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGameServerGroupRequest));
            CompletableFuture<DescribeGameServerGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift Servers FleetIQ
     * game server group. Use this operation to detect when instances are active or not available to host new game
     * servers.
     * </p>
     * <p>
     * To request status for all instances in the game server group, provide a game server group ID only. To request
     * status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination
     * parameters to retrieve results in sequential segments. If successful, a collection of
     * <code>GameServerInstance</code> objects is returned.
     * </p>
     * <p>
     * This operation is not designed to be called with every game server claim request; this practice can cause you to
     * exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your
     * cache no more than once every 10 seconds.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerInstancesRequest
     * @return A Java Future containing the result of the DescribeGameServerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGameServerInstancesResponse> describeGameServerInstances(
            DescribeGameServerInstancesRequest describeGameServerInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGameServerInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGameServerInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGameServerInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGameServerInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGameServerInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGameServerInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGameServerInstancesRequest, DescribeGameServerInstancesResponse>()
                            .withOperationName("DescribeGameServerInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGameServerInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGameServerInstancesRequest));
            CompletableFuture<DescribeGameServerInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one
     * or more game sessions in a specific fleet location. You can optionally filter the results by current game session
     * status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet
     * or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on a specific fleet location, provide a
     * fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region
     * or any remote location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for a specific game session, provide the game session ID. This approach looks for the game
     * session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the
     * request.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     * @return A Java Future containing the result of the DescribeGameSessionDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGameSessionDetailsResponse> describeGameSessionDetails(
            DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGameSessionDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGameSessionDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGameSessionDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGameSessionDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGameSessionDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGameSessionDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGameSessionDetailsRequest, DescribeGameSessionDetailsResponse>()
                            .withOperationName("DescribeGameSessionDetails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGameSessionDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGameSessionDetailsRequest));
            CompletableFuture<DescribeGameSessionDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves information, including current status, about a game session placement request.
     * </p>
     * <p>
     * To get game session placement details, specify the placement ID.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessionPlacement</code> should only be used for games in development with low game session
     * usage.
     * </p>
     *
     * @param describeGameSessionPlacementRequest
     * @return A Java Future containing the result of the DescribeGameSessionPlacement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGameSessionPlacementResponse> describeGameSessionPlacement(
            DescribeGameSessionPlacementRequest describeGameSessionPlacementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGameSessionPlacementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGameSessionPlacementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGameSessionPlacement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGameSessionPlacementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGameSessionPlacementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGameSessionPlacementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGameSessionPlacementRequest, DescribeGameSessionPlacementResponse>()
                            .withOperationName("DescribeGameSessionPlacement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGameSessionPlacementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGameSessionPlacementRequest));
            CompletableFuture<DescribeGameSessionPlacementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     * @return A Java Future containing the result of the DescribeGameSessionQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGameSessionQueuesResponse> describeGameSessionQueues(
            DescribeGameSessionQueuesRequest describeGameSessionQueuesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGameSessionQueuesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGameSessionQueuesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGameSessionQueues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGameSessionQueuesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGameSessionQueuesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGameSessionQueuesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGameSessionQueuesRequest, DescribeGameSessionQueuesResponse>()
                            .withOperationName("DescribeGameSessionQueues").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGameSessionQueuesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGameSessionQueuesRequest));
            CompletableFuture<DescribeGameSessionQueuesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results
     * by current game session status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias
     * ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias
     * ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in
     * all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessions</code> should only be used for games in development with low game session usage.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Servers Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeGameSessionsRequest
     * @return A Java Future containing the result of the DescribeGameSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGameSessionsResponse> describeGameSessions(
            DescribeGameSessionsRequest describeGameSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGameSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGameSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGameSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGameSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGameSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGameSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGameSessionsRequest, DescribeGameSessionsResponse>()
                            .withOperationName("DescribeGameSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGameSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGameSessionsRequest));
            CompletableFuture<DescribeGameSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves information about the EC2 instances in an Amazon GameLift Servers managed fleet, including instance ID,
     * connection data, and status. You can use this operation with a multi-location fleet to get location-specific
     * instance information. As an alternative, use the operations <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute"
     * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListCompute</a> and <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute"
     * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute</a> to retrieve information for
     * compute resources, including EC2 and Anywhere fleets.
     * </p>
     * <p>
     * You can call this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get information on all instances in a fleet's home Region, specify the fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on all instances in a fleet's remote location, specify the fleet ID and location name.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on a specific instance in a fleet, specify the fleet ID and instance ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns <code>Instance</code> objects for each requested instance, listed in no
     * particular order. If you call this operation for an Anywhere fleet, you receive an InvalidRequestException.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeInstancesRequest
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstancesResponse> describeInstances(DescribeInstancesRequest describeInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancesRequest, DescribeInstancesResponse>()
                            .withOperationName("DescribeInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInstancesRequest));
            CompletableFuture<DescribeInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a
     * successful match is made--connection information for the resulting new game session.
     * </p>
     * <p>
     * To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket
     * object is returned for each requested ID that currently exists.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track matchmaking ticket status. This practice can
     * cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple
     * Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p/>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch
     * event notification</a>
     * </p>
     *
     * @param describeMatchmakingRequest
     * @return A Java Future containing the result of the DescribeMatchmaking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmaking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMatchmakingResponse> describeMatchmaking(
            DescribeMatchmakingRequest describeMatchmakingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMatchmakingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMatchmakingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMatchmaking");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMatchmakingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMatchmakingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMatchmakingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMatchmakingRequest, DescribeMatchmakingResponse>()
                            .withOperationName("DescribeMatchmaking").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMatchmakingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMatchmakingRequest));
            CompletableFuture<DescribeMatchmakingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     * @return A Java Future containing the result of the DescribeMatchmakingConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMatchmakingConfigurationsResponse> describeMatchmakingConfigurations(
            DescribeMatchmakingConfigurationsRequest describeMatchmakingConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMatchmakingConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMatchmakingConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMatchmakingConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMatchmakingConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMatchmakingConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMatchmakingConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMatchmakingConfigurationsRequest, DescribeMatchmakingConfigurationsResponse>()
                            .withOperationName("DescribeMatchmakingConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMatchmakingConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMatchmakingConfigurationsRequest));
            CompletableFuture<DescribeMatchmakingConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeMatchmakingRuleSetsRequest
     * @return A Java Future containing the result of the DescribeMatchmakingRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMatchmakingRuleSetsResponse> describeMatchmakingRuleSets(
            DescribeMatchmakingRuleSetsRequest describeMatchmakingRuleSetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMatchmakingRuleSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMatchmakingRuleSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMatchmakingRuleSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMatchmakingRuleSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMatchmakingRuleSetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMatchmakingRuleSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMatchmakingRuleSetsRequest, DescribeMatchmakingRuleSetsResponse>()
                            .withOperationName("DescribeMatchmakingRuleSets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMatchmakingRuleSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMatchmakingRuleSetsRequest));
            CompletableFuture<DescribeMatchmakingRuleSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves properties for one or more player sessions.
     * </p>
     * <p>
     * This action can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a specific player session, provide the player session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions in a game session, provide the game session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions for a specific player, provide a player ID only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter
     * this request by player session status. If you provide a specific <code>PlayerSessionId</code> or
     * <code>PlayerId</code>, Amazon GameLift Servers ignores the filter criteria. Use the pagination parameters to
     * retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describePlayerSessionsRequest
     * @return A Java Future containing the result of the DescribePlayerSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePlayerSessionsResponse> describePlayerSessions(
            DescribePlayerSessionsRequest describePlayerSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePlayerSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePlayerSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePlayerSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePlayerSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePlayerSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribePlayerSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePlayerSessionsRequest, DescribePlayerSessionsResponse>()
                            .withOperationName("DescribePlayerSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePlayerSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePlayerSessionsRequest));
            CompletableFuture<DescribePlayerSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves a fleet's runtime configuration settings. The runtime configuration determines which server processes
     * run, and how, on computes in the fleet. For managed EC2 fleets, the runtime configuration describes server
     * processes that run on each fleet instance. You can update a fleet's runtime configuration at any time using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateRuntimeConfiguration.html">
     * UpdateRuntimeConfiguration</a>.
     * </p>
     * <p>
     * To get the current runtime configuration for a fleet, provide the fleet ID.
     * </p>
     * <p>
     * If successful, a <code>RuntimeConfiguration</code> object is returned for the requested fleet. If the requested
     * fleet has been deleted, the result set is empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Servers fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html">Running multiple
     * processes on a fleet</a>
     * </p>
     *
     * @param describeRuntimeConfigurationRequest
     * @return A Java Future containing the result of the DescribeRuntimeConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRuntimeConfigurationResponse> describeRuntimeConfiguration(
            DescribeRuntimeConfigurationRequest describeRuntimeConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRuntimeConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRuntimeConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRuntimeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRuntimeConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRuntimeConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRuntimeConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRuntimeConfigurationRequest, DescribeRuntimeConfigurationResponse>()
                            .withOperationName("DescribeRuntimeConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRuntimeConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRuntimeConfigurationRequest));
            CompletableFuture<DescribeRuntimeConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves all scaling policies applied to a fleet.
     * </p>
     * <p>
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to
     * retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential
     * pages. If successful, set of <code>ScalingPolicy</code> objects is returned for the fleet.
     * </p>
     * <p>
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling
     * policies, which remains ACTIVE.
     * </p>
     *
     * @param describeScalingPoliciesRequest
     * @return A Java Future containing the result of the DescribeScalingPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScalingPoliciesResponse> describeScalingPolicies(
            DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeScalingPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeScalingPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeScalingPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeScalingPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeScalingPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeScalingPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeScalingPoliciesRequest, DescribeScalingPoliciesResponse>()
                            .withOperationName("DescribeScalingPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeScalingPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeScalingPoliciesRequest));
            CompletableFuture<DescribeScalingPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves properties for a Realtime script.
     * </p>
     * <p>
     * To request a script record, specify the script ID. If successful, an object containing the script properties is
     * returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Servers
     * Amazon GameLift Servers Realtime</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeScriptRequest
     * @return A Java Future containing the result of the DescribeScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScript" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScriptResponse> describeScript(DescribeScriptRequest describeScriptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeScriptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeScriptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeScript");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeScriptResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeScriptResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeScriptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeScriptRequest, DescribeScriptResponse>()
                            .withOperationName("DescribeScript").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeScriptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeScriptRequest));
            CompletableFuture<DescribeScriptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation
     * returns all VPC peering authorizations and requests for peering. This includes those initiated and received by
     * this account.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeVpcPeeringAuthorizationsRequest
     * @return A Java Future containing the result of the DescribeVpcPeeringAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcPeeringAuthorizationsResponse> describeVpcPeeringAuthorizations(
            DescribeVpcPeeringAuthorizationsRequest describeVpcPeeringAuthorizationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVpcPeeringAuthorizationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeVpcPeeringAuthorizationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVpcPeeringAuthorizations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVpcPeeringAuthorizationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeVpcPeeringAuthorizationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeVpcPeeringAuthorizationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVpcPeeringAuthorizationsRequest, DescribeVpcPeeringAuthorizationsResponse>()
                            .withOperationName("DescribeVpcPeeringAuthorizations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeVpcPeeringAuthorizationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeVpcPeeringAuthorizationsRequest));
            CompletableFuture<DescribeVpcPeeringAuthorizationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or
     * for one specific fleet ID.
     * </p>
     * <p>
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift Servers fleets. Specify a fleet ID or leave the parameter empty to retrieve all
     * connection records. If successful, the retrieved information includes both active and pending connections. Active
     * connections identify the IpV4 CIDR block that the VPC uses to connect.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeVpcPeeringConnectionsRequest
     * @return A Java Future containing the result of the DescribeVpcPeeringConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcPeeringConnectionsResponse> describeVpcPeeringConnections(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVpcPeeringConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeVpcPeeringConnectionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVpcPeeringConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVpcPeeringConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeVpcPeeringConnectionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeVpcPeeringConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResponse>()
                            .withOperationName("DescribeVpcPeeringConnections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeVpcPeeringConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeVpcPeeringConnectionsRequest));
            CompletableFuture<DescribeVpcPeeringConnectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Container
     * </p>
     * <p>
     * Requests authorization to remotely connect to a hosting resource in a Amazon GameLift Servers managed fleet. This
     * operation is not used with Amazon GameLift Servers Anywhere fleets.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <p>
     * Provide the fleet ID and compute name. The compute name varies depending on the type of fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a compute in a managed EC2 fleet, provide an instance ID. Each instance in the fleet is a compute.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a compute in a managed container fleet, provide a compute name. In a container fleet, each game server
     * container group on a fleet instance is assigned a compute name.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, this operation returns a set of temporary Amazon Web Services credentials, including a two-part
     * access key and a session token.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With a managed EC2 fleet (where compute type is <code>EC2</code>), use these credentials with Amazon EC2 Systems
     * Manager (SSM) to start a session with the compute. For more details, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html#sessions-start-cli"
     * > Starting a session (CLI)</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getComputeAccessRequest
     * @return A Java Future containing the result of the GetComputeAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetComputeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetComputeAccessResponse> getComputeAccess(GetComputeAccessRequest getComputeAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getComputeAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComputeAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComputeAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComputeAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetComputeAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetComputeAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComputeAccessRequest, GetComputeAccessResponse>()
                            .withOperationName("GetComputeAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetComputeAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getComputeAccessRequest));
            CompletableFuture<GetComputeAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Requests an authentication token from Amazon GameLift Servers for a compute resource in an Amazon GameLift
     * Servers fleet. Game servers that are running on the compute use this token to communicate with the Amazon
     * GameLift Servers service, such as when calling the Amazon GameLift Servers server SDK action
     * <code>InitSDK()</code>. Authentication tokens are valid for a limited time span, so you need to request a fresh
     * token before the current token expires.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For managed EC2 fleets (compute type <code>EC2</code>), auth token retrieval and refresh is handled
     * automatically. All game servers that are running on all fleet instances have access to a valid auth token.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Anywhere fleets (compute type <code>ANYWHERE</code>), if you're using the Amazon GameLift Servers Agent, auth
     * token retrieval and refresh is handled automatically for any compute where the Agent is running. If you're not
     * using the Agent, create a mechanism to retrieve and refresh auth tokens for computes that are running game server
     * processes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">Server SDK
     * reference guides</a> (for version 5.x)
     * </p>
     * </li>
     * </ul>
     *
     * @param getComputeAuthTokenRequest
     * @return A Java Future containing the result of the GetComputeAuthToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetComputeAuthToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAuthToken" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComputeAuthTokenResponse> getComputeAuthToken(
            GetComputeAuthTokenRequest getComputeAuthTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getComputeAuthTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComputeAuthTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComputeAuthToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComputeAuthTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetComputeAuthTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetComputeAuthTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComputeAuthTokenRequest, GetComputeAuthTokenResponse>()
                            .withOperationName("GetComputeAuthToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetComputeAuthTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getComputeAuthTokenRequest));
            CompletableFuture<GetComputeAuthTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves the location of stored game session logs for a specified game session on Amazon GameLift Servers
     * managed fleets. When a game session is terminated, Amazon GameLift Servers automatically stores the logs in
     * Amazon S3 and retains them for 14 days. Use this URL to download the logs.
     * </p>
     * <note>
     * <p>
     * See the <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">Amazon
     * Web Services Service Limits</a> page for maximum log file sizes. Log files that exceed this limit are not saved.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param getGameSessionLogUrlRequest
     * @return A Java Future containing the result of the GetGameSessionLogUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetGameSessionLogUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGameSessionLogUrlResponse> getGameSessionLogUrl(
            GetGameSessionLogUrlRequest getGameSessionLogUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGameSessionLogUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGameSessionLogUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGameSessionLogUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGameSessionLogUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGameSessionLogUrlResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetGameSessionLogUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGameSessionLogUrlRequest, GetGameSessionLogUrlResponse>()
                            .withOperationName("GetGameSessionLogUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGameSessionLogUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGameSessionLogUrlRequest));
            CompletableFuture<GetGameSessionLogUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Requests authorization to remotely connect to an instance in an Amazon GameLift Servers managed fleet. Use this
     * operation to connect to instances with game servers that use Amazon GameLift Servers server SDK 4.x or earlier.
     * To connect to instances with game servers that use server SDK 5.x or later, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess"
     * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetComputeAccess</a>.
     * </p>
     * <p>
     * To request access to an instance, specify IDs for the instance and the fleet it belongs to. You can retrieve
     * instance IDs for a fleet by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html">DescribeInstances</a>
     * with the fleet ID.
     * </p>
     * <p>
     * If successful, this operation returns an IP address and credentials. The returned credentials match the operating
     * system of the instance, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a Windows instance: returns a user name and secret (password) for use with a Windows Remote Desktop client.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Linux instance: returns a user name and secret (RSA private key) for use with an SSH client. You must save
     * the secret to a <code>.pem</code> file. If you're using the CLI, see the example <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html#API_GetInstanceAccess_Examples"
     * > Get credentials for a Linux instance</a> for tips on automatically saving the secret to a <code>.pem</code>
     * file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param getInstanceAccessRequest
     * @return A Java Future containing the result of the GetInstanceAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetInstanceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceAccessResponse> getInstanceAccess(GetInstanceAccessRequest getInstanceAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInstanceAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetInstanceAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceAccessRequest, GetInstanceAccessResponse>()
                            .withOperationName("GetInstanceAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInstanceAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInstanceAccessRequest));
            CompletableFuture<GetInstanceAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAliasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                            .withOperationName("ListAliases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAliasesRequest));
            CompletableFuture<ListAliasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listBuildsRequest
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBuildsResponse> listBuilds(ListBuildsRequest listBuildsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBuildsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuildsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuilds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBuildsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListBuildsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListBuildsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBuildsRequest, ListBuildsResponse>().withOperationName("ListBuilds")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBuildsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBuildsRequest));
            CompletableFuture<ListBuildsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves information on the compute resources in an Amazon GameLift Servers fleet. Use the pagination parameters
     * to retrieve results in a set of sequential pages.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Retrieve a list of all computes in a fleet. Specify a fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Retrieve a list of all computes in a specific fleet location. Specify a fleet ID and location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, this operation returns information on a set of computes. Depending on the type of fleet, the
     * result includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a managed EC2 fleet (compute type <code>EC2</code>), this operation returns information about the EC2
     * instance. Compute names are EC2 instance IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an Anywhere fleet (compute type <code>ANYWHERE</code>), this operation returns compute names and details from
     * when the compute was registered with <code>RegisterCompute</code>. This includes
     * <code>GameLiftServiceSdkEndpoint</code> or <code>GameLiftAgentEndpoint</code>.
     * </p>
     * </li>
     * </ul>
     *
     * @param listComputeRequest
     * @return A Java Future containing the result of the ListCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListComputeResponse> listCompute(ListComputeRequest listComputeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listComputeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComputeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCompute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComputeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListComputeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListComputeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComputeRequest, ListComputeResponse>()
                            .withOperationName("ListCompute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListComputeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listComputeRequest));
            CompletableFuture<ListComputeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Retrieves a collection of container fleet resources in an Amazon Web Services Region. For fleets that have
     * multiple locations, this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Get a list of all fleets. Call this operation without specifying a container group definition.
     * </p>
     * </li>
     * <li>
     * <p>
     * Get a list of fleets filtered by container group definition. Provide the container group definition name or ARN
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Amazon GameLift Servers Realtime fleets with a specific configuration script, provide the
     * script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns a collection of container fleets that match the request parameters. A
     * NextToken value is also returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet IDs are returned in no particular order.
     * </p>
     * </note>
     *
     * @param listContainerFleetsRequest
     * @return A Java Future containing the result of the ListContainerFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListContainerFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListContainerFleets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListContainerFleetsResponse> listContainerFleets(
            ListContainerFleetsRequest listContainerFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContainerFleetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContainerFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContainerFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContainerFleetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListContainerFleetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListContainerFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContainerFleetsRequest, ListContainerFleetsResponse>()
                            .withOperationName("ListContainerFleets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListContainerFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContainerFleetsRequest));
            CompletableFuture<ListContainerFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Retrieves all versions of a container group definition. Use the pagination parameters to retrieve results in a
     * set of sequential pages.
     * </p>
     * <p>
     * <b>Request options:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Get all versions of a specified container group definition. Specify the container group definition name or ARN
     * value. (If the ARN value has a version number, it's ignored.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results:</b>
     * </p>
     * <p>
     * If successful, this operation returns the complete properties of a set of container group definition versions
     * that match the request.
     * </p>
     * <note>
     * <p>
     * This operation returns the list of container group definitions in descending version order (latest first).
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listContainerGroupDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListContainerGroupDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListContainerGroupDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListContainerGroupDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListContainerGroupDefinitionVersionsResponse> listContainerGroupDefinitionVersions(
            ListContainerGroupDefinitionVersionsRequest listContainerGroupDefinitionVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContainerGroupDefinitionVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listContainerGroupDefinitionVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContainerGroupDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContainerGroupDefinitionVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListContainerGroupDefinitionVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListContainerGroupDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContainerGroupDefinitionVersionsRequest, ListContainerGroupDefinitionVersionsResponse>()
                            .withOperationName("ListContainerGroupDefinitionVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListContainerGroupDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContainerGroupDefinitionVersionsRequest));
            CompletableFuture<ListContainerGroupDefinitionVersionsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Retrieves container group definitions for the Amazon Web Services account and Amazon Web Services Region. Use the
     * pagination parameters to retrieve results in a set of sequential pages.
     * </p>
     * <p>
     * This operation returns only the latest version of each definition. To retrieve all versions of a container group
     * definition, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitionVersions.html"
     * >ListContainerGroupDefinitionVersions</a>.
     * </p>
     * <p>
     * <b>Request options:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Retrieve the most recent versions of all container group definitions.
     * </p>
     * </li>
     * <li>
     * <p>
     * Retrieve the most recent versions of all container group definitions, filtered by type. Specify the container
     * group type to filter on.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results:</b>
     * </p>
     * <p>
     * If successful, this operation returns the complete properties of a set of container group definition versions
     * that match the request.
     * </p>
     * <note>
     * <p>
     * This operation returns the list of container group definitions in no particular order.
     * </p>
     * </note>
     *
     * @param listContainerGroupDefinitionsRequest
     * @return A Java Future containing the result of the ListContainerGroupDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListContainerGroupDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListContainerGroupDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListContainerGroupDefinitionsResponse> listContainerGroupDefinitions(
            ListContainerGroupDefinitionsRequest listContainerGroupDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContainerGroupDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listContainerGroupDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContainerGroupDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListContainerGroupDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListContainerGroupDefinitionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListContainerGroupDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContainerGroupDefinitionsRequest, ListContainerGroupDefinitionsResponse>()
                            .withOperationName("ListContainerGroupDefinitions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListContainerGroupDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContainerGroupDefinitionsRequest));
            CompletableFuture<ListContainerGroupDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Container
     * </p>
     * <p>
     * Retrieves a collection of container fleet deployments in an Amazon Web Services Region. Use the pagination
     * parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * <b>Request options</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Get a list of all deployments. Call this operation without specifying a fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Get a list of all deployments for a fleet. Specify the container fleet ID or ARN value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Results</b>
     * </p>
     * <p>
     * If successful, this operation returns a list of deployments that match the request parameters. A NextToken value
     * is also returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Deployments are returned starting with the latest.
     * </p>
     * </note>
     *
     * @param listFleetDeploymentsRequest
     * @return A Java Future containing the result of the ListFleetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetDeploymentsResponse> listFleetDeployments(
            ListFleetDeploymentsRequest listFleetDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetDeploymentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleetDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFleetDeploymentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFleetDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetDeploymentsRequest, ListFleetDeploymentsResponse>()
                            .withOperationName("ListFleetDeployments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFleetDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFleetDeploymentsRequest));
            CompletableFuture<ListFleetDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can filter the result set to find
     * only those fleets that are deployed with a specific build or script. For fleets that have multiple locations,
     * this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * You can use operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Amazon GameLift Servers Realtime fleets with a specific configuration script, provide the
     * script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns a list of fleet IDs that match the request parameters. A NextToken value is
     * also returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet IDs are returned in no particular order.
     * </p>
     * </note>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFleetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetsRequest, ListFleetsResponse>().withOperationName("ListFleets")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFleetsRequest));
            CompletableFuture<ListFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Lists a game server groups.
     * </p>
     *
     * @param listGameServerGroupsRequest
     * @return A Java Future containing the result of the ListGameServerGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGameServerGroupsResponse> listGameServerGroups(
            ListGameServerGroupsRequest listGameServerGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGameServerGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGameServerGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGameServerGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGameServerGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGameServerGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGameServerGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGameServerGroupsRequest, ListGameServerGroupsResponse>()
                            .withOperationName("ListGameServerGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGameServerGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGameServerGroupsRequest));
            CompletableFuture<ListGameServerGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2 (FleetIQ)
     * </p>
     * <p>
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt
     * to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential
     * segments.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift Servers FleetIQ
     * Guide</a>
     * </p>
     *
     * @param listGameServersRequest
     * @return A Java Future containing the result of the ListGameServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGameServersResponse> listGameServers(ListGameServersRequest listGameServersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGameServersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGameServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGameServers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGameServersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGameServersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGameServersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGameServersRequest, ListGameServersResponse>()
                            .withOperationName("ListGameServers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGameServersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGameServersRequest));
            CompletableFuture<ListGameServersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Anywhere
     * </p>
     * <p>
     * Lists all custom and Amazon Web Services locations where Amazon GameLift Servers can host game servers.
     * </p>
     * <p>
     * Note that if you call this API using a location that doesn't have a service endpoint, such as one that can only
     * be a remote location in a multi-location fleet, the API returns an error.
     * </p>
     * <p>
     * Consult the table of supported locations in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html">Amazon GameLift Servers
     * service locations</a> to identify home Regions that support single and multi-location fleets.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html">Service locations</a>
     * </p>
     *
     * @param listLocationsRequest
     * @return A Java Future containing the result of the ListLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListLocationsResponse> listLocations(ListLocationsRequest listLocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLocationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLocations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLocationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListLocationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListLocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLocationsRequest, ListLocationsResponse>()
                            .withOperationName("ListLocations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListLocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listLocationsRequest));
            CompletableFuture<ListLocationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in
     * use.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Servers
     * Amazon GameLift Servers Realtime</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listScriptsRequest
     * @return A Java Future containing the result of the ListScripts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListScriptsResponse> listScripts(ListScriptsRequest listScriptsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listScriptsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listScriptsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListScripts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListScriptsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListScriptsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListScriptsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListScriptsRequest, ListScriptsResponse>()
                            .withOperationName("ListScripts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListScriptsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listScriptsRequest));
            CompletableFuture<ListScriptsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2, Anywhere, Container
     * </p>
     * <p>
     * Retrieves all tags assigned to a Amazon GameLift Servers resource. Use resource tags to organize Amazon Web
     * Services resources for a range of purposes. This operation handles the permissions necessary to manage tags for
     * Amazon GameLift Servers resources that support tagging.
     * </p>
     * <p>
     * To list tags for a resource, specify the unique ARN value for the resource.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> EC2
     * </p>
     * <p>
     * Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet's
     * hosting capacity to meet player demand. An active scaling policy instructs Amazon GameLift Servers to track a
     * fleet metric and automatically change the fleet's capacity when a certain threshold is reached. There are two
     * types of scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently
     * manage fleet scaling; this option is the most commonly used. Use rule-based policies when you need to exert
     * fine-grained control over auto-scaling.
     * </p>
     * <p>
     * Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based
     * policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple
     * auto-scaling policies can have unintended consequences.
     * </p>
     * <p>
     * Learn more about how to work with auto-scaling in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html">Set Up Fleet Automatic
     * Scaling</a>.
     * </p>
     * <p>
     * <b>Target-based policy</b>
     * </p>
     * <p>
     * A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a
     * fleet's hosting capacity is ready to host game sessions but is not currently in use. This is the fleet's buffer;
     * it measures the additional player demand that the fleet could handle at current capacity. With a target-based
     * policy, you set your ideal buffer size and leave it to Amazon GameLift Servers to take whatever action is needed
     * to maintain that target.
     * </p>
     * <p>
     * For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous
     * game sessions. This policy tells Amazon GameLift Servers to take action whenever the fleet's available capacity
     * falls below or rises above 10 game sessions. Amazon GameLift Servers will start new instances or stop unused
     * instances in order to return to the 10% buffer.
     * </p>
     * <p>
     * To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased".
     * Specify the metric to track (PercentAvailableGameSessions) and reference a <code>TargetConfiguration</code>
     * object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is
     * returned. The scaling policy is automatically in force as soon as it's successfully created. If the fleet's
     * auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are
     * restarted.
     * </p>
     * <p>
     * <b>Rule-based policy</b>
     * </p>
     * <p>
     * A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to
     * initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each
     * policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of
     * action.
     * </p>
     * <p>
     * For example, a policy may make the following statement:
     * "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."
     * </p>
     * <p>
     * A policy's rule statement has the following structure:
     * </p>
     * <p>
     * If <code>[MetricName]</code> is <code>[ComparisonOperator]</code> <code>[Threshold]</code> for
     * <code>[EvaluationPeriods]</code> minutes, then <code>[ScalingAdjustmentType]</code> to/by
     * <code>[ScalingAdjustment]</code>.
     * </p>
     * <p>
     * To implement the example, the rule statement would look like this:
     * </p>
     * <p>
     * If <code>[PercentIdleInstances]</code> is <code>[GreaterThanThreshold]</code> <code>[20]</code> for
     * <code>[15]</code> minutes, then <code>[PercentChangeInCapacity]</code> to/by <code>[10]</code>.
     * </p>
     * <p>
     * To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type
     * to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy
     * name is returned. Scaling policies are automatically in force as soon as they're successfully created. If the
     * fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions
     * are restarted.
     * </p>
     *
     * @param putScalingPolicyRequest
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putScalingPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putScalingPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutScalingPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutScalingPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutScalingPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutScalingPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutScalingPolicyRequest, PutScalingPolicyResponse>()
                            .withOperationName("PutScalingPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutScalingPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putScalingPolicyRequest));
            CompletableFuture<PutScalingPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>This API works with the following fleet types:</b> Anywhere, Container
     * </p>
     * <p>
     * Registers a compute resource in an Amazon GameLift Servers Anywhere fleet.
     * </p>
     * <p>
     * For an Anywhere fleet that's running the Amazon GameLift Servers Agent, the Agent handles all compute registry
     * tasks for you. For an Anywhere fleet that doesn't use the Agent, call this operation to register fleet computes.
     * </p>
     * <p>
     * To register a compute, give the compute a name (must be unique within the fleet) and specify the compute
     * resource's DNS name or IP address. Provide a fleet ID and a fleet location to associate with the compute being
     * registered. You can optionally include the path to a TLS certificate on the compute resource.
     * </p>
     * <p>
     * If successful, this operation returns compute details, including an Amazon GameLift Servers SDK endpoint or Agent
     * endpoint. Game server processes running on the compute can use this endpoint to communicate with the Amazon
     * GameLift Servers service. Each server process includes the SDK endpoint in its call to the Amazon GameLift
     * Servers server SDK action <code>InitSDK()</code>.
     * </p>
     * <p>
     * To view compute details, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute.html">DescribeCompute</a> with
     * the compute name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">Server SDK
     * reference guides</a> (for version 5.x)
     * </p>
     * </li>
     * </ul>
     *
     * @param registerComputeRequest
     * @return A Java Future containing the result of the RegisterCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift Servers has not yet finished
     *         validating this compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.RegisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterCompute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterComputeResponse> registerCompute(RegisterComputeRequest registerComputeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerComputeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerComputeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GameLift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterCompute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterComputeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterComputeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "InvalidGameSessionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGameSessionStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGameSessionStatusException::builder).build());
                case "InternalServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServiceException::builder).build());
                case "OutOfCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutOfCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OutOfCapacityException::builder).build());
                case "GameSessionFullException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GameSessionFullException").httpStatusCode(400)
                            .exceptionBuilderSupplier(GameSessionFullException::builder).build());
                case "NotReadyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotReadyException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotReadyException::builder).build());
                case "NotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NotFoundException::builder).build());
                case "TaggingFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TaggingFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TaggingFailedException::builder).build());
                case "UnsupportedRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedRegionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedRegionException::builder).build());
                case "InvalidFleetStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFleetStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFleetStatusException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "FleetCapacityExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FleetCapacityExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(FleetCapacityExceededException::builder).build());
                case "IdempotentParameterMismatchException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "TerminalRoutingStrategyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TerminalRoutingStrategyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TerminalRoutingStrategyException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RegisterComputeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterComputeRequest, RegisterComputeResponse>()
                            .withOperationName("RegisterCompute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterComputeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerComputeRequest));
            CompletableFuture<RegisterComputeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * 