/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameServerInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameServerInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameServerInstance> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupName").getter(GameServerInstance.getter(GameServerInstance::gameServerGroupName)).setter(GameServerInstance.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> GAME_SERVER_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupArn").getter(GameServerInstance.getter(GameServerInstance::gameServerGroupArn)).setter(GameServerInstance.setter(Builder::gameServerGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupArn").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GameServerInstance.getter(GameServerInstance::instanceId)).setter(GameServerInstance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceStatus").getter(GameServerInstance.getter(GameServerInstance::instanceStatusAsString)).setter(GameServerInstance.setter(Builder::instanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, GAME_SERVER_GROUP_ARN_FIELD, INSTANCE_ID_FIELD, INSTANCE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GameServerInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gameServerGroupName;
    private final String gameServerGroupArn;
    private final String instanceId;
    private final String instanceStatus;

    private GameServerInstance(BuilderImpl builder) {
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerGroupArn = builder.gameServerGroupArn;
        this.instanceId = builder.instanceId;
        this.instanceStatus = builder.instanceStatus;
    }

    public final String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public final String gameServerGroupArn() {
        return this.gameServerGroupArn;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final GameServerInstanceStatus instanceStatus() {
        return GameServerInstanceStatus.fromValue(this.instanceStatus);
    }

    public final String instanceStatusAsString() {
        return this.instanceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameServerInstance)) {
            return false;
        }
        GameServerInstance other = (GameServerInstance)obj;
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.gameServerGroupArn(), other.gameServerGroupArn()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceStatusAsString(), other.instanceStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GameServerInstance").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("GameServerGroupArn", (Object)this.gameServerGroupArn()).add("InstanceId", (Object)this.instanceId()).add("InstanceStatus", (Object)this.instanceStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "GameServerGroupArn": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupArn()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.instanceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
        map.put("GameServerGroupArn", GAME_SERVER_GROUP_ARN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceStatus", INSTANCE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GameServerInstance, T> g) {
        return obj -> g.apply((GameServerInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String gameServerGroupArn;
        private String instanceId;
        private String instanceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GameServerInstance model) {
            this.gameServerGroupName(model.gameServerGroupName);
            this.gameServerGroupArn(model.gameServerGroupArn);
            this.instanceId(model.instanceId);
            this.instanceStatus(model.instanceStatus);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getGameServerGroupArn() {
            return this.gameServerGroupArn;
        }

        public final void setGameServerGroupArn(String gameServerGroupArn) {
            this.gameServerGroupArn = gameServerGroupArn;
        }

        @Override
        public final Builder gameServerGroupArn(String gameServerGroupArn) {
            this.gameServerGroupArn = gameServerGroupArn;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceStatus() {
            return this.instanceStatus;
        }

        public final void setInstanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
        }

        @Override
        public final Builder instanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        @Override
        public final Builder instanceStatus(GameServerInstanceStatus instanceStatus) {
            this.instanceStatus(instanceStatus == null ? null : instanceStatus.toString());
            return this;
        }

        public GameServerInstance build() {
            return new GameServerInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameServerInstance> {
        public Builder gameServerGroupName(String var1);

        public Builder gameServerGroupArn(String var1);

        public Builder instanceId(String var1);

        public Builder instanceStatus(String var1);

        public Builder instanceStatus(GameServerInstanceStatus var1);
    }
}

