/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.BalancingStrategy;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupAction;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupActionsCopier;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupStatus;
import software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.InstanceDefinition;
import software.amazon.awssdk.services.gamelift.model.InstanceDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameServerGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameServerGroup> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupName").getter(GameServerGroup.getter(GameServerGroup::gameServerGroupName)).setter(GameServerGroup.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> GAME_SERVER_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupArn").getter(GameServerGroup.getter(GameServerGroup::gameServerGroupArn)).setter(GameServerGroup.setter(Builder::gameServerGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(GameServerGroup.getter(GameServerGroup::roleArn)).setter(GameServerGroup.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<InstanceDefinition>> INSTANCE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceDefinitions").getter(GameServerGroup.getter(GameServerGroup::instanceDefinitions)).setter(GameServerGroup.setter(Builder::instanceDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BALANCING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BalancingStrategy").getter(GameServerGroup.getter(GameServerGroup::balancingStrategyAsString)).setter(GameServerGroup.setter(Builder::balancingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BalancingStrategy").build()}).build();
    private static final SdkField<String> GAME_SERVER_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerProtectionPolicy").getter(GameServerGroup.getter(GameServerGroup::gameServerProtectionPolicyAsString)).setter(GameServerGroup.setter(Builder::gameServerProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerProtectionPolicy").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupArn").getter(GameServerGroup.getter(GameServerGroup::autoScalingGroupArn)).setter(GameServerGroup.setter(Builder::autoScalingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GameServerGroup.getter(GameServerGroup::statusAsString)).setter(GameServerGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(GameServerGroup.getter(GameServerGroup::statusReason)).setter(GameServerGroup.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<List<String>> SUSPENDED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuspendedActions").getter(GameServerGroup.getter(GameServerGroup::suspendedActionsAsStrings)).setter(GameServerGroup.setter(Builder::suspendedActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GameServerGroup.getter(GameServerGroup::creationTime)).setter(GameServerGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(GameServerGroup.getter(GameServerGroup::lastUpdatedTime)).setter(GameServerGroup.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, GAME_SERVER_GROUP_ARN_FIELD, ROLE_ARN_FIELD, INSTANCE_DEFINITIONS_FIELD, BALANCING_STRATEGY_FIELD, GAME_SERVER_PROTECTION_POLICY_FIELD, AUTO_SCALING_GROUP_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, SUSPENDED_ACTIONS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GameServerGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gameServerGroupName;
    private final String gameServerGroupArn;
    private final String roleArn;
    private final List<InstanceDefinition> instanceDefinitions;
    private final String balancingStrategy;
    private final String gameServerProtectionPolicy;
    private final String autoScalingGroupArn;
    private final String status;
    private final String statusReason;
    private final List<String> suspendedActions;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;

    private GameServerGroup(BuilderImpl builder) {
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerGroupArn = builder.gameServerGroupArn;
        this.roleArn = builder.roleArn;
        this.instanceDefinitions = builder.instanceDefinitions;
        this.balancingStrategy = builder.balancingStrategy;
        this.gameServerProtectionPolicy = builder.gameServerProtectionPolicy;
        this.autoScalingGroupArn = builder.autoScalingGroupArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.suspendedActions = builder.suspendedActions;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public final String gameServerGroupArn() {
        return this.gameServerGroupArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasInstanceDefinitions() {
        return this.instanceDefinitions != null && !(this.instanceDefinitions instanceof SdkAutoConstructList);
    }

    public final List<InstanceDefinition> instanceDefinitions() {
        return this.instanceDefinitions;
    }

    public final BalancingStrategy balancingStrategy() {
        return BalancingStrategy.fromValue(this.balancingStrategy);
    }

    public final String balancingStrategyAsString() {
        return this.balancingStrategy;
    }

    public final GameServerProtectionPolicy gameServerProtectionPolicy() {
        return GameServerProtectionPolicy.fromValue(this.gameServerProtectionPolicy);
    }

    public final String gameServerProtectionPolicyAsString() {
        return this.gameServerProtectionPolicy;
    }

    public final String autoScalingGroupArn() {
        return this.autoScalingGroupArn;
    }

    public final GameServerGroupStatus status() {
        return GameServerGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final List<GameServerGroupAction> suspendedActions() {
        return GameServerGroupActionsCopier.copyStringToEnum(this.suspendedActions);
    }

    public final boolean hasSuspendedActions() {
        return this.suspendedActions != null && !(this.suspendedActions instanceof SdkAutoConstructList);
    }

    public final List<String> suspendedActionsAsStrings() {
        return this.suspendedActions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceDefinitions() ? this.instanceDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.balancingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuspendedActions() ? this.suspendedActionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameServerGroup)) {
            return false;
        }
        GameServerGroup other = (GameServerGroup)obj;
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.gameServerGroupArn(), other.gameServerGroupArn()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasInstanceDefinitions() == other.hasInstanceDefinitions() && Objects.equals(this.instanceDefinitions(), other.instanceDefinitions()) && Objects.equals(this.balancingStrategyAsString(), other.balancingStrategyAsString()) && Objects.equals(this.gameServerProtectionPolicyAsString(), other.gameServerProtectionPolicyAsString()) && Objects.equals(this.autoScalingGroupArn(), other.autoScalingGroupArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasSuspendedActions() == other.hasSuspendedActions() && Objects.equals(this.suspendedActionsAsStrings(), other.suspendedActionsAsStrings()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"GameServerGroup").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("GameServerGroupArn", (Object)this.gameServerGroupArn()).add("RoleArn", (Object)this.roleArn()).add("InstanceDefinitions", this.hasInstanceDefinitions() ? this.instanceDefinitions() : null).add("BalancingStrategy", (Object)this.balancingStrategyAsString()).add("GameServerProtectionPolicy", (Object)this.gameServerProtectionPolicyAsString()).add("AutoScalingGroupArn", (Object)this.autoScalingGroupArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("SuspendedActions", this.hasSuspendedActions() ? this.suspendedActionsAsStrings() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "GameServerGroupArn": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InstanceDefinitions": {
                return Optional.ofNullable(clazz.cast(this.instanceDefinitions()));
            }
            case "BalancingStrategy": {
                return Optional.ofNullable(clazz.cast(this.balancingStrategyAsString()));
            }
            case "GameServerProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.gameServerProtectionPolicyAsString()));
            }
            case "AutoScalingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "SuspendedActions": {
                return Optional.ofNullable(clazz.cast(this.suspendedActionsAsStrings()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
        map.put("GameServerGroupArn", GAME_SERVER_GROUP_ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("InstanceDefinitions", INSTANCE_DEFINITIONS_FIELD);
        map.put("BalancingStrategy", BALANCING_STRATEGY_FIELD);
        map.put("GameServerProtectionPolicy", GAME_SERVER_PROTECTION_POLICY_FIELD);
        map.put("AutoScalingGroupArn", AUTO_SCALING_GROUP_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("SuspendedActions", SUSPENDED_ACTIONS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GameServerGroup, T> g) {
        return obj -> g.apply((GameServerGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String gameServerGroupArn;
        private String roleArn;
        private List<InstanceDefinition> instanceDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String balancingStrategy;
        private String gameServerProtectionPolicy;
        private String autoScalingGroupArn;
        private String status;
        private String statusReason;
        private List<String> suspendedActions = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GameServerGroup model) {
            this.gameServerGroupName(model.gameServerGroupName);
            this.gameServerGroupArn(model.gameServerGroupArn);
            this.roleArn(model.roleArn);
            this.instanceDefinitions(model.instanceDefinitions);
            this.balancingStrategy(model.balancingStrategy);
            this.gameServerProtectionPolicy(model.gameServerProtectionPolicy);
            this.autoScalingGroupArn(model.autoScalingGroupArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.suspendedActionsWithStrings(model.suspendedActions);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getGameServerGroupArn() {
            return this.gameServerGroupArn;
        }

        public final void setGameServerGroupArn(String gameServerGroupArn) {
            this.gameServerGroupArn = gameServerGroupArn;
        }

        @Override
        public final Builder gameServerGroupArn(String gameServerGroupArn) {
            this.gameServerGroupArn = gameServerGroupArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<InstanceDefinition.Builder> getInstanceDefinitions() {
            List<InstanceDefinition.Builder> result = InstanceDefinitionsCopier.copyToBuilder(this.instanceDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceDefinitions(Collection<InstanceDefinition.BuilderImpl> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copyFromBuilder(instanceDefinitions);
        }

        @Override
        public final Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copy(instanceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(InstanceDefinition ... instanceDefinitions) {
            this.instanceDefinitions(Arrays.asList(instanceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(Consumer<InstanceDefinition.Builder> ... instanceDefinitions) {
            this.instanceDefinitions(Stream.of(instanceDefinitions).map(c -> (InstanceDefinition)((InstanceDefinition.Builder)InstanceDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBalancingStrategy() {
            return this.balancingStrategy;
        }

        public final void setBalancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
        }

        @Override
        public final Builder balancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
            return this;
        }

        @Override
        public final Builder balancingStrategy(BalancingStrategy balancingStrategy) {
            this.balancingStrategy(balancingStrategy == null ? null : balancingStrategy.toString());
            return this;
        }

        public final String getGameServerProtectionPolicy() {
            return this.gameServerProtectionPolicy;
        }

        public final void setGameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
        }

        @Override
        public final Builder gameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
            return this;
        }

        @Override
        public final Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy(gameServerProtectionPolicy == null ? null : gameServerProtectionPolicy.toString());
            return this;
        }

        public final String getAutoScalingGroupArn() {
            return this.autoScalingGroupArn;
        }

        public final void setAutoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
        }

        @Override
        public final Builder autoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GameServerGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Collection<String> getSuspendedActions() {
            if (this.suspendedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suspendedActions;
        }

        public final void setSuspendedActions(Collection<String> suspendedActions) {
            this.suspendedActions = GameServerGroupActionsCopier.copy(suspendedActions);
        }

        @Override
        public final Builder suspendedActionsWithStrings(Collection<String> suspendedActions) {
            this.suspendedActions = GameServerGroupActionsCopier.copy(suspendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedActionsWithStrings(String ... suspendedActions) {
            this.suspendedActionsWithStrings(Arrays.asList(suspendedActions));
            return this;
        }

        @Override
        public final Builder suspendedActions(Collection<GameServerGroupAction> suspendedActions) {
            this.suspendedActions = GameServerGroupActionsCopier.copyEnumToString(suspendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedActions(GameServerGroupAction ... suspendedActions) {
            this.suspendedActions(Arrays.asList(suspendedActions));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public GameServerGroup build() {
            return new GameServerGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameServerGroup> {
        public Builder gameServerGroupName(String var1);

        public Builder gameServerGroupArn(String var1);

        public Builder roleArn(String var1);

        public Builder instanceDefinitions(Collection<InstanceDefinition> var1);

        public Builder instanceDefinitions(InstanceDefinition ... var1);

        public Builder instanceDefinitions(Consumer<InstanceDefinition.Builder> ... var1);

        public Builder balancingStrategy(String var1);

        public Builder balancingStrategy(BalancingStrategy var1);

        public Builder gameServerProtectionPolicy(String var1);

        public Builder gameServerProtectionPolicy(GameServerProtectionPolicy var1);

        public Builder autoScalingGroupArn(String var1);

        public Builder status(String var1);

        public Builder status(GameServerGroupStatus var1);

        public Builder statusReason(String var1);

        public Builder suspendedActionsWithStrings(Collection<String> var1);

        public Builder suspendedActionsWithStrings(String ... var1);

        public Builder suspendedActions(Collection<GameServerGroupAction> var1);

        public Builder suspendedActions(GameServerGroupAction ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

