/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionVersionsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionVersionsResponse;

public class ListContainerGroupDefinitionVersionsPublisher
implements SdkPublisher<ListContainerGroupDefinitionVersionsResponse> {
    private final GameLiftAsyncClient client;
    private final ListContainerGroupDefinitionVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContainerGroupDefinitionVersionsPublisher(GameLiftAsyncClient client, ListContainerGroupDefinitionVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContainerGroupDefinitionVersionsPublisher(GameLiftAsyncClient client, ListContainerGroupDefinitionVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContainerGroupDefinitionVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContainerGroupDefinitionVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContainerGroupDefinition> containerGroupDefinitions() {
        Function<ListContainerGroupDefinitionVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerGroupDefinitions() != null) {
                return response.containerGroupDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContainerGroupDefinitionVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContainerGroupDefinitionVersionsResponseFetcher
    implements AsyncPageFetcher<ListContainerGroupDefinitionVersionsResponse> {
        private ListContainerGroupDefinitionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerGroupDefinitionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContainerGroupDefinitionVersionsResponse> nextPage(ListContainerGroupDefinitionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListContainerGroupDefinitionVersionsPublisher.this.client.listContainerGroupDefinitionVersions(ListContainerGroupDefinitionVersionsPublisher.this.firstRequest);
            }
            return ListContainerGroupDefinitionVersionsPublisher.this.client.listContainerGroupDefinitionVersions((ListContainerGroupDefinitionVersionsRequest)((Object)ListContainerGroupDefinitionVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

