/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestinationListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGameSessionQueueRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateGameSessionQueueRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGameSessionQueueRequest.getter(UpdateGameSessionQueueRequest::name)).setter(UpdateGameSessionQueueRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateGameSessionQueueRequest.getter(UpdateGameSessionQueueRequest::timeoutInSeconds)).setter(UpdateGameSessionQueueRequest.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()}).build();
    private static final SdkField<List<PlayerLatencyPolicy>> PLAYER_LATENCY_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateGameSessionQueueRequest.getter(UpdateGameSessionQueueRequest::playerLatencyPolicies)).setter(UpdateGameSessionQueueRequest.setter(Builder::playerLatencyPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerLatencyPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlayerLatencyPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GameSessionQueueDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateGameSessionQueueRequest.getter(UpdateGameSessionQueueRequest::destinations)).setter(UpdateGameSessionQueueRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameSessionQueueDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TIMEOUT_IN_SECONDS_FIELD, PLAYER_LATENCY_POLICIES_FIELD, DESTINATIONS_FIELD));
    private final String name;
    private final Integer timeoutInSeconds;
    private final List<PlayerLatencyPolicy> playerLatencyPolicies;
    private final List<GameSessionQueueDestination> destinations;

    private UpdateGameSessionQueueRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.playerLatencyPolicies = builder.playerLatencyPolicies;
        this.destinations = builder.destinations;
    }

    public String name() {
        return this.name;
    }

    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public List<PlayerLatencyPolicy> playerLatencyPolicies() {
        return this.playerLatencyPolicies;
    }

    public List<GameSessionQueueDestination> destinations() {
        return this.destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerLatencyPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionQueueRequest)) {
            return false;
        }
        UpdateGameSessionQueueRequest other = (UpdateGameSessionQueueRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.playerLatencyPolicies(), other.playerLatencyPolicies()) && Objects.equals(this.destinations(), other.destinations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGameSessionQueueRequest").add("Name", (Object)this.name()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("PlayerLatencyPolicies", this.playerLatencyPolicies()).add("Destinations", this.destinations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "PlayerLatencyPolicies": {
                return Optional.ofNullable(clazz.cast(this.playerLatencyPolicies()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameSessionQueueRequest, T> g) {
        return obj -> g.apply((UpdateGameSessionQueueRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String name;
        private Integer timeoutInSeconds;
        private List<PlayerLatencyPolicy> playerLatencyPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<GameSessionQueueDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionQueueRequest model) {
            super(model);
            this.name(model.name);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.playerLatencyPolicies(model.playerLatencyPolicies);
            this.destinations(model.destinations);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Collection<PlayerLatencyPolicy.Builder> getPlayerLatencyPolicies() {
            return this.playerLatencyPolicies != null ? (Collection)this.playerLatencyPolicies.stream().map(PlayerLatencyPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copy(playerLatencyPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(PlayerLatencyPolicy ... playerLatencyPolicies) {
            this.playerLatencyPolicies(Arrays.asList(playerLatencyPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(Consumer<PlayerLatencyPolicy.Builder> ... playerLatencyPolicies) {
            this.playerLatencyPolicies(Stream.of(playerLatencyPolicies).map(c -> (PlayerLatencyPolicy)((PlayerLatencyPolicy.Builder)PlayerLatencyPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlayerLatencyPolicies(Collection<PlayerLatencyPolicy.BuilderImpl> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copyFromBuilder(playerLatencyPolicies);
        }

        public final Collection<GameSessionQueueDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(GameSessionQueueDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<GameSessionQueueDestination> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(GameSessionQueueDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<GameSessionQueueDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (GameSessionQueueDestination)((GameSessionQueueDestination.Builder)GameSessionQueueDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<GameSessionQueueDestination.BuilderImpl> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameSessionQueueRequest build() {
            return new UpdateGameSessionQueueRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGameSessionQueueRequest> {
        public Builder name(String var1);

        public Builder timeoutInSeconds(Integer var1);

        public Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> var1);

        public Builder playerLatencyPolicies(PlayerLatencyPolicy ... var1);

        public Builder playerLatencyPolicies(Consumer<PlayerLatencyPolicy.Builder> ... var1);

        public Builder destinations(Collection<GameSessionQueueDestination> var1);

        public Builder destinations(GameSessionQueueDestination ... var1);

        public Builder destinations(Consumer<GameSessionQueueDestination.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

