/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerDependency;
import software.amazon.awssdk.services.gamelift.model.ContainerDependencyListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerEnvironment;
import software.amazon.awssdk.services.gamelift.model.ContainerEnvironmentListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerHealthCheck;
import software.amazon.awssdk.services.gamelift.model.ContainerMountPoint;
import software.amazon.awssdk.services.gamelift.model.ContainerMountPointListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerPortConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportContainerDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupportContainerDefinition> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerName").getter(SupportContainerDefinition.getter(SupportContainerDefinition::containerName)).setter(SupportContainerDefinition.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()}).build();
    private static final SdkField<List<ContainerDependency>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DependsOn").getter(SupportContainerDefinition.getter(SupportContainerDefinition::dependsOn)).setter(SupportContainerDefinition.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContainerMountPoint>> MOUNT_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MountPoints").getter(SupportContainerDefinition.getter(SupportContainerDefinition::mountPoints)).setter(SupportContainerDefinition.setter(Builder::mountPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerMountPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContainerEnvironment>> ENVIRONMENT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentOverride").getter(SupportContainerDefinition.getter(SupportContainerDefinition::environmentOverride)).setter(SupportContainerDefinition.setter(Builder::environmentOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ESSENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Essential").getter(SupportContainerDefinition.getter(SupportContainerDefinition::essential)).setter(SupportContainerDefinition.setter(Builder::essential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Essential").build()}).build();
    private static final SdkField<ContainerHealthCheck> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheck").getter(SupportContainerDefinition.getter(SupportContainerDefinition::healthCheck)).setter(SupportContainerDefinition.setter(Builder::healthCheck)).constructor(ContainerHealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()}).build();
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(SupportContainerDefinition.getter(SupportContainerDefinition::imageUri)).setter(SupportContainerDefinition.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<Integer> MEMORY_HARD_LIMIT_MEBIBYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemoryHardLimitMebibytes").getter(SupportContainerDefinition.getter(SupportContainerDefinition::memoryHardLimitMebibytes)).setter(SupportContainerDefinition.setter(Builder::memoryHardLimitMebibytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryHardLimitMebibytes").build()}).build();
    private static final SdkField<ContainerPortConfiguration> PORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortConfiguration").getter(SupportContainerDefinition.getter(SupportContainerDefinition::portConfiguration)).setter(SupportContainerDefinition.setter(Builder::portConfiguration)).constructor(ContainerPortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortConfiguration").build()}).build();
    private static final SdkField<String> RESOLVED_IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolvedImageDigest").getter(SupportContainerDefinition.getter(SupportContainerDefinition::resolvedImageDigest)).setter(SupportContainerDefinition.setter(Builder::resolvedImageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedImageDigest").build()}).build();
    private static final SdkField<Double> VCPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Vcpu").getter(SupportContainerDefinition.getter(SupportContainerDefinition::vcpu)).setter(SupportContainerDefinition.setter(Builder::vcpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vcpu").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, DEPENDS_ON_FIELD, MOUNT_POINTS_FIELD, ENVIRONMENT_OVERRIDE_FIELD, ESSENTIAL_FIELD, HEALTH_CHECK_FIELD, IMAGE_URI_FIELD, MEMORY_HARD_LIMIT_MEBIBYTES_FIELD, PORT_CONFIGURATION_FIELD, RESOLVED_IMAGE_DIGEST_FIELD, VCPU_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContainerName", CONTAINER_NAME_FIELD);
            this.put("DependsOn", DEPENDS_ON_FIELD);
            this.put("MountPoints", MOUNT_POINTS_FIELD);
            this.put("EnvironmentOverride", ENVIRONMENT_OVERRIDE_FIELD);
            this.put("Essential", ESSENTIAL_FIELD);
            this.put("HealthCheck", HEALTH_CHECK_FIELD);
            this.put("ImageUri", IMAGE_URI_FIELD);
            this.put("MemoryHardLimitMebibytes", MEMORY_HARD_LIMIT_MEBIBYTES_FIELD);
            this.put("PortConfiguration", PORT_CONFIGURATION_FIELD);
            this.put("ResolvedImageDigest", RESOLVED_IMAGE_DIGEST_FIELD);
            this.put("Vcpu", VCPU_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final List<ContainerDependency> dependsOn;
    private final List<ContainerMountPoint> mountPoints;
    private final List<ContainerEnvironment> environmentOverride;
    private final Boolean essential;
    private final ContainerHealthCheck healthCheck;
    private final String imageUri;
    private final Integer memoryHardLimitMebibytes;
    private final ContainerPortConfiguration portConfiguration;
    private final String resolvedImageDigest;
    private final Double vcpu;

    private SupportContainerDefinition(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.dependsOn = builder.dependsOn;
        this.mountPoints = builder.mountPoints;
        this.environmentOverride = builder.environmentOverride;
        this.essential = builder.essential;
        this.healthCheck = builder.healthCheck;
        this.imageUri = builder.imageUri;
        this.memoryHardLimitMebibytes = builder.memoryHardLimitMebibytes;
        this.portConfiguration = builder.portConfiguration;
        this.resolvedImageDigest = builder.resolvedImageDigest;
        this.vcpu = builder.vcpu;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<ContainerDependency> dependsOn() {
        return this.dependsOn;
    }

    public final boolean hasMountPoints() {
        return this.mountPoints != null && !(this.mountPoints instanceof SdkAutoConstructList);
    }

    public final List<ContainerMountPoint> mountPoints() {
        return this.mountPoints;
    }

    public final boolean hasEnvironmentOverride() {
        return this.environmentOverride != null && !(this.environmentOverride instanceof SdkAutoConstructList);
    }

    public final List<ContainerEnvironment> environmentOverride() {
        return this.environmentOverride;
    }

    public final Boolean essential() {
        return this.essential;
    }

    public final ContainerHealthCheck healthCheck() {
        return this.healthCheck;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final Integer memoryHardLimitMebibytes() {
        return this.memoryHardLimitMebibytes;
    }

    public final ContainerPortConfiguration portConfiguration() {
        return this.portConfiguration;
    }

    public final String resolvedImageDigest() {
        return this.resolvedImageDigest;
    }

    public final Double vcpu() {
        return this.vcpu;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMountPoints() ? this.mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentOverride() ? this.environmentOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.essential());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryHardLimitMebibytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.portConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedImageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcpu());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportContainerDefinition)) {
            return false;
        }
        SupportContainerDefinition other = (SupportContainerDefinition)obj;
        return Objects.equals(this.containerName(), other.containerName()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn()) && this.hasMountPoints() == other.hasMountPoints() && Objects.equals(this.mountPoints(), other.mountPoints()) && this.hasEnvironmentOverride() == other.hasEnvironmentOverride() && Objects.equals(this.environmentOverride(), other.environmentOverride()) && Objects.equals(this.essential(), other.essential()) && Objects.equals(this.healthCheck(), other.healthCheck()) && Objects.equals(this.imageUri(), other.imageUri()) && Objects.equals(this.memoryHardLimitMebibytes(), other.memoryHardLimitMebibytes()) && Objects.equals(this.portConfiguration(), other.portConfiguration()) && Objects.equals(this.resolvedImageDigest(), other.resolvedImageDigest()) && Objects.equals(this.vcpu(), other.vcpu());
    }

    public final String toString() {
        return ToString.builder((String)"SupportContainerDefinition").add("ContainerName", (Object)this.containerName()).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).add("MountPoints", this.hasMountPoints() ? this.mountPoints() : null).add("EnvironmentOverride", this.hasEnvironmentOverride() ? this.environmentOverride() : null).add("Essential", (Object)this.essential()).add("HealthCheck", (Object)this.healthCheck()).add("ImageUri", (Object)this.imageUri()).add("MemoryHardLimitMebibytes", (Object)this.memoryHardLimitMebibytes()).add("PortConfiguration", (Object)this.portConfiguration()).add("ResolvedImageDigest", (Object)this.resolvedImageDigest()).add("Vcpu", (Object)this.vcpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "DependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "MountPoints": {
                return Optional.ofNullable(clazz.cast(this.mountPoints()));
            }
            case "EnvironmentOverride": {
                return Optional.ofNullable(clazz.cast(this.environmentOverride()));
            }
            case "Essential": {
                return Optional.ofNullable(clazz.cast(this.essential()));
            }
            case "HealthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "MemoryHardLimitMebibytes": {
                return Optional.ofNullable(clazz.cast(this.memoryHardLimitMebibytes()));
            }
            case "PortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.portConfiguration()));
            }
            case "ResolvedImageDigest": {
                return Optional.ofNullable(clazz.cast(this.resolvedImageDigest()));
            }
            case "Vcpu": {
                return Optional.ofNullable(clazz.cast(this.vcpu()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SupportContainerDefinition, T> g) {
        return obj -> g.apply((SupportContainerDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private List<ContainerDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private List<ContainerMountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();
        private List<ContainerEnvironment> environmentOverride = DefaultSdkAutoConstructList.getInstance();
        private Boolean essential;
        private ContainerHealthCheck healthCheck;
        private String imageUri;
        private Integer memoryHardLimitMebibytes;
        private ContainerPortConfiguration portConfiguration;
        private String resolvedImageDigest;
        private Double vcpu;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportContainerDefinition model) {
            this.containerName(model.containerName);
            this.dependsOn(model.dependsOn);
            this.mountPoints(model.mountPoints);
            this.environmentOverride(model.environmentOverride);
            this.essential(model.essential);
            this.healthCheck(model.healthCheck);
            this.imageUri(model.imageUri);
            this.memoryHardLimitMebibytes(model.memoryHardLimitMebibytes);
            this.portConfiguration(model.portConfiguration);
            this.resolvedImageDigest(model.resolvedImageDigest);
            this.vcpu(model.vcpu);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final List<ContainerDependency.Builder> getDependsOn() {
            List<ContainerDependency.Builder> result = ContainerDependencyListCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<ContainerDependency.BuilderImpl> dependsOn) {
            this.dependsOn = ContainerDependencyListCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<ContainerDependency> dependsOn) {
            this.dependsOn = ContainerDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(ContainerDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<ContainerDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (ContainerDependency)((ContainerDependency.Builder)ContainerDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContainerMountPoint.Builder> getMountPoints() {
            List<ContainerMountPoint.Builder> result = ContainerMountPointListCopier.copyToBuilder(this.mountPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMountPoints(Collection<ContainerMountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = ContainerMountPointListCopier.copyFromBuilder(mountPoints);
        }

        @Override
        public final Builder mountPoints(Collection<ContainerMountPoint> mountPoints) {
            this.mountPoints = ContainerMountPointListCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(ContainerMountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<ContainerMountPoint.Builder> ... mountPoints) {
            this.mountPoints(Stream.of(mountPoints).map(c -> (ContainerMountPoint)((ContainerMountPoint.Builder)ContainerMountPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContainerEnvironment.Builder> getEnvironmentOverride() {
            List<ContainerEnvironment.Builder> result = ContainerEnvironmentListCopier.copyToBuilder(this.environmentOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentOverride(Collection<ContainerEnvironment.BuilderImpl> environmentOverride) {
            this.environmentOverride = ContainerEnvironmentListCopier.copyFromBuilder(environmentOverride);
        }

        @Override
        public final Builder environmentOverride(Collection<ContainerEnvironment> environmentOverride) {
            this.environmentOverride = ContainerEnvironmentListCopier.copy(environmentOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentOverride(ContainerEnvironment ... environmentOverride) {
            this.environmentOverride(Arrays.asList(environmentOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentOverride(Consumer<ContainerEnvironment.Builder> ... environmentOverride) {
            this.environmentOverride(Stream.of(environmentOverride).map(c -> (ContainerEnvironment)((ContainerEnvironment.Builder)ContainerEnvironment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEssential() {
            return this.essential;
        }

        public final void setEssential(Boolean essential) {
            this.essential = essential;
        }

        @Override
        public final Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public final ContainerHealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(ContainerHealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(ContainerHealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final Integer getMemoryHardLimitMebibytes() {
            return this.memoryHardLimitMebibytes;
        }

        public final void setMemoryHardLimitMebibytes(Integer memoryHardLimitMebibytes) {
            this.memoryHardLimitMebibytes = memoryHardLimitMebibytes;
        }

        @Override
        public final Builder memoryHardLimitMebibytes(Integer memoryHardLimitMebibytes) {
            this.memoryHardLimitMebibytes = memoryHardLimitMebibytes;
            return this;
        }

        public final ContainerPortConfiguration.Builder getPortConfiguration() {
            return this.portConfiguration != null ? this.portConfiguration.toBuilder() : null;
        }

        public final void setPortConfiguration(ContainerPortConfiguration.BuilderImpl portConfiguration) {
            this.portConfiguration = portConfiguration != null ? portConfiguration.build() : null;
        }

        @Override
        public final Builder portConfiguration(ContainerPortConfiguration portConfiguration) {
            this.portConfiguration = portConfiguration;
            return this;
        }

        public final String getResolvedImageDigest() {
            return this.resolvedImageDigest;
        }

        public final void setResolvedImageDigest(String resolvedImageDigest) {
            this.resolvedImageDigest = resolvedImageDigest;
        }

        @Override
        public final Builder resolvedImageDigest(String resolvedImageDigest) {
            this.resolvedImageDigest = resolvedImageDigest;
            return this;
        }

        public final Double getVcpu() {
            return this.vcpu;
        }

        public final void setVcpu(Double vcpu) {
            this.vcpu = vcpu;
        }

        @Override
        public final Builder vcpu(Double vcpu) {
            this.vcpu = vcpu;
            return this;
        }

        public SupportContainerDefinition build() {
            return new SupportContainerDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupportContainerDefinition> {
        public Builder containerName(String var1);

        public Builder dependsOn(Collection<ContainerDependency> var1);

        public Builder dependsOn(ContainerDependency ... var1);

        public Builder dependsOn(Consumer<ContainerDependency.Builder> ... var1);

        public Builder mountPoints(Collection<ContainerMountPoint> var1);

        public Builder mountPoints(ContainerMountPoint ... var1);

        public Builder mountPoints(Consumer<ContainerMountPoint.Builder> ... var1);

        public Builder environmentOverride(Collection<ContainerEnvironment> var1);

        public Builder environmentOverride(ContainerEnvironment ... var1);

        public Builder environmentOverride(Consumer<ContainerEnvironment.Builder> ... var1);

        public Builder essential(Boolean var1);

        public Builder healthCheck(ContainerHealthCheck var1);

        default public Builder healthCheck(Consumer<ContainerHealthCheck.Builder> healthCheck) {
            return this.healthCheck((ContainerHealthCheck)((ContainerHealthCheck.Builder)ContainerHealthCheck.builder().applyMutation(healthCheck)).build());
        }

        public Builder imageUri(String var1);

        public Builder memoryHardLimitMebibytes(Integer var1);

        public Builder portConfiguration(ContainerPortConfiguration var1);

        default public Builder portConfiguration(Consumer<ContainerPortConfiguration.Builder> portConfiguration) {
            return this.portConfiguration((ContainerPortConfiguration)((ContainerPortConfiguration.Builder)ContainerPortConfiguration.builder().applyMutation(portConfiguration)).build());
        }

        public Builder resolvedImageDigest(String var1);

        public Builder vcpu(Double var1);
    }
}

