/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse;

public class ListContainerGroupDefinitionsIterable
implements SdkIterable<ListContainerGroupDefinitionsResponse> {
    private final GameLiftClient client;
    private final ListContainerGroupDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContainerGroupDefinitionsIterable(GameLiftClient client, ListContainerGroupDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContainerGroupDefinitionsResponseFetcher();
    }

    public Iterator<ListContainerGroupDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContainerGroupDefinition> containerGroupDefinitions() {
        Function<ListContainerGroupDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerGroupDefinitions() != null) {
                return response.containerGroupDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContainerGroupDefinitionsResponseFetcher
    implements SyncPageFetcher<ListContainerGroupDefinitionsResponse> {
        private ListContainerGroupDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerGroupDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContainerGroupDefinitionsResponse nextPage(ListContainerGroupDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListContainerGroupDefinitionsIterable.this.client.listContainerGroupDefinitions(ListContainerGroupDefinitionsIterable.this.firstRequest);
            }
            return ListContainerGroupDefinitionsIterable.this.client.listContainerGroupDefinitions((ListContainerGroupDefinitionsRequest)((Object)ListContainerGroupDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

