/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputeType {
    EC2("EC2"),
    ANYWHERE("ANYWHERE"),
    CONTAINER("CONTAINER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputeType> VALUE_MAP;
    private final String value;

    private ComputeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputeType> knownValues() {
        EnumSet<ComputeType> knownValues = EnumSet.allOf(ComputeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputeType.class, ComputeType::toString);
    }
}

