/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GameServerProtectionPolicy {
    NO_PROTECTION("NO_PROTECTION"),
    FULL_PROTECTION("FULL_PROTECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GameServerProtectionPolicy> VALUE_MAP;
    private final String value;

    private GameServerProtectionPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GameServerProtectionPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GameServerProtectionPolicy> knownValues() {
        EnumSet<GameServerProtectionPolicy> knownValues = EnumSet.allOf(GameServerProtectionPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GameServerProtectionPolicy.class, GameServerProtectionPolicy::toString);
    }
}

