/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerSchedulingStrategy {
    REPLICA("REPLICA"),
    DAEMON("DAEMON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerSchedulingStrategy> VALUE_MAP;
    private final String value;

    private ContainerSchedulingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerSchedulingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerSchedulingStrategy> knownValues() {
        EnumSet<ContainerSchedulingStrategy> knownValues = EnumSet.allOf(ContainerSchedulingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerSchedulingStrategy.class, ContainerSchedulingStrategy::toString);
    }
}

