/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGameServerGroupRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateGameServerGroupRequest.Builder, CreateGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(CreateGameServerGroupRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateGameServerGroupRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(CreateGameServerGroupRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(CreateGameServerGroupRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(CreateGameServerGroupRequest::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<List<InstanceDefinition>> INSTANCE_DEFINITIONS_FIELD = SdkField
            .<List<InstanceDefinition>> builder(MarshallingType.LIST)
            .memberName("InstanceDefinitions")
            .getter(getter(CreateGameServerGroupRequest::instanceDefinitions))
            .setter(setter(Builder::instanceDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GameServerGroupAutoScalingPolicy> AUTO_SCALING_POLICY_FIELD = SdkField
            .<GameServerGroupAutoScalingPolicy> builder(MarshallingType.SDK_POJO).memberName("AutoScalingPolicy")
            .getter(getter(CreateGameServerGroupRequest::autoScalingPolicy)).setter(setter(Builder::autoScalingPolicy))
            .constructor(GameServerGroupAutoScalingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()).build();

    private static final SdkField<String> BALANCING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BalancingStrategy").getter(getter(CreateGameServerGroupRequest::balancingStrategyAsString))
            .setter(setter(Builder::balancingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BalancingStrategy").build()).build();

    private static final SdkField<String> GAME_SERVER_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GameServerProtectionPolicy")
            .getter(getter(CreateGameServerGroupRequest::gameServerProtectionPolicyAsString))
            .setter(setter(Builder::gameServerProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerProtectionPolicy").build())
            .build();

    private static final SdkField<List<String>> VPC_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSubnets")
            .getter(getter(CreateGameServerGroupRequest::vpcSubnets))
            .setter(setter(Builder::vpcSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateGameServerGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            ROLE_ARN_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, LAUNCH_TEMPLATE_FIELD, INSTANCE_DEFINITIONS_FIELD,
            AUTO_SCALING_POLICY_FIELD, BALANCING_STRATEGY_FIELD, GAME_SERVER_PROTECTION_POLICY_FIELD, VPC_SUBNETS_FIELD,
            TAGS_FIELD));

    private final String gameServerGroupName;

    private final String roleArn;

    private final Integer minSize;

    private final Integer maxSize;

    private final LaunchTemplateSpecification launchTemplate;

    private final List<InstanceDefinition> instanceDefinitions;

    private final GameServerGroupAutoScalingPolicy autoScalingPolicy;

    private final String balancingStrategy;

    private final String gameServerProtectionPolicy;

    private final List<String> vpcSubnets;

    private final List<Tag> tags;

    private CreateGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.roleArn = builder.roleArn;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.launchTemplate = builder.launchTemplate;
        this.instanceDefinitions = builder.instanceDefinitions;
        this.autoScalingPolicy = builder.autoScalingPolicy;
        this.balancingStrategy = builder.balancingStrategy;
        this.gameServerProtectionPolicy = builder.gameServerProtectionPolicy;
        this.vpcSubnets = builder.vpcSubnets;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * An identifier for the new game server group. This value is used to generate unique ARN identifiers for the Amazon
     * EC2 Auto Scaling group and the Amazon GameLift FleetIQ game server group. The name must be unique per Region per
     * Amazon Web Services account.
     * </p>
     * 
     * @return An identifier for the new game server group. This value is used to generate unique ARN identifiers for
     *         the Amazon EC2 Auto Scaling group and the Amazon GameLift FleetIQ game server group. The name must be
     *         unique per Region per Amazon Web Services account.
     */
    public final String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
     *         allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The minimum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events,
     * Amazon GameLift FleetIQ and Amazon EC2 do not scale down the group below this minimum. In production, this value
     * should be set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto
     * Scaling group using the Amazon Web Services console or APIs.
     * </p>
     * 
     * @return The minimum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling
     *         events, Amazon GameLift FleetIQ and Amazon EC2 do not scale down the group below this minimum. In
     *         production, this value should be set to at least 1. After the Auto Scaling group is created, update this
     *         value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events,
     * Amazon GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is
     * created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
     * </p>
     * 
     * @return The maximum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling
     *         events, Amazon GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto
     *         Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web
     *         Services console or APIs.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The Amazon EC2 launch template that contains configuration settings and game server code to be deployed to all
     * instances in the game server group. You can specify the template using either the template name or ID. For help
     * with creating a launch template, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch
     * Template for an Auto Scaling Group</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>. After
     * the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web
     * Services console or APIs.
     * </p>
     * <note>
     * <p>
     * If you specify network interfaces in your launch template, you must explicitly set the property
     * <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch template,
     * Amazon GameLift FleetIQ uses your account's default VPC.
     * </p>
     * </note>
     * 
     * @return The Amazon EC2 launch template that contains configuration settings and game server code to be deployed
     *         to all instances in the game server group. You can specify the template using either the template name or
     *         ID. For help with creating a launch template, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a
     *         Launch Template for an Auto Scaling Group</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User
     *         Guide</i>. After the Auto Scaling group is created, update this value directly in the Auto Scaling group
     *         using the Amazon Web Services console or APIs.</p> <note>
     *         <p>
     *         If you specify network interfaces in your launch template, you must explicitly set the property
     *         <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch
     *         template, Amazon GameLift FleetIQ uses your account's default VPC.
     *         </p>
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceDefinitions() {
        return instanceDefinitions != null && !(instanceDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify
     * at least two different instance types that are supported by Amazon GameLift FleetIQ. For more information on
     * instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2
     * Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity
     * weighting for each instance type. If no weight value is specified for an instance type, it is set to the default
     * value "1". For more information about capacity weighting, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for
     * Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceDefinitions} method.
     * </p>
     * 
     * @return The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must
     *         specify at least two different instance types that are supported by Amazon GameLift FleetIQ. For more
     *         information on instance types, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity weighting for
     *         each instance type. If no weight value is specified for an instance type, it is set to the default value
     *         "1". For more information about capacity weighting, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
     *         Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
     */
    public final List<InstanceDefinition> instanceDefinitions() {
        return instanceDefinitions;
    }

    /**
     * <p>
     * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting.
     * The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of idle game
     * servers that can immediately accommodate new games and players. After the Auto Scaling group is created, update
     * this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
     * </p>
     * 
     * @return Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game
     *         hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a
     *         buffer of idle game servers that can immediately accommodate new games and players. After the Auto
     *         Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web
     *         Services console or APIs.
     */
    public final GameServerGroupAutoScalingPolicy autoScalingPolicy() {
        return autoScalingPolicy;
    }

    /**
     * <p>
     * Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
     * server group. Method options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable
     * or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again
     * be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated
     * (after current gameplay ends) and are not replaced.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
     * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling
     * back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and
     * are replaced with new On-Demand Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are
     * used, even when available, while this balancing strategy is in force.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #balancingStrategy}
     * will return {@link BalancingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #balancingStrategyAsString}.
     * </p>
     * 
     * @return Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the
     *         game server group. Method options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
     *         unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
     *         Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
     *         Instances are terminated (after current gameplay ends) and are not replaced.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
     *         server group. If Spot Instances are unavailable, the game server group continues to provide hosting
     *         capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after
     *         current gameplay ends) and are replaced with new On-Demand Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
     *         Instances are used, even when available, while this balancing strategy is in force.
     *         </p>
     *         </li>
     * @see BalancingStrategy
     */
    public final BalancingStrategy balancingStrategy() {
        return BalancingStrategy.fromValue(balancingStrategy);
    }

    /**
     * <p>
     * Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
     * server group. Method options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable
     * or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again
     * be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated
     * (after current gameplay ends) and are not replaced.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
     * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling
     * back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and
     * are replaced with new On-Demand Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are
     * used, even when available, while this balancing strategy is in force.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #balancingStrategy}
     * will return {@link BalancingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #balancingStrategyAsString}.
     * </p>
     * 
     * @return Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the
     *         game server group. Method options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
     *         unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
     *         Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
     *         Instances are terminated (after current gameplay ends) and are not replaced.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
     *         server group. If Spot Instances are unavailable, the game server group continues to provide hosting
     *         capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after
     *         current gameplay ends) and are replaced with new On-Demand Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
     *         Instances are used, even when available, while this balancing strategy is in force.
     *         </p>
     *         </li>
     * @see BalancingStrategy
     */
    public final String balancingStrategyAsString() {
        return balancingStrategy;
    }

    /**
     * <p>
     * A flag that indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game. Protected instances cannot be terminated while there are active game
     * servers running except in the event of a forced game server group deletion (see ). An exception to this is with
     * Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is
     * set to <code>NO_PROTECTION</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gameServerProtectionPolicy} will return {@link GameServerProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #gameServerProtectionPolicyAsString}.
     * </p>
     * 
     * @return A flag that indicates whether instances in the game server group are protected from early termination.
     *         Unprotected instances that have active game servers running might be terminated during a scale-down
     *         event, causing players to be dropped from the game. Protected instances cannot be terminated while there
     *         are active game servers running except in the event of a forced game server group deletion (see ). An
     *         exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of
     *         protection status. This property is set to <code>NO_PROTECTION</code> by default.
     * @see GameServerProtectionPolicy
     */
    public final GameServerProtectionPolicy gameServerProtectionPolicy() {
        return GameServerProtectionPolicy.fromValue(gameServerProtectionPolicy);
    }

    /**
     * <p>
     * A flag that indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game. Protected instances cannot be terminated while there are active game
     * servers running except in the event of a forced game server group deletion (see ). An exception to this is with
     * Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is
     * set to <code>NO_PROTECTION</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gameServerProtectionPolicy} will return {@link GameServerProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #gameServerProtectionPolicyAsString}.
     * </p>
     * 
     * @return A flag that indicates whether instances in the game server group are protected from early termination.
     *         Unprotected instances that have active game servers running might be terminated during a scale-down
     *         event, causing players to be dropped from the game. Protected instances cannot be terminated while there
     *         are active game servers running except in the event of a forced game server group deletion (see ). An
     *         exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of
     *         protection status. This property is set to <code>NO_PROTECTION</code> by default.
     * @see GameServerProtectionPolicy
     */
    public final String gameServerProtectionPolicyAsString() {
        return gameServerProtectionPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSubnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVpcSubnets() {
        return vpcSubnets != null && !(vpcSubnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all
     * Amazon GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that
     * you've set up. This property cannot be updated after the game server group is created, and the corresponding Auto
     * Scaling group will always use the property value that is set with this request, even if the Auto Scaling group is
     * updated directly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSubnets} method.
     * </p>
     * 
     * @return A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default,
     *         all Amazon GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify
     *         VPCs that you've set up. This property cannot be updated after the game server group is created, and the
     *         corresponding Auto Scaling group will always use the property value that is set with this request, even
     *         if the Auto Scaling group is updated directly.
     */
    public final List<String> vpcSubnets() {
        return vpcSubnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
     * Tagging Amazon Web Services resources is useful for resource management, access management, and cost allocation.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
     * Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of labels to assign to the new game server group resource. Tags are developer-defined key-value
     *         pairs. Tagging Amazon Web Services resources is useful for resource management, access management, and
     *         cost allocation. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
     *         Resources</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceDefinitions() ? instanceDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(balancingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSubnets() ? vpcSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameServerGroupRequest)) {
            return false;
        }
        CreateGameServerGroupRequest other = (CreateGameServerGroupRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(maxSize(), other.maxSize())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && hasInstanceDefinitions() == other.hasInstanceDefinitions()
                && Objects.equals(instanceDefinitions(), other.instanceDefinitions())
                && Objects.equals(autoScalingPolicy(), other.autoScalingPolicy())
                && Objects.equals(balancingStrategyAsString(), other.balancingStrategyAsString())
                && Objects.equals(gameServerProtectionPolicyAsString(), other.gameServerProtectionPolicyAsString())
                && hasVpcSubnets() == other.hasVpcSubnets() && Objects.equals(vpcSubnets(), other.vpcSubnets())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGameServerGroupRequest").add("GameServerGroupName", gameServerGroupName())
                .add("RoleArn", roleArn()).add("MinSize", minSize()).add("MaxSize", maxSize())
                .add("LaunchTemplate", launchTemplate())
                .add("InstanceDefinitions", hasInstanceDefinitions() ? instanceDefinitions() : null)
                .add("AutoScalingPolicy", autoScalingPolicy()).add("BalancingStrategy", balancingStrategyAsString())
                .add("GameServerProtectionPolicy", gameServerProtectionPolicyAsString())
                .add("VpcSubnets", hasVpcSubnets() ? vpcSubnets() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "InstanceDefinitions":
            return Optional.ofNullable(clazz.cast(instanceDefinitions()));
        case "AutoScalingPolicy":
            return Optional.ofNullable(clazz.cast(autoScalingPolicy()));
        case "BalancingStrategy":
            return Optional.ofNullable(clazz.cast(balancingStrategyAsString()));
        case "GameServerProtectionPolicy":
            return Optional.ofNullable(clazz.cast(gameServerProtectionPolicyAsString()));
        case "VpcSubnets":
            return Optional.ofNullable(clazz.cast(vpcSubnets()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameServerGroupRequest, T> g) {
        return obj -> g.apply((CreateGameServerGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGameServerGroupRequest> {
        /**
         * <p>
         * An identifier for the new game server group. This value is used to generate unique ARN identifiers for the
         * Amazon EC2 Auto Scaling group and the Amazon GameLift FleetIQ game server group. The name must be unique per
         * Region per Amazon Web Services account.
         * </p>
         * 
         * @param gameServerGroupName
         *        An identifier for the new game server group. This value is used to generate unique ARN identifiers for
         *        the Amazon EC2 Auto Scaling group and the Amazon GameLift FleetIQ game server group. The name must be
         *        unique per Region per Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
         * allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role
         *        that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The minimum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling
         * events, Amazon GameLift FleetIQ and Amazon EC2 do not scale down the group below this minimum. In production,
         * this value should be set to at least 1. After the Auto Scaling group is created, update this value directly
         * in the Auto Scaling group using the Amazon Web Services console or APIs.
         * </p>
         * 
         * @param minSize
         *        The minimum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling
         *        events, Amazon GameLift FleetIQ and Amazon EC2 do not scale down the group below this minimum. In
         *        production, this value should be set to at least 1. After the Auto Scaling group is created, update
         *        this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling
         * events, Amazon GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling
         * group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console
         * or APIs.
         * </p>
         * 
         * @param maxSize
         *        The maximum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling
         *        events, Amazon GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto
         *        Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web
         *        Services console or APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The Amazon EC2 launch template that contains configuration settings and game server code to be deployed to
         * all instances in the game server group. You can specify the template using either the template name or ID.
         * For help with creating a launch template, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch
         * Template for an Auto Scaling Group</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>.
         * After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the
         * Amazon Web Services console or APIs.
         * </p>
         * <note>
         * <p>
         * If you specify network interfaces in your launch template, you must explicitly set the property
         * <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch template,
         * Amazon GameLift FleetIQ uses your account's default VPC.
         * </p>
         * </note>
         * 
         * @param launchTemplate
         *        The Amazon EC2 launch template that contains configuration settings and game server code to be
         *        deployed to all instances in the game server group. You can specify the template using either the
         *        template name or ID. For help with creating a launch template, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a
         *        Launch Template for an Auto Scaling Group</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User
         *        Guide</i>. After the Auto Scaling group is created, update this value directly in the Auto Scaling
         *        group using the Amazon Web Services console or APIs.</p> <note>
         *        <p>
         *        If you specify network interfaces in your launch template, you must explicitly set the property
         *        <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch
         *        template, Amazon GameLift FleetIQ uses your account's default VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The Amazon EC2 launch template that contains configuration settings and game server code to be deployed to
         * all instances in the game server group. You can specify the template using either the template name or ID.
         * For help with creating a launch template, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch
         * Template for an Auto Scaling Group</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>.
         * After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the
         * Amazon Web Services console or APIs.
         * </p>
         * <note>
         * <p>
         * If you specify network interfaces in your launch template, you must explicitly set the property
         * <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch template,
         * Amazon GameLift FleetIQ uses your account's default VPC.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link LaunchTemplateSpecification.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must
         * specify at least two different instance types that are supported by Amazon GameLift FleetIQ. For more
         * information on instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity weighting for each
         * instance type. If no weight value is specified for an instance type, it is set to the default value "1". For
         * more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * 
         * @param instanceDefinitions
         *        The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions
         *        must specify at least two different instance types that are supported by Amazon GameLift FleetIQ. For
         *        more information on instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity weighting
         *        for each instance type. If no weight value is specified for an instance type, it is set to the default
         *        value "1". For more information about capacity weighting, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
         *        Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions);

        /**
         * <p>
         * The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must
         * specify at least two different instance types that are supported by Amazon GameLift FleetIQ. For more
         * information on instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity weighting for each
         * instance type. If no weight value is specified for an instance type, it is set to the default value "1". For
         * more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * 
         * @param instanceDefinitions
         *        The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions
         *        must specify at least two different instance types that are supported by Amazon GameLift FleetIQ. For
         *        more information on instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity weighting
         *        for each instance type. If no weight value is specified for an instance type, it is set to the default
         *        value "1". For more information about capacity weighting, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
         *        Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDefinitions(InstanceDefinition... instanceDefinitions);

        /**
         * <p>
         * The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must
         * specify at least two different instance types that are supported by Amazon GameLift FleetIQ. For more
         * information on instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity weighting for each
         * instance type. If no weight value is specified for an instance type, it is set to the default value "1". For
         * more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceDefinitions(List<InstanceDefinition>)}.
         * 
         * @param instanceDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceDefinitions(java.util.Collection<InstanceDefinition>)
         */
        Builder instanceDefinitions(Consumer<InstanceDefinition.Builder>... instanceDefinitions);

        /**
         * <p>
         * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game
         * hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of
         * idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is
         * created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
         * </p>
         * 
         * @param autoScalingPolicy
         *        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for
         *        game hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain
         *        a buffer of idle game servers that can immediately accommodate new games and players. After the Auto
         *        Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web
         *        Services console or APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingPolicy(GameServerGroupAutoScalingPolicy autoScalingPolicy);

        /**
         * <p>
         * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game
         * hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of
         * idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is
         * created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
         * </p>
         * This is a convenience method that creates an instance of the {@link GameServerGroupAutoScalingPolicy.Builder}
         * avoiding the need to create one manually via {@link GameServerGroupAutoScalingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameServerGroupAutoScalingPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #autoScalingPolicy(GameServerGroupAutoScalingPolicy)}.
         * 
         * @param autoScalingPolicy
         *        a consumer that will call methods on {@link GameServerGroupAutoScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingPolicy(GameServerGroupAutoScalingPolicy)
         */
        default Builder autoScalingPolicy(Consumer<GameServerGroupAutoScalingPolicy.Builder> autoScalingPolicy) {
            return autoScalingPolicy(GameServerGroupAutoScalingPolicy.builder().applyMutation(autoScalingPolicy).build());
        }

        /**
         * <p>
         * Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
         * server group. Method options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         * unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
         * Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
         * Instances are terminated (after current gameplay ends) and are not replaced.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
         * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by
         * falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay
         * ends) and are replaced with new On-Demand Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances
         * are used, even when available, while this balancing strategy is in force.
         * </p>
         * </li>
         * </ul>
         * 
         * @param balancingStrategy
         *        Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in
         *        the game server group. Method options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         *        unavailable or not viable for game hosting, the game server group provides no hosting capacity until
         *        Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable
         *        Spot Instances are terminated (after current gameplay ends) and are not replaced.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
         *        server group. If Spot Instances are unavailable, the game server group continues to provide hosting
         *        capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated
         *        (after current gameplay ends) and are replaced with new On-Demand Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
         *        Instances are used, even when available, while this balancing strategy is in force.
         *        </p>
         *        </li>
         * @see BalancingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BalancingStrategy
         */
        Builder balancingStrategy(String balancingStrategy);

        /**
         * <p>
         * Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
         * server group. Method options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         * unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
         * Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
         * Instances are terminated (after current gameplay ends) and are not replaced.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
         * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by
         * falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay
         * ends) and are replaced with new On-Demand Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances
         * are used, even when available, while this balancing strategy is in force.
         * </p>
         * </li>
         * </ul>
         * 
         * @param balancingStrategy
         *        Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in
         *        the game server group. Method options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         *        unavailable or not viable for game hosting, the game server group provides no hosting capacity until
         *        Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable
         *        Spot Instances are terminated (after current gameplay ends) and are not replaced.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
         *        server group. If Spot Instances are unavailable, the game server group continues to provide hosting
         *        capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated
         *        (after current gameplay ends) and are replaced with new On-Demand Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
         *        Instances are used, even when available, while this balancing strategy is in force.
         *        </p>
         *        </li>
         * @see BalancingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BalancingStrategy
         */
        Builder balancingStrategy(BalancingStrategy balancingStrategy);

        /**
         * <p>
         * A flag that indicates whether instances in the game server group are protected from early termination.
         * Unprotected instances that have active game servers running might be terminated during a scale-down event,
         * causing players to be dropped from the game. Protected instances cannot be terminated while there are active
         * game servers running except in the event of a forced game server group deletion (see ). An exception to this
         * is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This
         * property is set to <code>NO_PROTECTION</code> by default.
         * </p>
         * 
         * @param gameServerProtectionPolicy
         *        A flag that indicates whether instances in the game server group are protected from early termination.
         *        Unprotected instances that have active game servers running might be terminated during a scale-down
         *        event, causing players to be dropped from the game. Protected instances cannot be terminated while
         *        there are active game servers running except in the event of a forced game server group deletion (see
         *        ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services
         *        regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.
         * @see GameServerProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerProtectionPolicy
         */
        Builder gameServerProtectionPolicy(String gameServerProtectionPolicy);

        /**
         * <p>
         * A flag that indicates whether instances in the game server group are protected from early termination.
         * Unprotected instances that have active game servers running might be terminated during a scale-down event,
         * causing players to be dropped from the game. Protected instances cannot be terminated while there are active
         * game servers running except in the event of a forced game server group deletion (see ). An exception to this
         * is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This
         * property is set to <code>NO_PROTECTION</code> by default.
         * </p>
         * 
         * @param gameServerProtectionPolicy
         *        A flag that indicates whether instances in the game server group are protected from early termination.
         *        Unprotected instances that have active game servers running might be terminated during a scale-down
         *        event, causing players to be dropped from the game. Protected instances cannot be terminated while
         *        there are active game servers running except in the event of a forced game server group deletion (see
         *        ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services
         *        regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.
         * @see GameServerProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerProtectionPolicy
         */
        Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy);

        /**
         * <p>
         * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all
         * Amazon GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs
         * that you've set up. This property cannot be updated after the game server group is created, and the
         * corresponding Auto Scaling group will always use the property value that is set with this request, even if
         * the Auto Scaling group is updated directly.
         * </p>
         * 
         * @param vpcSubnets
         *        A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By
         *        default, all Amazon GameLift FleetIQ-supported Availability Zones are used. You can use this parameter
         *        to specify VPCs that you've set up. This property cannot be updated after the game server group is
         *        created, and the corresponding Auto Scaling group will always use the property value that is set with
         *        this request, even if the Auto Scaling group is updated directly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnets(Collection<String> vpcSubnets);

        /**
         * <p>
         * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all
         * Amazon GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs
         * that you've set up. This property cannot be updated after the game server group is created, and the
         * corresponding Auto Scaling group will always use the property value that is set with this request, even if
         * the Auto Scaling group is updated directly.
         * </p>
         * 
         * @param vpcSubnets
         *        A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By
         *        default, all Amazon GameLift FleetIQ-supported Availability Zones are used. You can use this parameter
         *        to specify VPCs that you've set up. This property cannot be updated after the game server group is
         *        created, and the corresponding Auto Scaling group will always use the property value that is set with
         *        this request, even if the Auto Scaling group is updated directly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnets(String... vpcSubnets);

        /**
         * <p>
         * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
         * Tagging Amazon Web Services resources is useful for resource management, access management, and cost
         * allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game server group resource. Tags are developer-defined key-value
         *        pairs. Tagging Amazon Web Services resources is useful for resource management, access management, and
         *        cost allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
         * Tagging Amazon Web Services resources is useful for resource management, access management, and cost
         * allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game server group resource. Tags are developer-defined key-value
         *        pairs. Tagging Amazon Web Services resources is useful for resource management, access management, and
         *        cost allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
         * Tagging Amazon Web Services resources is useful for resource management, access management, and cost
         * allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.gamelift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String roleArn;

        private Integer minSize;

        private Integer maxSize;

        private LaunchTemplateSpecification launchTemplate;

        private List<InstanceDefinition> instanceDefinitions = DefaultSdkAutoConstructList.getInstance();

        private GameServerGroupAutoScalingPolicy autoScalingPolicy;

        private String balancingStrategy;

        private String gameServerProtectionPolicy;

        private List<String> vpcSubnets = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameServerGroupRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            roleArn(model.roleArn);
            minSize(model.minSize);
            maxSize(model.maxSize);
            launchTemplate(model.launchTemplate);
            instanceDefinitions(model.instanceDefinitions);
            autoScalingPolicy(model.autoScalingPolicy);
            balancingStrategy(model.balancingStrategy);
            gameServerProtectionPolicy(model.gameServerProtectionPolicy);
            vpcSubnets(model.vpcSubnets);
            tags(model.tags);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final List<InstanceDefinition.Builder> getInstanceDefinitions() {
            List<InstanceDefinition.Builder> result = InstanceDefinitionsCopier.copyToBuilder(this.instanceDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceDefinitions(Collection<InstanceDefinition.BuilderImpl> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copyFromBuilder(instanceDefinitions);
        }

        @Override
        public final Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copy(instanceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(InstanceDefinition... instanceDefinitions) {
            instanceDefinitions(Arrays.asList(instanceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(Consumer<InstanceDefinition.Builder>... instanceDefinitions) {
            instanceDefinitions(Stream.of(instanceDefinitions).map(c -> InstanceDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final GameServerGroupAutoScalingPolicy.Builder getAutoScalingPolicy() {
            return autoScalingPolicy != null ? autoScalingPolicy.toBuilder() : null;
        }

        public final void setAutoScalingPolicy(GameServerGroupAutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        @Override
        public final Builder autoScalingPolicy(GameServerGroupAutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final String getBalancingStrategy() {
            return balancingStrategy;
        }

        public final void setBalancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
        }

        @Override
        public final Builder balancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
            return this;
        }

        @Override
        public final Builder balancingStrategy(BalancingStrategy balancingStrategy) {
            this.balancingStrategy(balancingStrategy == null ? null : balancingStrategy.toString());
            return this;
        }

        public final String getGameServerProtectionPolicy() {
            return gameServerProtectionPolicy;
        }

        public final void setGameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
        }

        @Override
        public final Builder gameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
            return this;
        }

        @Override
        public final Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy(gameServerProtectionPolicy == null ? null : gameServerProtectionPolicy.toString());
            return this;
        }

        public final Collection<String> getVpcSubnets() {
            if (vpcSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSubnets;
        }

        public final void setVpcSubnets(Collection<String> vpcSubnets) {
            this.vpcSubnets = VpcSubnetsCopier.copy(vpcSubnets);
        }

        @Override
        public final Builder vpcSubnets(Collection<String> vpcSubnets) {
            this.vpcSubnets = VpcSubnetsCopier.copy(vpcSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnets(String... vpcSubnets) {
            vpcSubnets(Arrays.asList(vpcSubnets));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameServerGroupRequest build() {
            return new CreateGameServerGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
