/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.LocationAttributes;
import software.amazon.awssdk.services.gamelift.model.LocationAttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetLocationAttributesResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetLocationAttributesResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(DescribeFleetLocationAttributesResponse.getter(DescribeFleetLocationAttributesResponse::fleetId)).setter(DescribeFleetLocationAttributesResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(DescribeFleetLocationAttributesResponse.getter(DescribeFleetLocationAttributesResponse::fleetArn)).setter(DescribeFleetLocationAttributesResponse.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<List<LocationAttributes>> LOCATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationAttributes").getter(DescribeFleetLocationAttributesResponse.getter(DescribeFleetLocationAttributesResponse::locationAttributes)).setter(DescribeFleetLocationAttributesResponse.setter(Builder::locationAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetLocationAttributesResponse.getter(DescribeFleetLocationAttributesResponse::nextToken)).setter(DescribeFleetLocationAttributesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, LOCATION_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD));
    private final String fleetId;
    private final String fleetArn;
    private final List<LocationAttributes> locationAttributes;
    private final String nextToken;

    private DescribeFleetLocationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.locationAttributes = builder.locationAttributes;
        this.nextToken = builder.nextToken;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final boolean hasLocationAttributes() {
        return this.locationAttributes != null && !(this.locationAttributes instanceof SdkAutoConstructList);
    }

    public final List<LocationAttributes> locationAttributes() {
        return this.locationAttributes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationAttributes() ? this.locationAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetLocationAttributesResponse)) {
            return false;
        }
        DescribeFleetLocationAttributesResponse other = (DescribeFleetLocationAttributesResponse)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && this.hasLocationAttributes() == other.hasLocationAttributes() && Objects.equals(this.locationAttributes(), other.locationAttributes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetLocationAttributesResponse").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("LocationAttributes", this.hasLocationAttributes() ? this.locationAttributes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "LocationAttributes": {
                return Optional.ofNullable(clazz.cast(this.locationAttributes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetLocationAttributesResponse, T> g) {
        return obj -> g.apply((DescribeFleetLocationAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private List<LocationAttributes> locationAttributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetLocationAttributesResponse model) {
            super(model);
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.locationAttributes(model.locationAttributes);
            this.nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final List<LocationAttributes.Builder> getLocationAttributes() {
            List<LocationAttributes.Builder> result = LocationAttributesListCopier.copyToBuilder(this.locationAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder locationAttributes(Collection<LocationAttributes> locationAttributes) {
            this.locationAttributes = LocationAttributesListCopier.copy(locationAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationAttributes(LocationAttributes ... locationAttributes) {
            this.locationAttributes(Arrays.asList(locationAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationAttributes(Consumer<LocationAttributes.Builder> ... locationAttributes) {
            this.locationAttributes(Stream.of(locationAttributes).map(c -> (LocationAttributes)((LocationAttributes.Builder)LocationAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocationAttributes(Collection<LocationAttributes.BuilderImpl> locationAttributes) {
            this.locationAttributes = LocationAttributesListCopier.copyFromBuilder(locationAttributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetLocationAttributesResponse build() {
            return new DescribeFleetLocationAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetLocationAttributesResponse> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder locationAttributes(Collection<LocationAttributes> var1);

        public Builder locationAttributes(LocationAttributes ... var1);

        public Builder locationAttributes(Consumer<LocationAttributes.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

