/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBuildsResponse extends GameLiftResponse implements
        ToCopyableBuilder<ListBuildsResponse.Builder, ListBuildsResponse> {
    private static final SdkField<List<Build>> BUILDS_FIELD = SdkField
            .<List<Build>> builder(MarshallingType.LIST)
            .memberName("Builds")
            .getter(getter(ListBuildsResponse::builds))
            .setter(setter(Builder::builds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Builds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Build> builder(MarshallingType.SDK_POJO)
                                            .constructor(Build::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBuildsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BUILDS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Build> builds;

    private final String nextToken;

    private ListBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.builds = builder.builds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Builds property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBuilds() {
        return builds != null && !(builds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of build resources that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBuilds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of build resources that match the request.
     */
    public final List<Build> builds() {
        return builds;
    }

    /**
     * <p>
     * Token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return Token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuilds() ? builds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsResponse)) {
            return false;
        }
        ListBuildsResponse other = (ListBuildsResponse) obj;
        return hasBuilds() == other.hasBuilds() && Objects.equals(builds(), other.builds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBuildsResponse").add("Builds", hasBuilds() ? builds() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Builds":
            return Optional.ofNullable(clazz.cast(builds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuildsResponse, T> g) {
        return obj -> g.apply((ListBuildsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBuildsResponse> {
        /**
         * <p>
         * A collection of build resources that match the request.
         * </p>
         * 
         * @param builds
         *        A collection of build resources that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builds(Collection<Build> builds);

        /**
         * <p>
         * A collection of build resources that match the request.
         * </p>
         * 
         * @param builds
         *        A collection of build resources that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builds(Build... builds);

        /**
         * <p>
         * A collection of build resources that match the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Build>.Builder} avoiding the need to create
         * one manually via {@link List<Build>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Build>.Builder#build()} is called immediately and its result
         * is passed to {@link #builds(List<Build>)}.
         * 
         * @param builds
         *        a consumer that will call methods on {@link List<Build>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #builds(List<Build>)
         */
        Builder builds(Consumer<Build.Builder>... builds);

        /**
         * <p>
         * Token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<Build> builds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsResponse model) {
            super(model);
            builds(model.builds);
            nextToken(model.nextToken);
        }

        public final Collection<Build.Builder> getBuilds() {
            if (builds instanceof SdkAutoConstructList) {
                return null;
            }
            return builds != null ? builds.stream().map(Build::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildListCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build... builds) {
            builds(Arrays.asList(builds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Consumer<Build.Builder>... builds) {
            builds(Stream.of(builds).map(c -> Build.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBuilds(Collection<Build.BuilderImpl> builds) {
            this.builds = BuildListCopier.copyFromBuilder(builds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBuildsResponse build() {
            return new ListBuildsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
