/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ServerProcess;
import software.amazon.awssdk.services.gamelift.model.ServerProcessListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimeConfiguration> {
    private static final SdkField<List<ServerProcess>> SERVER_PROCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServerProcesses").getter(RuntimeConfiguration.getter(RuntimeConfiguration::serverProcesses)).setter(RuntimeConfiguration.setter(Builder::serverProcesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProcesses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerProcess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_GAME_SESSION_ACTIVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentGameSessionActivations").getter(RuntimeConfiguration.getter(RuntimeConfiguration::maxConcurrentGameSessionActivations)).setter(RuntimeConfiguration.setter(Builder::maxConcurrentGameSessionActivations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentGameSessionActivations").build()}).build();
    private static final SdkField<Integer> GAME_SESSION_ACTIVATION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GameSessionActivationTimeoutSeconds").getter(RuntimeConfiguration.getter(RuntimeConfiguration::gameSessionActivationTimeoutSeconds)).setter(RuntimeConfiguration.setter(Builder::gameSessionActivationTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionActivationTimeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_PROCESSES_FIELD, MAX_CONCURRENT_GAME_SESSION_ACTIVATIONS_FIELD, GAME_SESSION_ACTIVATION_TIMEOUT_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ServerProcess> serverProcesses;
    private final Integer maxConcurrentGameSessionActivations;
    private final Integer gameSessionActivationTimeoutSeconds;

    private RuntimeConfiguration(BuilderImpl builder) {
        this.serverProcesses = builder.serverProcesses;
        this.maxConcurrentGameSessionActivations = builder.maxConcurrentGameSessionActivations;
        this.gameSessionActivationTimeoutSeconds = builder.gameSessionActivationTimeoutSeconds;
    }

    public boolean hasServerProcesses() {
        return this.serverProcesses != null && !(this.serverProcesses instanceof SdkAutoConstructList);
    }

    public List<ServerProcess> serverProcesses() {
        return this.serverProcesses;
    }

    public Integer maxConcurrentGameSessionActivations() {
        return this.maxConcurrentGameSessionActivations;
    }

    public Integer gameSessionActivationTimeoutSeconds() {
        return this.gameSessionActivationTimeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverProcesses());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentGameSessionActivations());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionActivationTimeoutSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeConfiguration)) {
            return false;
        }
        RuntimeConfiguration other = (RuntimeConfiguration)obj;
        return Objects.equals(this.serverProcesses(), other.serverProcesses()) && Objects.equals(this.maxConcurrentGameSessionActivations(), other.maxConcurrentGameSessionActivations()) && Objects.equals(this.gameSessionActivationTimeoutSeconds(), other.gameSessionActivationTimeoutSeconds());
    }

    public String toString() {
        return ToString.builder((String)"RuntimeConfiguration").add("ServerProcesses", this.serverProcesses()).add("MaxConcurrentGameSessionActivations", (Object)this.maxConcurrentGameSessionActivations()).add("GameSessionActivationTimeoutSeconds", (Object)this.gameSessionActivationTimeoutSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerProcesses": {
                return Optional.ofNullable(clazz.cast(this.serverProcesses()));
            }
            case "MaxConcurrentGameSessionActivations": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentGameSessionActivations()));
            }
            case "GameSessionActivationTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.gameSessionActivationTimeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeConfiguration, T> g) {
        return obj -> g.apply((RuntimeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ServerProcess> serverProcesses = DefaultSdkAutoConstructList.getInstance();
        private Integer maxConcurrentGameSessionActivations;
        private Integer gameSessionActivationTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeConfiguration model) {
            this.serverProcesses(model.serverProcesses);
            this.maxConcurrentGameSessionActivations(model.maxConcurrentGameSessionActivations);
            this.gameSessionActivationTimeoutSeconds(model.gameSessionActivationTimeoutSeconds);
        }

        public final Collection<ServerProcess.Builder> getServerProcesses() {
            return this.serverProcesses != null ? (Collection)this.serverProcesses.stream().map(ServerProcess::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverProcesses(Collection<ServerProcess> serverProcesses) {
            this.serverProcesses = ServerProcessListCopier.copy(serverProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverProcesses(ServerProcess ... serverProcesses) {
            this.serverProcesses(Arrays.asList(serverProcesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverProcesses(Consumer<ServerProcess.Builder> ... serverProcesses) {
            this.serverProcesses(Stream.of(serverProcesses).map(c -> (ServerProcess)((ServerProcess.Builder)ServerProcess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerProcesses(Collection<ServerProcess.BuilderImpl> serverProcesses) {
            this.serverProcesses = ServerProcessListCopier.copyFromBuilder(serverProcesses);
        }

        public final Integer getMaxConcurrentGameSessionActivations() {
            return this.maxConcurrentGameSessionActivations;
        }

        @Override
        public final Builder maxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
            this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
            return this;
        }

        public final void setMaxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
            this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
        }

        public final Integer getGameSessionActivationTimeoutSeconds() {
            return this.gameSessionActivationTimeoutSeconds;
        }

        @Override
        public final Builder gameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
            this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
            return this;
        }

        public final void setGameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
            this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
        }

        public RuntimeConfiguration build() {
            return new RuntimeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimeConfiguration> {
        public Builder serverProcesses(Collection<ServerProcess> var1);

        public Builder serverProcesses(ServerProcess ... var1);

        public Builder serverProcesses(Consumer<ServerProcess.Builder> ... var1);

        public Builder maxConcurrentGameSessionActivations(Integer var1);

        public Builder gameSessionActivationTimeoutSeconds(Integer var1);
    }
}

