/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFleetPortSettingsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateFleetPortSettingsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFleetPortSettingsRequest.getter(UpdateFleetPortSettingsRequest::fleetId)).setter(UpdateFleetPortSettingsRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<List<IpPermission>> INBOUND_PERMISSION_AUTHORIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateFleetPortSettingsRequest.getter(UpdateFleetPortSettingsRequest::inboundPermissionAuthorizations)).setter(UpdateFleetPortSettingsRequest.setter(Builder::inboundPermissionAuthorizations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissionAuthorizations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IpPermission>> INBOUND_PERMISSION_REVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateFleetPortSettingsRequest.getter(UpdateFleetPortSettingsRequest::inboundPermissionRevocations)).setter(UpdateFleetPortSettingsRequest.setter(Builder::inboundPermissionRevocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissionRevocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, INBOUND_PERMISSION_AUTHORIZATIONS_FIELD, INBOUND_PERMISSION_REVOCATIONS_FIELD));
    private final String fleetId;
    private final List<IpPermission> inboundPermissionAuthorizations;
    private final List<IpPermission> inboundPermissionRevocations;

    private UpdateFleetPortSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.inboundPermissionAuthorizations = builder.inboundPermissionAuthorizations;
        this.inboundPermissionRevocations = builder.inboundPermissionRevocations;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public boolean hasInboundPermissionAuthorizations() {
        return this.inboundPermissionAuthorizations != null && !(this.inboundPermissionAuthorizations instanceof SdkAutoConstructList);
    }

    public List<IpPermission> inboundPermissionAuthorizations() {
        return this.inboundPermissionAuthorizations;
    }

    public boolean hasInboundPermissionRevocations() {
        return this.inboundPermissionRevocations != null && !(this.inboundPermissionRevocations instanceof SdkAutoConstructList);
    }

    public List<IpPermission> inboundPermissionRevocations() {
        return this.inboundPermissionRevocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundPermissionAuthorizations());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundPermissionRevocations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetPortSettingsRequest)) {
            return false;
        }
        UpdateFleetPortSettingsRequest other = (UpdateFleetPortSettingsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.inboundPermissionAuthorizations(), other.inboundPermissionAuthorizations()) && Objects.equals(this.inboundPermissionRevocations(), other.inboundPermissionRevocations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFleetPortSettingsRequest").add("FleetId", (Object)this.fleetId()).add("InboundPermissionAuthorizations", this.inboundPermissionAuthorizations()).add("InboundPermissionRevocations", this.inboundPermissionRevocations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "InboundPermissionAuthorizations": {
                return Optional.ofNullable(clazz.cast(this.inboundPermissionAuthorizations()));
            }
            case "InboundPermissionRevocations": {
                return Optional.ofNullable(clazz.cast(this.inboundPermissionRevocations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetPortSettingsRequest, T> g) {
        return obj -> g.apply((UpdateFleetPortSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private List<IpPermission> inboundPermissionAuthorizations = DefaultSdkAutoConstructList.getInstance();
        private List<IpPermission> inboundPermissionRevocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetPortSettingsRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.inboundPermissionAuthorizations(model.inboundPermissionAuthorizations);
            this.inboundPermissionRevocations(model.inboundPermissionRevocations);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Collection<IpPermission.Builder> getInboundPermissionAuthorizations() {
            return this.inboundPermissionAuthorizations != null ? (Collection)this.inboundPermissionAuthorizations.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionAuthorizations(Collection<IpPermission> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copy(inboundPermissionAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionAuthorizations(IpPermission ... inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations(Arrays.asList(inboundPermissionAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionAuthorizations(Consumer<IpPermission.Builder> ... inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations(Stream.of(inboundPermissionAuthorizations).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInboundPermissionAuthorizations(Collection<IpPermission.BuilderImpl> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionAuthorizations);
        }

        public final Collection<IpPermission.Builder> getInboundPermissionRevocations() {
            return this.inboundPermissionRevocations != null ? (Collection)this.inboundPermissionRevocations.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionRevocations(Collection<IpPermission> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copy(inboundPermissionRevocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionRevocations(IpPermission ... inboundPermissionRevocations) {
            this.inboundPermissionRevocations(Arrays.asList(inboundPermissionRevocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionRevocations(Consumer<IpPermission.Builder> ... inboundPermissionRevocations) {
            this.inboundPermissionRevocations(Stream.of(inboundPermissionRevocations).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInboundPermissionRevocations(Collection<IpPermission.BuilderImpl> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionRevocations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetPortSettingsRequest build() {
            return new UpdateFleetPortSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFleetPortSettingsRequest> {
        public Builder fleetId(String var1);

        public Builder inboundPermissionAuthorizations(Collection<IpPermission> var1);

        public Builder inboundPermissionAuthorizations(IpPermission ... var1);

        public Builder inboundPermissionAuthorizations(Consumer<IpPermission.Builder> ... var1);

        public Builder inboundPermissionRevocations(Collection<IpPermission> var1);

        public Builder inboundPermissionRevocations(IpPermission ... var1);

        public Builder inboundPermissionRevocations(Consumer<IpPermission.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

