/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResumeGameServerGroupRequest extends GameLiftRequest implements
        ToCopyableBuilder<ResumeGameServerGroupRequest.Builder, ResumeGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResumeGameServerGroupRequest::gameServerGroupName)).setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<List<String>> RESUME_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ResumeGameServerGroupRequest::resumeActionsAsStrings))
            .setter(setter(Builder::resumeActionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumeActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            RESUME_ACTIONS_FIELD));

    private final String gameServerGroupName;

    private final List<String> resumeActions;

    private ResumeGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.resumeActions = builder.resumeActions;
    }

    /**
     * <p>
     * The unique identifier of the game server group to resume activity on. Use either the <a>GameServerGroup</a> name
     * or ARN value.
     * </p>
     * 
     * @return The unique identifier of the game server group to resume activity on. Use either the
     *         <a>GameServerGroup</a> name or ARN value.
     */
    public String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * The action to resume for this game server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResumeActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The action to resume for this game server group.
     */
    public List<GameServerGroupAction> resumeActions() {
        return GameServerGroupActionsCopier.copyStringToEnum(resumeActions);
    }

    /**
     * Returns true if the ResumeActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResumeActions() {
        return resumeActions != null && !(resumeActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action to resume for this game server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResumeActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The action to resume for this game server group.
     */
    public List<String> resumeActionsAsStrings() {
        return resumeActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(resumeActionsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeGameServerGroupRequest)) {
            return false;
        }
        ResumeGameServerGroupRequest other = (ResumeGameServerGroupRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName())
                && Objects.equals(resumeActionsAsStrings(), other.resumeActionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResumeGameServerGroupRequest").add("GameServerGroupName", gameServerGroupName())
                .add("ResumeActions", resumeActionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "ResumeActions":
            return Optional.ofNullable(clazz.cast(resumeActionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResumeGameServerGroupRequest, T> g) {
        return obj -> g.apply((ResumeGameServerGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResumeGameServerGroupRequest> {
        /**
         * <p>
         * The unique identifier of the game server group to resume activity on. Use either the <a>GameServerGroup</a>
         * name or ARN value.
         * </p>
         * 
         * @param gameServerGroupName
         *        The unique identifier of the game server group to resume activity on. Use either the
         *        <a>GameServerGroup</a> name or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * The action to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The action to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActionsWithStrings(Collection<String> resumeActions);

        /**
         * <p>
         * The action to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The action to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActionsWithStrings(String... resumeActions);

        /**
         * <p>
         * The action to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The action to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActions(Collection<GameServerGroupAction> resumeActions);

        /**
         * <p>
         * The action to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The action to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActions(GameServerGroupAction... resumeActions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private List<String> resumeActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeGameServerGroupRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            resumeActionsWithStrings(model.resumeActions);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final Collection<String> getResumeActions() {
            return resumeActions;
        }

        @Override
        public final Builder resumeActionsWithStrings(Collection<String> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copy(resumeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resumeActionsWithStrings(String... resumeActions) {
            resumeActionsWithStrings(Arrays.asList(resumeActions));
            return this;
        }

        @Override
        public final Builder resumeActions(Collection<GameServerGroupAction> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copyEnumToString(resumeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resumeActions(GameServerGroupAction... resumeActions) {
            resumeActions(Arrays.asList(resumeActions));
            return this;
        }

        public final void setResumeActions(Collection<String> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copy(resumeActions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResumeGameServerGroupRequest build() {
            return new ResumeGameServerGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
