/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterGameServerRequest extends GameLiftRequest implements
        ToCopyableBuilder<RegisterGameServerRequest.Builder, RegisterGameServerRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterGameServerRequest::gameServerGroupName)).setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterGameServerRequest::gameServerId)).setter(setter(Builder::gameServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterGameServerRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONNECTION_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterGameServerRequest::connectionInfo)).setter(setter(Builder::connectionInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionInfo").build()).build();

    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterGameServerRequest::gameServerData)).setter(setter(Builder::gameServerData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()).build();

    private static final SdkField<String> CUSTOM_SORT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterGameServerRequest::customSortKey)).setter(setter(Builder::customSortKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSortKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(RegisterGameServerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            GAME_SERVER_ID_FIELD, INSTANCE_ID_FIELD, CONNECTION_INFO_FIELD, GAME_SERVER_DATA_FIELD, CUSTOM_SORT_KEY_FIELD,
            TAGS_FIELD));

    private final String gameServerGroupName;

    private final String gameServerId;

    private final String instanceId;

    private final String connectionInfo;

    private final String gameServerData;

    private final String customSortKey;

    private final List<Tag> tags;

    private RegisterGameServerRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerId = builder.gameServerId;
        this.instanceId = builder.instanceId;
        this.connectionInfo = builder.connectionInfo;
        this.gameServerData = builder.gameServerData;
        this.customSortKey = builder.customSortKey;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * An identifier for the game server group where the game server is running. You can use either the
     * <a>GameServerGroup</a> name or ARN value.
     * </p>
     * 
     * @return An identifier for the game server group where the game server is running. You can use either the
     *         <a>GameServerGroup</a> name or ARN value.
     */
    public String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * A custom string that uniquely identifies the new game server. Game server IDs are developer-defined and must be
     * unique across all game server groups in your AWS account.
     * </p>
     * 
     * @return A custom string that uniquely identifies the new game server. Game server IDs are developer-defined and
     *         must be unique across all game server groups in your AWS account.
     */
    public String gameServerId() {
        return gameServerId;
    }

    /**
     * <p>
     * The unique identifier for the instance where the game server is running. This ID is available in the instance
     * metadata.
     * </p>
     * 
     * @return The unique identifier for the instance where the game server is running. This ID is available in the
     *         instance metadata.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Information needed to make inbound client connections to the game server. This might include IP address and port,
     * DNS name, etc.
     * </p>
     * 
     * @return Information needed to make inbound client connections to the game server. This might include IP address
     *         and port, DNS name, etc.
     */
    public String connectionInfo() {
        return connectionInfo;
    }

    /**
     * <p>
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client
     * or service when it requests information on a game servers using <a>ListGameServers</a> or <a>ClaimGameServer</a>.
     * </p>
     * 
     * @return A set of custom game server properties, formatted as a single string value. This data is passed to a game
     *         client or service when it requests information on a game servers using <a>ListGameServers</a> or
     *         <a>ClaimGameServer</a>.
     */
    public String gameServerData() {
        return gameServerData;
    }

    /**
     * <p>
     * A game server tag that can be used to request sorted lists of game servers using <a>ListGameServers</a>. Custom
     * sort keys are developer-defined based on how you want to organize the retrieved game server information.
     * </p>
     * 
     * @return A game server tag that can be used to request sorted lists of game servers using <a>ListGameServers</a>.
     *         Custom sort keys are developer-defined based on how you want to organize the retrieved game server
     *         information.
     */
    public String customSortKey() {
        return customSortKey;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new game server resource. Tags are developer-defined key-value pairs. Tagging
     * AWS resources are useful for resource management, access management, and cost allocation. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the
     * <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>,
     * and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See
     * the AWS General Reference for actual tagging limits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of labels to assign to the new game server resource. Tags are developer-defined key-value pairs.
     *         Tagging AWS resources are useful for resource management, access management, and cost allocation. For
     *         more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
     *         AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
     *         <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags.
     *         The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerData());
        hashCode = 31 * hashCode + Objects.hashCode(customSortKey());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterGameServerRequest)) {
            return false;
        }
        RegisterGameServerRequest other = (RegisterGameServerRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName())
                && Objects.equals(gameServerId(), other.gameServerId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(connectionInfo(), other.connectionInfo())
                && Objects.equals(gameServerData(), other.gameServerData())
                && Objects.equals(customSortKey(), other.customSortKey()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterGameServerRequest").add("GameServerGroupName", gameServerGroupName())
                .add("GameServerId", gameServerId()).add("InstanceId", instanceId()).add("ConnectionInfo", connectionInfo())
                .add("GameServerData", gameServerData()).add("CustomSortKey", customSortKey()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "GameServerId":
            return Optional.ofNullable(clazz.cast(gameServerId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ConnectionInfo":
            return Optional.ofNullable(clazz.cast(connectionInfo()));
        case "GameServerData":
            return Optional.ofNullable(clazz.cast(gameServerData()));
        case "CustomSortKey":
            return Optional.ofNullable(clazz.cast(customSortKey()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterGameServerRequest, T> g) {
        return obj -> g.apply((RegisterGameServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterGameServerRequest> {
        /**
         * <p>
         * An identifier for the game server group where the game server is running. You can use either the
         * <a>GameServerGroup</a> name or ARN value.
         * </p>
         * 
         * @param gameServerGroupName
         *        An identifier for the game server group where the game server is running. You can use either the
         *        <a>GameServerGroup</a> name or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * A custom string that uniquely identifies the new game server. Game server IDs are developer-defined and must
         * be unique across all game server groups in your AWS account.
         * </p>
         * 
         * @param gameServerId
         *        A custom string that uniquely identifies the new game server. Game server IDs are developer-defined
         *        and must be unique across all game server groups in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerId(String gameServerId);

        /**
         * <p>
         * The unique identifier for the instance where the game server is running. This ID is available in the instance
         * metadata.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the instance where the game server is running. This ID is available in the
         *        instance metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Information needed to make inbound client connections to the game server. This might include IP address and
         * port, DNS name, etc.
         * </p>
         * 
         * @param connectionInfo
         *        Information needed to make inbound client connections to the game server. This might include IP
         *        address and port, DNS name, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionInfo(String connectionInfo);

        /**
         * <p>
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game
         * client or service when it requests information on a game servers using <a>ListGameServers</a> or
         * <a>ClaimGameServer</a>.
         * </p>
         * 
         * @param gameServerData
         *        A set of custom game server properties, formatted as a single string value. This data is passed to a
         *        game client or service when it requests information on a game servers using <a>ListGameServers</a> or
         *        <a>ClaimGameServer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerData(String gameServerData);

        /**
         * <p>
         * A game server tag that can be used to request sorted lists of game servers using <a>ListGameServers</a>.
         * Custom sort keys are developer-defined based on how you want to organize the retrieved game server
         * information.
         * </p>
         * 
         * @param customSortKey
         *        A game server tag that can be used to request sorted lists of game servers using
         *        <a>ListGameServers</a>. Custom sort keys are developer-defined based on how you want to organize the
         *        retrieved game server information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSortKey(String customSortKey);

        /**
         * <p>
         * A list of labels to assign to the new game server resource. Tags are developer-defined key-value pairs.
         * Tagging AWS resources are useful for resource management, access management, and cost allocation. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game server resource. Tags are developer-defined key-value
         *        pairs. Tagging AWS resources are useful for resource management, access management, and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         *        the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         *        <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag
         *        limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new game server resource. Tags are developer-defined key-value pairs.
         * Tagging AWS resources are useful for resource management, access management, and cost allocation. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game server resource. Tags are developer-defined key-value
         *        pairs. Tagging AWS resources are useful for resource management, access management, and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         *        the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         *        <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag
         *        limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new game server resource. Tags are developer-defined key-value pairs.
         * Tagging AWS resources are useful for resource management, access management, and cost allocation. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String gameServerId;

        private String instanceId;

        private String connectionInfo;

        private String gameServerData;

        private String customSortKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterGameServerRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            gameServerId(model.gameServerId);
            instanceId(model.instanceId);
            connectionInfo(model.connectionInfo);
            gameServerData(model.gameServerData);
            customSortKey(model.customSortKey);
            tags(model.tags);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final String getGameServerId() {
            return gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getConnectionInfo() {
            return connectionInfo;
        }

        @Override
        public final Builder connectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public final void setConnectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
        }

        public final String getGameServerData() {
            return gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        public final String getCustomSortKey() {
            return customSortKey;
        }

        @Override
        public final Builder customSortKey(String customSortKey) {
            this.customSortKey = customSortKey;
            return this;
        }

        public final void setCustomSortKey(String customSortKey) {
            this.customSortKey = customSortKey;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterGameServerRequest build() {
            return new RegisterGameServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
