/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutScalingPolicyRequest extends GameLiftRequest implements
        ToCopyableBuilder<PutScalingPolicyRequest.Builder, PutScalingPolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScalingPolicyRequest::scalingAdjustment)).setter(setter(Builder::scalingAdjustment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()).build();

    private static final SdkField<String> SCALING_ADJUSTMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::scalingAdjustmentTypeAsString))
            .setter(setter(Builder::scalingAdjustmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustmentType").build())
            .build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PutScalingPolicyRequest::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::comparisonOperatorAsString)).setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScalingPolicyRequest::evaluationPeriods)).setter(setter(Builder::evaluationPeriods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<TargetConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(PutScalingPolicyRequest::targetConfiguration))
            .setter(setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FLEET_ID_FIELD,
            SCALING_ADJUSTMENT_FIELD, SCALING_ADJUSTMENT_TYPE_FIELD, THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD,
            EVALUATION_PERIODS_FIELD, METRIC_NAME_FIELD, POLICY_TYPE_FIELD, TARGET_CONFIGURATION_FIELD));

    private final String name;

    private final String fleetId;

    private final Integer scalingAdjustment;

    private final String scalingAdjustmentType;

    private final Double threshold;

    private final String comparisonOperator;

    private final Integer evaluationPeriods;

    private final String metricName;

    private final String policyType;

    private final TargetConfiguration targetConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.fleetId = builder.fleetId;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.scalingAdjustmentType = builder.scalingAdjustmentType;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
        this.policyType = builder.policyType;
        this.targetConfiguration = builder.targetConfiguration;
    }

    /**
     * <p>
     * A descriptive label that is associated with a scaling policy. Policy names do not need to be unique. A fleet can
     * have only one scaling policy with the same name.
     * </p>
     * 
     * @return A descriptive label that is associated with a scaling policy. Policy names do not need to be unique. A
     *         fleet can have only one scaling policy with the same name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for a fleet to apply this policy to. You can use either the fleet ID or ARN value. The fleet
     * cannot be in any of the following statuses: ERROR or DELETING.
     * </p>
     * 
     * @return A unique identifier for a fleet to apply this policy to. You can use either the fleet ID or ARN value.
     *         The fleet cannot be in any of the following statuses: ERROR or DELETING.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Amount of adjustment to make, based on the scaling adjustment type.
     * </p>
     * 
     * @return Amount of adjustment to make, based on the scaling adjustment type.
     */
    public Integer scalingAdjustment() {
        return scalingAdjustment;
    }

    /**
     * <p>
     * The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count.
     * Positive values scale up while negative values scale down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read
     * as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales
     * the fleet down by 10%.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scalingAdjustmentType} will return {@link ScalingAdjustmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #scalingAdjustmentTypeAsString}.
     * </p>
     * 
     * @return The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance
     *         count. Positive values scale up while negative values scale down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling
     *         adjustment, read as a percentage. Positive values scale up while negative values scale down; for example,
     *         a value of "-10" scales the fleet down by 10%.
     *         </p>
     *         </li>
     * @see ScalingAdjustmentType
     */
    public ScalingAdjustmentType scalingAdjustmentType() {
        return ScalingAdjustmentType.fromValue(scalingAdjustmentType);
    }

    /**
     * <p>
     * The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count.
     * Positive values scale up while negative values scale down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read
     * as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales
     * the fleet down by 10%.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scalingAdjustmentType} will return {@link ScalingAdjustmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #scalingAdjustmentTypeAsString}.
     * </p>
     * 
     * @return The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance
     *         count. Positive values scale up while negative values scale down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling
     *         adjustment, read as a percentage. Positive values scale up while negative values scale down; for example,
     *         a value of "-10" scales the fleet down by 10%.
     *         </p>
     *         </li>
     * @see ScalingAdjustmentType
     */
    public String scalingAdjustmentTypeAsString() {
        return scalingAdjustmentType;
    }

    /**
     * <p>
     * Metric value used to trigger a scaling event.
     * </p>
     * 
     * @return Metric value used to trigger a scaling event.
     */
    public Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * Comparison operator to use when measuring the metric against the threshold value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return Comparison operator to use when measuring the metric against the threshold value.
     * @see ComparisonOperatorType
     */
    public ComparisonOperatorType comparisonOperator() {
        return ComparisonOperatorType.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * Comparison operator to use when measuring the metric against the threshold value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return Comparison operator to use when measuring the metric against the threshold value.
     * @see ComparisonOperatorType
     */
    public String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
     * </p>
     * 
     * @return Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is
     *         triggered.
     */
    public Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * <p>
     * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
     * descriptions of fleet metrics, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon
     * GameLift with Amazon CloudWatch</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ActiveGameSessions</b> -- Game sessions that are currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current
     * capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game
     * sessions that are not currently accepting players. Reserved player slots are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are
     * reserved for a player.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could
     * host simultaneously, given current capacity. Use this metric for a target-based scaling policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game
     * sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the
     * top-priority destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current
     * fleet is the top-priority destination.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link MetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
     *         descriptions of fleet metrics, see <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor
     *         Amazon GameLift with Amazon CloudWatch</a>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ActiveGameSessions</b> -- Game sessions that are currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given
     *         current capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes
     *         game sessions that are not currently accepting players. Reserved player slots are not included.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or
     *         are reserved for a player.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a
     *         fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling
     *         policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero
     *         game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is
     *         the top-priority destination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the
     *         current fleet is the top-priority destination.
     *         </p>
     *         </li>
     * @see MetricName
     */
    public MetricName metricName() {
        return MetricName.fromValue(metricName);
    }

    /**
     * <p>
     * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
     * descriptions of fleet metrics, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon
     * GameLift with Amazon CloudWatch</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ActiveGameSessions</b> -- Game sessions that are currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current
     * capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game
     * sessions that are not currently accepting players. Reserved player slots are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are
     * reserved for a player.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could
     * host simultaneously, given current capacity. Use this metric for a target-based scaling policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game
     * sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the
     * top-priority destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current
     * fleet is the top-priority destination.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link MetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
     *         descriptions of fleet metrics, see <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor
     *         Amazon GameLift with Amazon CloudWatch</a>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ActiveGameSessions</b> -- Game sessions that are currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given
     *         current capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes
     *         game sessions that are not currently accepting players. Reserved player slots are not included.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or
     *         are reserved for a player.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a
     *         fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling
     *         policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero
     *         game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is
     *         the top-priority destination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the
     *         current fleet is the top-priority destination.
     *         </p>
     *         </li>
     * @see MetricName
     */
    public String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to
     * 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the
     * following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>,
     * <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to
     *         'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the
     *         following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>,
     *         <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
     * @see PolicyType
     */
    public PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to
     * 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the
     * following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>,
     * <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to
     *         'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the
     *         following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>,
     *         <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
     * @see PolicyType
     */
    public String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The settings for a target-based scaling policy.
     * </p>
     * 
     * @return The settings for a target-based scaling policy.
     */
    public TargetConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(scalingAdjustmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(scalingAdjustment(), other.scalingAdjustment())
                && Objects.equals(scalingAdjustmentTypeAsString(), other.scalingAdjustmentTypeAsString())
                && Objects.equals(threshold(), other.threshold())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(evaluationPeriods(), other.evaluationPeriods())
                && Objects.equals(metricNameAsString(), other.metricNameAsString())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(targetConfiguration(), other.targetConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutScalingPolicyRequest").add("Name", name()).add("FleetId", fleetId())
                .add("ScalingAdjustment", scalingAdjustment()).add("ScalingAdjustmentType", scalingAdjustmentTypeAsString())
                .add("Threshold", threshold()).add("ComparisonOperator", comparisonOperatorAsString())
                .add("EvaluationPeriods", evaluationPeriods()).add("MetricName", metricNameAsString())
                .add("PolicyType", policyTypeAsString()).add("TargetConfiguration", targetConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "ScalingAdjustment":
            return Optional.ofNullable(clazz.cast(scalingAdjustment()));
        case "ScalingAdjustmentType":
            return Optional.ofNullable(clazz.cast(scalingAdjustmentTypeAsString()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "EvaluationPeriods":
            return Optional.ofNullable(clazz.cast(evaluationPeriods()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "TargetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutScalingPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutScalingPolicyRequest> {
        /**
         * <p>
         * A descriptive label that is associated with a scaling policy. Policy names do not need to be unique. A fleet
         * can have only one scaling policy with the same name.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a scaling policy. Policy names do not need to be unique. A
         *        fleet can have only one scaling policy with the same name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for a fleet to apply this policy to. You can use either the fleet ID or ARN value. The
         * fleet cannot be in any of the following statuses: ERROR or DELETING.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet to apply this policy to. You can use either the fleet ID or ARN value.
         *        The fleet cannot be in any of the following statuses: ERROR or DELETING.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Amount of adjustment to make, based on the scaling adjustment type.
         * </p>
         * 
         * @param scalingAdjustment
         *        Amount of adjustment to make, based on the scaling adjustment type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingAdjustment(Integer scalingAdjustment);

        /**
         * <p>
         * The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count.
         * Positive values scale up while negative values scale down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment,
         * read as a percentage. Positive values scale up while negative values scale down; for example, a value of
         * "-10" scales the fleet down by 10%.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingAdjustmentType
         *        The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance
         *        count. Positive values scale up while negative values scale down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling
         *        adjustment, read as a percentage. Positive values scale up while negative values scale down; for
         *        example, a value of "-10" scales the fleet down by 10%.
         *        </p>
         *        </li>
         * @see ScalingAdjustmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingAdjustmentType
         */
        Builder scalingAdjustmentType(String scalingAdjustmentType);

        /**
         * <p>
         * The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count.
         * Positive values scale up while negative values scale down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment,
         * read as a percentage. Positive values scale up while negative values scale down; for example, a value of
         * "-10" scales the fleet down by 10%.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingAdjustmentType
         *        The type of adjustment to make to a fleet's instance count (see <a>FleetCapacity</a>):</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance
         *        count. Positive values scale up while negative values scale down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling
         *        adjustment, read as a percentage. Positive values scale up while negative values scale down; for
         *        example, a value of "-10" scales the fleet down by 10%.
         *        </p>
         *        </li>
         * @see ScalingAdjustmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingAdjustmentType
         */
        Builder scalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType);

        /**
         * <p>
         * Metric value used to trigger a scaling event.
         * </p>
         * 
         * @param threshold
         *        Metric value used to trigger a scaling event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * Comparison operator to use when measuring the metric against the threshold value.
         * </p>
         * 
         * @param comparisonOperator
         *        Comparison operator to use when measuring the metric against the threshold value.
         * @see ComparisonOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperatorType
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * Comparison operator to use when measuring the metric against the threshold value.
         * </p>
         * 
         * @param comparisonOperator
         *        Comparison operator to use when measuring the metric against the threshold value.
         * @see ComparisonOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperatorType
         */
        Builder comparisonOperator(ComparisonOperatorType comparisonOperator);

        /**
         * <p>
         * Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is
         * triggered.
         * </p>
         * 
         * @param evaluationPeriods
         *        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is
         *        triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * <p>
         * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
         * descriptions of fleet metrics, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon
         * GameLift with Amazon CloudWatch</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ActiveGameSessions</b> -- Game sessions that are currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current
         * capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game
         * sessions that are not currently accepting players. Reserved player slots are not included.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are
         * reserved for a player.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet
         * could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game
         * sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the
         * top-priority destination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the
         * current fleet is the top-priority destination.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
         *        descriptions of fleet metrics, see <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor
         *        Amazon GameLift with Amazon CloudWatch</a>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ActiveGameSessions</b> -- Game sessions that are currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given
         *        current capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes
         *        game sessions that are not currently accepting players. Reserved player slots are not included.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player
         *        or are reserved for a player.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a
         *        fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling
         *        policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting
         *        zero game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is
         *        the top-priority destination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where
         *        the current fleet is the top-priority destination.
         *        </p>
         *        </li>
         * @see MetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
         * descriptions of fleet metrics, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon
         * GameLift with Amazon CloudWatch</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ActiveGameSessions</b> -- Game sessions that are currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current
         * capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game
         * sessions that are not currently accepting players. Reserved player slots are not included.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are
         * reserved for a player.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet
         * could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game
         * sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the
         * top-priority destination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the
         * current fleet is the top-priority destination.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed
         *        descriptions of fleet metrics, see <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor
         *        Amazon GameLift with Amazon CloudWatch</a>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ActiveGameSessions</b> -- Game sessions that are currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given
         *        current capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes
         *        game sessions that are not currently accepting players. Reserved player slots are not included.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player
         *        or are reserved for a player.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a
         *        fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling
         *        policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting
         *        zero game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is
         *        the top-priority destination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where
         *        the current fleet is the top-priority destination.
         *        </p>
         *        </li>
         * @see MetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricName
         */
        Builder metricName(MetricName metricName);

        /**
         * <p>
         * The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to
         * 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the
         * following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>,
         * <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
         * </p>
         * 
         * @param policyType
         *        The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i>
         *        to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy
         *        set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>,
         *        <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to
         * 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the
         * following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>,
         * <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
         * </p>
         * 
         * @param policyType
         *        The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i>
         *        to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy
         *        set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>,
         *        <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * The settings for a target-based scaling policy.
         * </p>
         * 
         * @param targetConfiguration
         *        The settings for a target-based scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(TargetConfiguration targetConfiguration);

        /**
         * <p>
         * The settings for a target-based scaling policy.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetConfiguration.Builder} avoiding the need
         * to create one manually via {@link TargetConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #targetConfiguration(TargetConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link TargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(TargetConfiguration)
         */
        default Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(TargetConfiguration.builder().applyMutation(targetConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private String fleetId;

        private Integer scalingAdjustment;

        private String scalingAdjustmentType;

        private Double threshold;

        private String comparisonOperator;

        private Integer evaluationPeriods;

        private String metricName;

        private String policyType;

        private TargetConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            super(model);
            name(model.name);
            fleetId(model.fleetId);
            scalingAdjustment(model.scalingAdjustment);
            scalingAdjustmentType(model.scalingAdjustmentType);
            threshold(model.threshold);
            comparisonOperator(model.comparisonOperator);
            evaluationPeriods(model.evaluationPeriods);
            metricName(model.metricName);
            policyType(model.policyType);
            targetConfiguration(model.targetConfiguration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getScalingAdjustment() {
            return scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final String getScalingAdjustmentType() {
            return scalingAdjustmentType;
        }

        @Override
        public final Builder scalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
            return this;
        }

        @Override
        public final Builder scalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType) {
            this.scalingAdjustmentType(scalingAdjustmentType == null ? null : scalingAdjustmentType.toString());
            return this;
        }

        public final void setScalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
        }

        public final Double getThreshold() {
            return threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperatorType comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getPolicyType() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
