/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBuildsRequest extends GameLiftRequest implements
        ToCopyableBuilder<ListBuildsRequest.Builder, ListBuildsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBuildsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListBuildsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBuildsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LIMIT_FIELD,
            NEXT_TOKEN_FIELD));

    private final String status;

    private final Integer limit;

    private final String nextToken;

    private ListBuildsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Build status to filter results by. To retrieve all builds, leave this parameter empty.
     * </p>
     * <p>
     * Possible build statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for
     * builds that are in this status. When a build is successfully created, the build status is set to this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Build status to filter results by. To retrieve all builds, leave this parameter empty.</p>
     *         <p>
     *         Possible build statuses include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
     *         fleets for builds that are in this status. When a build is successfully created, the build status is set
     *         to this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
     *         build.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     *         </p>
     *         </li>
     * @see BuildStatus
     */
    public BuildStatus status() {
        return BuildStatus.fromValue(status);
    }

    /**
     * <p>
     * Build status to filter results by. To retrieve all builds, leave this parameter empty.
     * </p>
     * <p>
     * Possible build statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for
     * builds that are in this status. When a build is successfully created, the build status is set to this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Build status to filter results by. To retrieve all builds, leave this parameter empty.</p>
     *         <p>
     *         Possible build statuses include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
     *         fleets for builds that are in this status. When a build is successfully created, the build status is set
     *         to this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
     *         build.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
     *         </p>
     *         </li>
     * @see BuildStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this action. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return Token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this action. To start at the beginning of the result set, do not specify a value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsRequest)) {
            return false;
        }
        ListBuildsRequest other = (ListBuildsRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBuildsRequest").add("Status", statusAsString()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuildsRequest, T> g) {
        return obj -> g.apply((ListBuildsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBuildsRequest> {
        /**
         * <p>
         * Build status to filter results by. To retrieve all builds, leave this parameter empty.
         * </p>
         * <p>
         * Possible build statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets
         * for builds that are in this status. When a build is successfully created, the build status is set to this
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Build status to filter results by. To retrieve all builds, leave this parameter empty.</p>
         *        <p>
         *        Possible build statuses include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
         *        fleets for builds that are in this status. When a build is successfully created, the build status is
         *        set to this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
         *        build.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         *        </p>
         *        </li>
         * @see BuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Build status to filter results by. To retrieve all builds, leave this parameter empty.
         * </p>
         * <p>
         * Possible build statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets
         * for builds that are in this status. When a build is successfully created, the build status is set to this
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Build status to filter results by. To retrieve all builds, leave this parameter empty.</p>
         *        <p>
         *        Possible build statuses include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create
         *        fleets for builds that are in this status. When a build is successfully created, the build status is
         *        set to this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this
         *        build.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build.
         *        </p>
         *        </li>
         * @see BuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildStatus
         */
        Builder status(BuildStatus status);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Token that indicates the start of the next sequential page of results. Use the token that is returned with a
         * previous call to this action. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates the start of the next sequential page of results. Use the token that is returned
         *        with a previous call to this action. To start at the beginning of the result set, do not specify a
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String status;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsRequest model) {
            super(model);
            status(model.status);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BuildStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBuildsRequest build() {
            return new ListBuildsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
