/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcPeeringConnectionsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeVpcPeeringConnectionsResponse.Builder, DescribeVpcPeeringConnectionsResponse> {
    private static final SdkField<List<VpcPeeringConnection>> VPC_PEERING_CONNECTIONS_FIELD = SdkField
            .<List<VpcPeeringConnection>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVpcPeeringConnectionsResponse::vpcPeeringConnections))
            .setter(setter(Builder::vpcPeeringConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcPeeringConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcPeeringConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VPC_PEERING_CONNECTIONS_FIELD));

    private final List<VpcPeeringConnection> vpcPeeringConnections;

    private DescribeVpcPeeringConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringConnections = builder.vpcPeeringConnections;
    }

    /**
     * Returns true if the VpcPeeringConnections property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVpcPeeringConnections() {
        return vpcPeeringConnections != null && !(vpcPeeringConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of VPC peering connection records that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcPeeringConnections()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of VPC peering connection records that match the request.
     */
    public List<VpcPeeringConnection> vpcPeeringConnections() {
        return vpcPeeringConnections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnections());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsResponse)) {
            return false;
        }
        DescribeVpcPeeringConnectionsResponse other = (DescribeVpcPeeringConnectionsResponse) obj;
        return Objects.equals(vpcPeeringConnections(), other.vpcPeeringConnections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVpcPeeringConnectionsResponse").add("VpcPeeringConnections", vpcPeeringConnections())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringConnections":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcPeeringConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcPeeringConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcPeeringConnectionsResponse> {
        /**
         * <p>
         * A collection of VPC peering connection records that match the request.
         * </p>
         * 
         * @param vpcPeeringConnections
         *        A collection of VPC peering connection records that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections);

        /**
         * <p>
         * A collection of VPC peering connection records that match the request.
         * </p>
         * 
         * @param vpcPeeringConnections
         *        A collection of VPC peering connection records that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnections(VpcPeeringConnection... vpcPeeringConnections);

        /**
         * <p>
         * A collection of VPC peering connection records that match the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcPeeringConnection>.Builder} avoiding the
         * need to create one manually via {@link List<VpcPeeringConnection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcPeeringConnection>.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcPeeringConnections(List<VpcPeeringConnection>)}.
         * 
         * @param vpcPeeringConnections
         *        a consumer that will call methods on {@link List<VpcPeeringConnection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeeringConnections(List<VpcPeeringConnection>)
         */
        Builder vpcPeeringConnections(Consumer<VpcPeeringConnection.Builder>... vpcPeeringConnections);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<VpcPeeringConnection> vpcPeeringConnections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringConnectionsResponse model) {
            super(model);
            vpcPeeringConnections(model.vpcPeeringConnections);
        }

        public final Collection<VpcPeeringConnection.Builder> getVpcPeeringConnections() {
            return vpcPeeringConnections != null ? vpcPeeringConnections.stream().map(VpcPeeringConnection::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copy(vpcPeeringConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(VpcPeeringConnection... vpcPeeringConnections) {
            vpcPeeringConnections(Arrays.asList(vpcPeeringConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(Consumer<VpcPeeringConnection.Builder>... vpcPeeringConnections) {
            vpcPeeringConnections(Stream.of(vpcPeeringConnections)
                    .map(c -> VpcPeeringConnection.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcPeeringConnections(Collection<VpcPeeringConnection.BuilderImpl> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copyFromBuilder(vpcPeeringConnections);
        }

        @Override
        public DescribeVpcPeeringConnectionsResponse build() {
            return new DescribeVpcPeeringConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
