/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMatchmakingRuleSetsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeMatchmakingRuleSetsResponse.Builder, DescribeMatchmakingRuleSetsResponse> {
    private static final SdkField<List<MatchmakingRuleSet>> RULE_SETS_FIELD = SdkField
            .<List<MatchmakingRuleSet>> builder(MarshallingType.LIST)
            .getter(getter(DescribeMatchmakingRuleSetsResponse::ruleSets))
            .setter(setter(Builder::ruleSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchmakingRuleSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchmakingRuleSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMatchmakingRuleSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MatchmakingRuleSet> ruleSets;

    private final String nextToken;

    private DescribeMatchmakingRuleSetsResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSets = builder.ruleSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RuleSets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRuleSets() {
        return ruleSets != null && !(ruleSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of requested matchmaking rule set objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of requested matchmaking rule set objects.
     */
    public List<MatchmakingRuleSet> ruleSets() {
        return ruleSets;
    }

    /**
     * <p>
     * A token that indicates where to resume retrieving results on the next call to this action. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return A token that indicates where to resume retrieving results on the next call to this action. If no token is
     *         returned, these results represent the end of the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleSets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingRuleSetsResponse)) {
            return false;
        }
        DescribeMatchmakingRuleSetsResponse other = (DescribeMatchmakingRuleSetsResponse) obj;
        return Objects.equals(ruleSets(), other.ruleSets()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMatchmakingRuleSetsResponse").add("RuleSets", ruleSets()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSets":
            return Optional.ofNullable(clazz.cast(ruleSets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingRuleSetsResponse, T> g) {
        return obj -> g.apply((DescribeMatchmakingRuleSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMatchmakingRuleSetsResponse> {
        /**
         * <p>
         * A collection of requested matchmaking rule set objects.
         * </p>
         * 
         * @param ruleSets
         *        A collection of requested matchmaking rule set objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(Collection<MatchmakingRuleSet> ruleSets);

        /**
         * <p>
         * A collection of requested matchmaking rule set objects.
         * </p>
         * 
         * @param ruleSets
         *        A collection of requested matchmaking rule set objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(MatchmakingRuleSet... ruleSets);

        /**
         * <p>
         * A collection of requested matchmaking rule set objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MatchmakingRuleSet>.Builder} avoiding the
         * need to create one manually via {@link List<MatchmakingRuleSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MatchmakingRuleSet>.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleSets(List<MatchmakingRuleSet>)}.
         * 
         * @param ruleSets
         *        a consumer that will call methods on {@link List<MatchmakingRuleSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleSets(List<MatchmakingRuleSet>)
         */
        Builder ruleSets(Consumer<MatchmakingRuleSet.Builder>... ruleSets);

        /**
         * <p>
         * A token that indicates where to resume retrieving results on the next call to this action. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where to resume retrieving results on the next call to this action. If no token
         *        is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<MatchmakingRuleSet> ruleSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingRuleSetsResponse model) {
            super(model);
            ruleSets(model.ruleSets);
            nextToken(model.nextToken);
        }

        public final Collection<MatchmakingRuleSet.Builder> getRuleSets() {
            return ruleSets != null ? ruleSets.stream().map(MatchmakingRuleSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleSets(Collection<MatchmakingRuleSet> ruleSets) {
            this.ruleSets = MatchmakingRuleSetListCopier.copy(ruleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(MatchmakingRuleSet... ruleSets) {
            ruleSets(Arrays.asList(ruleSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(Consumer<MatchmakingRuleSet.Builder>... ruleSets) {
            ruleSets(Stream.of(ruleSets).map(c -> MatchmakingRuleSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRuleSets(Collection<MatchmakingRuleSet.BuilderImpl> ruleSets) {
            this.ruleSets = MatchmakingRuleSetListCopier.copyFromBuilder(ruleSets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMatchmakingRuleSetsResponse build() {
            return new DescribeMatchmakingRuleSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
