/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFleetCapacityRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateFleetCapacityRequest.Builder, UpdateFleetCapacityRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFleetCapacityRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<Integer> DESIRED_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFleetCapacityRequest::desiredInstances)).setter(setter(Builder::desiredInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstances").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFleetCapacityRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFleetCapacityRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            DESIRED_INSTANCES_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD));

    private final String fleetId;

    private final Integer desiredInstances;

    private final Integer minSize;

    private final Integer maxSize;

    private UpdateFleetCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.desiredInstances = builder.desiredInstances;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
    }

    /**
     * <p>
     * A unique identifier for a fleet to update capacity for. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for a fleet to update capacity for. You can use either the fleet ID or ARN value.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Number of EC2 instances you want this fleet to host.
     * </p>
     * 
     * @return Number of EC2 instances you want this fleet to host.
     */
    public Integer desiredInstances() {
        return desiredInstances;
    }

    /**
     * <p>
     * The minimum value allowed for the fleet's instance count. Default if not set is 0.
     * </p>
     * 
     * @return The minimum value allowed for the fleet's instance count. Default if not set is 0.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum value allowed for the fleet's instance count. Default if not set is 1.
     * </p>
     * 
     * @return The maximum value allowed for the fleet's instance count. Default if not set is 1.
     */
    public Integer maxSize() {
        return maxSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(desiredInstances());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetCapacityRequest)) {
            return false;
        }
        UpdateFleetCapacityRequest other = (UpdateFleetCapacityRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(desiredInstances(), other.desiredInstances())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(maxSize(), other.maxSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFleetCapacityRequest").add("FleetId", fleetId())
                .add("DesiredInstances", desiredInstances()).add("MinSize", minSize()).add("MaxSize", maxSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "DesiredInstances":
            return Optional.ofNullable(clazz.cast(desiredInstances()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetCapacityRequest, T> g) {
        return obj -> g.apply((UpdateFleetCapacityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFleetCapacityRequest> {
        /**
         * <p>
         * A unique identifier for a fleet to update capacity for. You can use either the fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet to update capacity for. You can use either the fleet ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Number of EC2 instances you want this fleet to host.
         * </p>
         * 
         * @param desiredInstances
         *        Number of EC2 instances you want this fleet to host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInstances(Integer desiredInstances);

        /**
         * <p>
         * The minimum value allowed for the fleet's instance count. Default if not set is 0.
         * </p>
         * 
         * @param minSize
         *        The minimum value allowed for the fleet's instance count. Default if not set is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum value allowed for the fleet's instance count. Default if not set is 1.
         * </p>
         * 
         * @param maxSize
         *        The maximum value allowed for the fleet's instance count. Default if not set is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private Integer desiredInstances;

        private Integer minSize;

        private Integer maxSize;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetCapacityRequest model) {
            super(model);
            fleetId(model.fleetId);
            desiredInstances(model.desiredInstances);
            minSize(model.minSize);
            maxSize(model.maxSize);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getDesiredInstances() {
            return desiredInstances;
        }

        @Override
        public final Builder desiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public final void setDesiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetCapacityRequest build() {
            return new UpdateFleetCapacityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
