/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFleetActionsRequest extends GameLiftRequest implements
        ToCopyableBuilder<StartFleetActionsRequest.Builder, StartFleetActionsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartFleetActionsRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StartFleetActionsRequest::actionsAsStrings))
            .setter(setter(Builder::actionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ACTIONS_FIELD));

    private final String fleetId;

    private final List<String> actions;

    private StartFleetActionsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * A unique identifier for a fleet to start actions on. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for a fleet to start actions on. You can use either the fleet ID or ARN value.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * List of actions to restart on the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of actions to restart on the fleet.
     */
    public List<FleetAction> actions() {
        return FleetActionListCopier.copyStringToEnum(actions);
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of actions to restart on the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of actions to restart on the fleet.
     */
    public List<String> actionsAsStrings() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(actionsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFleetActionsRequest)) {
            return false;
        }
        StartFleetActionsRequest other = (StartFleetActionsRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(actionsAsStrings(), other.actionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartFleetActionsRequest").add("FleetId", fleetId()).add("Actions", actionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFleetActionsRequest, T> g) {
        return obj -> g.apply((StartFleetActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartFleetActionsRequest> {
        /**
         * <p>
         * A unique identifier for a fleet to start actions on. You can use either the fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet to start actions on. You can use either the fleet ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * List of actions to restart on the fleet.
         * </p>
         * 
         * @param actions
         *        List of actions to restart on the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsWithStrings(Collection<String> actions);

        /**
         * <p>
         * List of actions to restart on the fleet.
         * </p>
         * 
         * @param actions
         *        List of actions to restart on the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsWithStrings(String... actions);

        /**
         * <p>
         * List of actions to restart on the fleet.
         * </p>
         * 
         * @param actions
         *        List of actions to restart on the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<FleetAction> actions);

        /**
         * <p>
         * List of actions to restart on the fleet.
         * </p>
         * 
         * @param actions
         *        List of actions to restart on the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(FleetAction... actions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartFleetActionsRequest model) {
            super(model);
            fleetId(model.fleetId);
            actionsWithStrings(model.actions);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Collection<String> getActionsAsStrings() {
            return actions;
        }

        @Override
        public final Builder actionsWithStrings(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsWithStrings(String... actions) {
            actionsWithStrings(Arrays.asList(actions));
            return this;
        }

        @Override
        public final Builder actions(Collection<FleetAction> actions) {
            this.actions = FleetActionListCopier.copyEnumToString(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(FleetAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final void setActionsWithStrings(Collection<String> actions) {
            this.actions = FleetActionListCopier.copy(actions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFleetActionsRequest build() {
            return new StartFleetActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
