/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Current status of fleet capacity. The number of active instances should match or be in the process of matching the
 * number of desired instances. Pending and terminating counts are non-zero only if fleet capacity is adjusting to an
 * <a>UpdateFleetCapacity</a> request, or if access to resources is temporarily affected.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListFleets</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Manage fleet actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>StartFleetActions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StopFleetActions</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2InstanceCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2InstanceCounts.Builder, EC2InstanceCounts> {
    private static final SdkField<Integer> DESIRED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceCounts::desired)).setter(setter(Builder::desired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DESIRED").build()).build();

    private static final SdkField<Integer> MINIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceCounts::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MINIMUM").build()).build();

    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceCounts::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MAXIMUM").build()).build();

    private static final SdkField<Integer> PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceCounts::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PENDING").build()).build();

    private static final SdkField<Integer> ACTIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceCounts::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACTIVE").build()).build();

    private static final SdkField<Integer> IDLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceCounts::idle)).setter(setter(Builder::idle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IDLE").build()).build();

    private static final SdkField<Integer> TERMINATING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EC2InstanceCounts::terminating)).setter(setter(Builder::terminating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TERMINATING").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_FIELD, MINIMUM_FIELD,
            MAXIMUM_FIELD, PENDING_FIELD, ACTIVE_FIELD, IDLE_FIELD, TERMINATING_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer desired;

    private final Integer minimum;

    private final Integer maximum;

    private final Integer pending;

    private final Integer active;

    private final Integer idle;

    private final Integer terminating;

    private EC2InstanceCounts(BuilderImpl builder) {
        this.desired = builder.desired;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.pending = builder.pending;
        this.active = builder.active;
        this.idle = builder.idle;
        this.terminating = builder.terminating;
    }

    /**
     * <p>
     * Ideal number of active instances in the fleet.
     * </p>
     * 
     * @return Ideal number of active instances in the fleet.
     */
    public Integer desired() {
        return desired;
    }

    /**
     * <p>
     * The minimum value allowed for the fleet's instance count.
     * </p>
     * 
     * @return The minimum value allowed for the fleet's instance count.
     */
    public Integer minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum value allowed for the fleet's instance count.
     * </p>
     * 
     * @return The maximum value allowed for the fleet's instance count.
     */
    public Integer maximum() {
        return maximum;
    }

    /**
     * <p>
     * Number of instances in the fleet that are starting but not yet active.
     * </p>
     * 
     * @return Number of instances in the fleet that are starting but not yet active.
     */
    public Integer pending() {
        return pending;
    }

    /**
     * <p>
     * Actual number of active instances in the fleet.
     * </p>
     * 
     * @return Actual number of active instances in the fleet.
     */
    public Integer active() {
        return active;
    }

    /**
     * <p>
     * Number of active instances in the fleet that are not currently hosting a game session.
     * </p>
     * 
     * @return Number of active instances in the fleet that are not currently hosting a game session.
     */
    public Integer idle() {
        return idle;
    }

    /**
     * <p>
     * Number of instances in the fleet that are no longer active but haven't yet been terminated.
     * </p>
     * 
     * @return Number of instances in the fleet that are no longer active but haven't yet been terminated.
     */
    public Integer terminating() {
        return terminating;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desired());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(idle());
        hashCode = 31 * hashCode + Objects.hashCode(terminating());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceCounts)) {
            return false;
        }
        EC2InstanceCounts other = (EC2InstanceCounts) obj;
        return Objects.equals(desired(), other.desired()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(maximum(), other.maximum()) && Objects.equals(pending(), other.pending())
                && Objects.equals(active(), other.active()) && Objects.equals(idle(), other.idle())
                && Objects.equals(terminating(), other.terminating());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EC2InstanceCounts").add("DESIRED", desired()).add("MINIMUM", minimum())
                .add("MAXIMUM", maximum()).add("PENDING", pending()).add("ACTIVE", active()).add("IDLE", idle())
                .add("TERMINATING", terminating()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DESIRED":
            return Optional.ofNullable(clazz.cast(desired()));
        case "MINIMUM":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "MAXIMUM":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "PENDING":
            return Optional.ofNullable(clazz.cast(pending()));
        case "ACTIVE":
            return Optional.ofNullable(clazz.cast(active()));
        case "IDLE":
            return Optional.ofNullable(clazz.cast(idle()));
        case "TERMINATING":
            return Optional.ofNullable(clazz.cast(terminating()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceCounts, T> g) {
        return obj -> g.apply((EC2InstanceCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2InstanceCounts> {
        /**
         * <p>
         * Ideal number of active instances in the fleet.
         * </p>
         * 
         * @param desired
         *        Ideal number of active instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desired(Integer desired);

        /**
         * <p>
         * The minimum value allowed for the fleet's instance count.
         * </p>
         * 
         * @param minimum
         *        The minimum value allowed for the fleet's instance count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Integer minimum);

        /**
         * <p>
         * The maximum value allowed for the fleet's instance count.
         * </p>
         * 
         * @param maximum
         *        The maximum value allowed for the fleet's instance count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Integer maximum);

        /**
         * <p>
         * Number of instances in the fleet that are starting but not yet active.
         * </p>
         * 
         * @param pending
         *        Number of instances in the fleet that are starting but not yet active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * Actual number of active instances in the fleet.
         * </p>
         * 
         * @param active
         *        Actual number of active instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Integer active);

        /**
         * <p>
         * Number of active instances in the fleet that are not currently hosting a game session.
         * </p>
         * 
         * @param idle
         *        Number of active instances in the fleet that are not currently hosting a game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idle(Integer idle);

        /**
         * <p>
         * Number of instances in the fleet that are no longer active but haven't yet been terminated.
         * </p>
         * 
         * @param terminating
         *        Number of instances in the fleet that are no longer active but haven't yet been terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminating(Integer terminating);
    }

    static final class BuilderImpl implements Builder {
        private Integer desired;

        private Integer minimum;

        private Integer maximum;

        private Integer pending;

        private Integer active;

        private Integer idle;

        private Integer terminating;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceCounts model) {
            desired(model.desired);
            minimum(model.minimum);
            maximum(model.maximum);
            pending(model.pending);
            active(model.active);
            idle(model.idle);
            terminating(model.terminating);
        }

        public final Integer getDesired() {
            return desired;
        }

        @Override
        public final Builder desired(Integer desired) {
            this.desired = desired;
            return this;
        }

        public final void setDesired(Integer desired) {
            this.desired = desired;
        }

        public final Integer getMinimum() {
            return minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Integer minimum) {
            this.minimum = minimum;
        }

        public final Integer getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        public final Integer getPending() {
            return pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        public final Integer getActive() {
            return active;
        }

        @Override
        public final Builder active(Integer active) {
            this.active = active;
            return this;
        }

        public final void setActive(Integer active) {
            this.active = active;
        }

        public final Integer getIdle() {
            return idle;
        }

        @Override
        public final Builder idle(Integer idle) {
            this.idle = idle;
            return this;
        }

        public final void setIdle(Integer idle) {
            this.idle = idle;
        }

        public final Integer getTerminating() {
            return terminating;
        }

        @Override
        public final Builder terminating(Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        public final void setTerminating(Integer terminating) {
            this.terminating = terminating;
        }

        @Override
        public EC2InstanceCounts build() {
            return new EC2InstanceCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
