/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetPortSettingsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetPortSettingsResponse.Builder, DescribeFleetPortSettingsResponse> {
    private static final SdkField<List<IpPermission>> INBOUND_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFleetPortSettingsResponse::inboundPermissions))
            .setter(setter(Builder::inboundPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOUND_PERMISSIONS_FIELD));

    private final List<IpPermission> inboundPermissions;

    private DescribeFleetPortSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.inboundPermissions = builder.inboundPermissions;
    }

    /**
     * Returns true if the InboundPermissions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInboundPermissions() {
        return inboundPermissions != null && !(inboundPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port settings for the requested fleet ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInboundPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The port settings for the requested fleet ID.
     */
    public List<IpPermission> inboundPermissions() {
        return inboundPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inboundPermissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetPortSettingsResponse)) {
            return false;
        }
        DescribeFleetPortSettingsResponse other = (DescribeFleetPortSettingsResponse) obj;
        return Objects.equals(inboundPermissions(), other.inboundPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFleetPortSettingsResponse").add("InboundPermissions", inboundPermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InboundPermissions":
            return Optional.ofNullable(clazz.cast(inboundPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetPortSettingsResponse, T> g) {
        return obj -> g.apply((DescribeFleetPortSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
        /**
         * <p>
         * The port settings for the requested fleet ID.
         * </p>
         * 
         * @param inboundPermissions
         *        The port settings for the requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissions(Collection<IpPermission> inboundPermissions);

        /**
         * <p>
         * The port settings for the requested fleet ID.
         * </p>
         * 
         * @param inboundPermissions
         *        The port settings for the requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissions(IpPermission... inboundPermissions);

        /**
         * <p>
         * The port settings for the requested fleet ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #inboundPermissions(List<IpPermission>)}.
         * 
         * @param inboundPermissions
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundPermissions(List<IpPermission>)
         */
        Builder inboundPermissions(Consumer<IpPermission.Builder>... inboundPermissions);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<IpPermission> inboundPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetPortSettingsResponse model) {
            super(model);
            inboundPermissions(model.inboundPermissions);
        }

        public final Collection<IpPermission.Builder> getInboundPermissions() {
            return inboundPermissions != null ? inboundPermissions.stream().map(IpPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissions(Collection<IpPermission> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copy(inboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(IpPermission... inboundPermissions) {
            inboundPermissions(Arrays.asList(inboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(Consumer<IpPermission.Builder>... inboundPermissions) {
            inboundPermissions(Stream.of(inboundPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInboundPermissions(Collection<IpPermission.BuilderImpl> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copyFromBuilder(inboundPermissions);
        }

        @Override
        public DescribeFleetPortSettingsResponse build() {
            return new DescribeFleetPortSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
