/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcPeeringAuthorizationResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateVpcPeeringAuthorizationResponse.Builder, CreateVpcPeeringAuthorizationResponse> {
    private static final SdkField<VpcPeeringAuthorization> VPC_PEERING_AUTHORIZATION_FIELD = SdkField
            .<VpcPeeringAuthorization> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVpcPeeringAuthorizationResponse::vpcPeeringAuthorization))
            .setter(setter(Builder::vpcPeeringAuthorization)).constructor(VpcPeeringAuthorization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringAuthorization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_PEERING_AUTHORIZATION_FIELD));

    private final VpcPeeringAuthorization vpcPeeringAuthorization;

    private CreateVpcPeeringAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringAuthorization = builder.vpcPeeringAuthorization;
    }

    /**
     * <p>
     * Details on the requested VPC peering authorization, including expiration.
     * </p>
     * 
     * @return Details on the requested VPC peering authorization, including expiration.
     */
    public VpcPeeringAuthorization vpcPeeringAuthorization() {
        return vpcPeeringAuthorization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringAuthorization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringAuthorizationResponse)) {
            return false;
        }
        CreateVpcPeeringAuthorizationResponse other = (CreateVpcPeeringAuthorizationResponse) obj;
        return Objects.equals(vpcPeeringAuthorization(), other.vpcPeeringAuthorization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcPeeringAuthorizationResponse")
                .add("VpcPeeringAuthorization", vpcPeeringAuthorization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringAuthorization":
            return Optional.ofNullable(clazz.cast(vpcPeeringAuthorization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcPeeringAuthorizationResponse, T> g) {
        return obj -> g.apply((CreateVpcPeeringAuthorizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcPeeringAuthorizationResponse> {
        /**
         * <p>
         * Details on the requested VPC peering authorization, including expiration.
         * </p>
         * 
         * @param vpcPeeringAuthorization
         *        Details on the requested VPC peering authorization, including expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringAuthorization(VpcPeeringAuthorization vpcPeeringAuthorization);

        /**
         * <p>
         * Details on the requested VPC peering authorization, including expiration.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringAuthorization.Builder} avoiding the
         * need to create one manually via {@link VpcPeeringAuthorization#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringAuthorization.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcPeeringAuthorization(VpcPeeringAuthorization)}.
         * 
         * @param vpcPeeringAuthorization
         *        a consumer that will call methods on {@link VpcPeeringAuthorization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeeringAuthorization(VpcPeeringAuthorization)
         */
        default Builder vpcPeeringAuthorization(Consumer<VpcPeeringAuthorization.Builder> vpcPeeringAuthorization) {
            return vpcPeeringAuthorization(VpcPeeringAuthorization.builder().applyMutation(vpcPeeringAuthorization).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private VpcPeeringAuthorization vpcPeeringAuthorization;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringAuthorizationResponse model) {
            super(model);
            vpcPeeringAuthorization(model.vpcPeeringAuthorization);
        }

        public final VpcPeeringAuthorization.Builder getVpcPeeringAuthorization() {
            return vpcPeeringAuthorization != null ? vpcPeeringAuthorization.toBuilder() : null;
        }

        @Override
        public final Builder vpcPeeringAuthorization(VpcPeeringAuthorization vpcPeeringAuthorization) {
            this.vpcPeeringAuthorization = vpcPeeringAuthorization;
            return this;
        }

        public final void setVpcPeeringAuthorization(VpcPeeringAuthorization.BuilderImpl vpcPeeringAuthorization) {
            this.vpcPeeringAuthorization = vpcPeeringAuthorization != null ? vpcPeeringAuthorization.build() : null;
        }

        @Override
        public CreateVpcPeeringAuthorizationResponse build() {
            return new CreateVpcPeeringAuthorizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
