/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties that describe an alias resource.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListAliases</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteAlias</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ResolveAlias</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alias implements SdkPojo, Serializable, ToCopyableBuilder<Alias.Builder, Alias> {
    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Alias::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Alias::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Alias::aliasArn)).setter(setter(Builder::aliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Alias::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<RoutingStrategy> ROUTING_STRATEGY_FIELD = SdkField
            .<RoutingStrategy> builder(MarshallingType.SDK_POJO).getter(getter(Alias::routingStrategy))
            .setter(setter(Builder::routingStrategy)).constructor(RoutingStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStrategy").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Alias::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Alias::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_ID_FIELD, NAME_FIELD,
            ALIAS_ARN_FIELD, DESCRIPTION_FIELD, ROUTING_STRATEGY_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aliasId;

    private final String name;

    private final String aliasArn;

    private final String description;

    private final RoutingStrategy routingStrategy;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private Alias(BuilderImpl builder) {
        this.aliasId = builder.aliasId;
        this.name = builder.name;
        this.aliasArn = builder.aliasArn;
        this.description = builder.description;
        this.routingStrategy = builder.routingStrategy;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * A unique identifier for an alias. Alias IDs are unique within a Region.
     * </p>
     * 
     * @return A unique identifier for an alias. Alias IDs are unique within a Region.
     */
    public String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * A descriptive label that is associated with an alias. Alias names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with an alias. Alias names do not need to be unique.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Resource Name (<a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is assigned to a
     * GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions.. In a GameLift alias ARN,
     * the resource ID matches the alias ID value.
     * </p>
     * 
     * @return Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is
     *         assigned to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions.. In
     *         a GameLift alias ARN, the resource ID matches the alias ID value.
     */
    public String aliasArn() {
        return aliasArn;
    }

    /**
     * <p>
     * A human-readable description of an alias.
     * </p>
     * 
     * @return A human-readable description of an alias.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The routing configuration, including routing type and fleet target, for the alias.
     * </p>
     * 
     * @return The routing configuration, including routing type and fleet target, for the alias.
     */
    public RoutingStrategy routingStrategy() {
        return routingStrategy;
    }

    /**
     * <p>
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     * milliseconds (for example "1469498468.057").
     * </p>
     * 
     * @return A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     *         milliseconds (for example "1469498468.057").
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for
     * example "1469498468.057").
     * </p>
     * 
     * @return The time that this data object was last modified. Format is a number expressed in Unix time as
     *         milliseconds (for example "1469498468.057").
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routingStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alias)) {
            return false;
        }
        Alias other = (Alias) obj;
        return Objects.equals(aliasId(), other.aliasId()) && Objects.equals(name(), other.name())
                && Objects.equals(aliasArn(), other.aliasArn()) && Objects.equals(description(), other.description())
                && Objects.equals(routingStrategy(), other.routingStrategy())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Alias").add("AliasId", aliasId()).add("Name", name()).add("AliasArn", aliasArn())
                .add("Description", description()).add("RoutingStrategy", routingStrategy()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AliasArn":
            return Optional.ofNullable(clazz.cast(aliasArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoutingStrategy":
            return Optional.ofNullable(clazz.cast(routingStrategy()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alias, T> g) {
        return obj -> g.apply((Alias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alias> {
        /**
         * <p>
         * A unique identifier for an alias. Alias IDs are unique within a Region.
         * </p>
         * 
         * @param aliasId
         *        A unique identifier for an alias. Alias IDs are unique within a Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * A descriptive label that is associated with an alias. Alias names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with an alias. Alias names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is assigned
         * to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions.. In a GameLift
         * alias ARN, the resource ID matches the alias ID value.
         * </p>
         * 
         * @param aliasArn
         *        Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is
         *        assigned to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions..
         *        In a GameLift alias ARN, the resource ID matches the alias ID value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasArn(String aliasArn);

        /**
         * <p>
         * A human-readable description of an alias.
         * </p>
         * 
         * @param description
         *        A human-readable description of an alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The routing configuration, including routing type and fleet target, for the alias.
         * </p>
         * 
         * @param routingStrategy
         *        The routing configuration, including routing type and fleet target, for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingStrategy(RoutingStrategy routingStrategy);

        /**
         * <p>
         * The routing configuration, including routing type and fleet target, for the alias.
         * </p>
         * This is a convenience that creates an instance of the {@link RoutingStrategy.Builder} avoiding the need to
         * create one manually via {@link RoutingStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoutingStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #routingStrategy(RoutingStrategy)}.
         * 
         * @param routingStrategy
         *        a consumer that will call methods on {@link RoutingStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingStrategy(RoutingStrategy)
         */
        default Builder routingStrategy(Consumer<RoutingStrategy.Builder> routingStrategy) {
            return routingStrategy(RoutingStrategy.builder().applyMutation(routingStrategy).build());
        }

        /**
         * <p>
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
         * milliseconds (for example "1469498468.057").
         * </p>
         * 
         * @param creationTime
         *        A time stamp indicating when this data object was created. Format is a number expressed in Unix time
         *        as milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds
         * (for example "1469498468.057").
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that this data object was last modified. Format is a number expressed in Unix time as
         *        milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String aliasId;

        private String name;

        private String aliasArn;

        private String description;

        private RoutingStrategy routingStrategy;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Alias model) {
            aliasId(model.aliasId);
            name(model.name);
            aliasArn(model.aliasArn);
            description(model.description);
            routingStrategy(model.routingStrategy);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getAliasId() {
            return aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAliasArn() {
            return aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final RoutingStrategy.Builder getRoutingStrategy() {
            return routingStrategy != null ? routingStrategy.toBuilder() : null;
        }

        @Override
        public final Builder routingStrategy(RoutingStrategy routingStrategy) {
            this.routingStrategy = routingStrategy;
            return this;
        }

        public final void setRoutingStrategy(RoutingStrategy.BuilderImpl routingStrategy) {
            this.routingStrategy = routingStrategy != null ? routingStrategy.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public Alias build() {
            return new Alias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
