/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.InstanceCredentials;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceCredentialsMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserName").isBinary(false).build();
    private static final MarshallingInfo<String> SECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Secret").isBinary(false).build();
    private static final InstanceCredentialsMarshaller INSTANCE = new InstanceCredentialsMarshaller();

    private InstanceCredentialsMarshaller() {
    }

    public static InstanceCredentialsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceCredentials instanceCredentials, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceCredentials, (String)"instanceCredentials");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceCredentials.userName(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)instanceCredentials.secret(), SECRET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

