/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFleetPortSettingsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateFleetPortSettingsRequest> {
    private final String fleetId;
    private final List<IpPermission> inboundPermissionAuthorizations;
    private final List<IpPermission> inboundPermissionRevocations;

    private UpdateFleetPortSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.inboundPermissionAuthorizations = builder.inboundPermissionAuthorizations;
        this.inboundPermissionRevocations = builder.inboundPermissionRevocations;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public List<IpPermission> inboundPermissionAuthorizations() {
        return this.inboundPermissionAuthorizations;
    }

    public List<IpPermission> inboundPermissionRevocations() {
        return this.inboundPermissionRevocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundPermissionAuthorizations());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundPermissionRevocations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetPortSettingsRequest)) {
            return false;
        }
        UpdateFleetPortSettingsRequest other = (UpdateFleetPortSettingsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.inboundPermissionAuthorizations(), other.inboundPermissionAuthorizations()) && Objects.equals(this.inboundPermissionRevocations(), other.inboundPermissionRevocations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFleetPortSettingsRequest").add("FleetId", (Object)this.fleetId()).add("InboundPermissionAuthorizations", this.inboundPermissionAuthorizations()).add("InboundPermissionRevocations", this.inboundPermissionRevocations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "InboundPermissionAuthorizations": {
                return Optional.of(clazz.cast(this.inboundPermissionAuthorizations()));
            }
            case "InboundPermissionRevocations": {
                return Optional.of(clazz.cast(this.inboundPermissionRevocations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private List<IpPermission> inboundPermissionAuthorizations;
        private List<IpPermission> inboundPermissionRevocations;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetPortSettingsRequest model) {
            this.fleetId(model.fleetId);
            this.inboundPermissionAuthorizations(model.inboundPermissionAuthorizations);
            this.inboundPermissionRevocations(model.inboundPermissionRevocations);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Collection<IpPermission.Builder> getInboundPermissionAuthorizations() {
            return this.inboundPermissionAuthorizations != null ? (Collection)this.inboundPermissionAuthorizations.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionAuthorizations(Collection<IpPermission> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copy(inboundPermissionAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionAuthorizations(IpPermission ... inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations(Arrays.asList(inboundPermissionAuthorizations));
            return this;
        }

        public final void setInboundPermissionAuthorizations(Collection<IpPermission.BuilderImpl> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionAuthorizations);
        }

        public final Collection<IpPermission.Builder> getInboundPermissionRevocations() {
            return this.inboundPermissionRevocations != null ? (Collection)this.inboundPermissionRevocations.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionRevocations(Collection<IpPermission> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copy(inboundPermissionRevocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionRevocations(IpPermission ... inboundPermissionRevocations) {
            this.inboundPermissionRevocations(Arrays.asList(inboundPermissionRevocations));
            return this;
        }

        public final void setInboundPermissionRevocations(Collection<IpPermission.BuilderImpl> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionRevocations);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetPortSettingsRequest build() {
            return new UpdateFleetPortSettingsRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, UpdateFleetPortSettingsRequest> {
        public Builder fleetId(String var1);

        public Builder inboundPermissionAuthorizations(Collection<IpPermission> var1);

        public Builder inboundPermissionAuthorizations(IpPermission ... var1);

        public Builder inboundPermissionRevocations(Collection<IpPermission> var1);

        public Builder inboundPermissionRevocations(IpPermission ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

