/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestinationListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicyListCopier;
import software.amazon.awssdk.services.gamelift.transform.GameSessionQueueMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSessionQueue
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSessionQueue> {
    private final String name;
    private final String gameSessionQueueArn;
    private final Integer timeoutInSeconds;
    private final List<PlayerLatencyPolicy> playerLatencyPolicies;
    private final List<GameSessionQueueDestination> destinations;

    private GameSessionQueue(BuilderImpl builder) {
        this.name = builder.name;
        this.gameSessionQueueArn = builder.gameSessionQueueArn;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.playerLatencyPolicies = builder.playerLatencyPolicies;
        this.destinations = builder.destinations;
    }

    public String name() {
        return this.name;
    }

    public String gameSessionQueueArn() {
        return this.gameSessionQueueArn;
    }

    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public List<PlayerLatencyPolicy> playerLatencyPolicies() {
        return this.playerLatencyPolicies;
    }

    public List<GameSessionQueueDestination> destinations() {
        return this.destinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerLatencyPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionQueue)) {
            return false;
        }
        GameSessionQueue other = (GameSessionQueue)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.gameSessionQueueArn(), other.gameSessionQueueArn()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.playerLatencyPolicies(), other.playerLatencyPolicies()) && Objects.equals(this.destinations(), other.destinations());
    }

    public String toString() {
        return ToString.builder((String)"GameSessionQueue").add("Name", (Object)this.name()).add("GameSessionQueueArn", (Object)this.gameSessionQueueArn()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("PlayerLatencyPolicies", this.playerLatencyPolicies()).add("Destinations", this.destinations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "GameSessionQueueArn": {
                return Optional.of(clazz.cast(this.gameSessionQueueArn()));
            }
            case "TimeoutInSeconds": {
                return Optional.of(clazz.cast(this.timeoutInSeconds()));
            }
            case "PlayerLatencyPolicies": {
                return Optional.of(clazz.cast(this.playerLatencyPolicies()));
            }
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionQueueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String gameSessionQueueArn;
        private Integer timeoutInSeconds;
        private List<PlayerLatencyPolicy> playerLatencyPolicies;
        private List<GameSessionQueueDestination> destinations;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionQueue model) {
            this.name(model.name);
            this.gameSessionQueueArn(model.gameSessionQueueArn);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.playerLatencyPolicies(model.playerLatencyPolicies);
            this.destinations(model.destinations);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getGameSessionQueueArn() {
            return this.gameSessionQueueArn;
        }

        @Override
        public final Builder gameSessionQueueArn(String gameSessionQueueArn) {
            this.gameSessionQueueArn = gameSessionQueueArn;
            return this;
        }

        public final void setGameSessionQueueArn(String gameSessionQueueArn) {
            this.gameSessionQueueArn = gameSessionQueueArn;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Collection<PlayerLatencyPolicy.Builder> getPlayerLatencyPolicies() {
            return this.playerLatencyPolicies != null ? (Collection)this.playerLatencyPolicies.stream().map(PlayerLatencyPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copy(playerLatencyPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(PlayerLatencyPolicy ... playerLatencyPolicies) {
            this.playerLatencyPolicies(Arrays.asList(playerLatencyPolicies));
            return this;
        }

        public final void setPlayerLatencyPolicies(Collection<PlayerLatencyPolicy.BuilderImpl> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copyFromBuilder(playerLatencyPolicies);
        }

        public final Collection<GameSessionQueueDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(GameSessionQueueDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<GameSessionQueueDestination> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(GameSessionQueueDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final void setDestinations(Collection<GameSessionQueueDestination.BuilderImpl> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copyFromBuilder(destinations);
        }

        public GameSessionQueue build() {
            return new GameSessionQueue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSessionQueue> {
        public Builder name(String var1);

        public Builder gameSessionQueueArn(String var1);

        public Builder timeoutInSeconds(Integer var1);

        public Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> var1);

        public Builder playerLatencyPolicies(PlayerLatencyPolicy ... var1);

        public Builder destinations(Collection<GameSessionQueueDestination> var1);

        public Builder destinations(GameSessionQueueDestination ... var1);
    }
}

