/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.PlacedPlayerSessionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlacedPlayerSession
implements StructuredPojo,
ToCopyableBuilder<Builder, PlacedPlayerSession> {
    private final String playerId;
    private final String playerSessionId;

    private PlacedPlayerSession(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerSessionId() {
        return this.playerSessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacedPlayerSession)) {
            return false;
        }
        PlacedPlayerSession other = (PlacedPlayerSession)obj;
        return Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerSessionId(), other.playerSessionId());
    }

    public String toString() {
        return ToString.builder((String)"PlacedPlayerSession").add("PlayerId", (Object)this.playerId()).add("PlayerSessionId", (Object)this.playerSessionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.of(clazz.cast(this.playerId()));
            }
            case "PlayerSessionId": {
                return Optional.of(clazz.cast(this.playerSessionId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlacedPlayerSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String playerSessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacedPlayerSession model) {
            this.playerId(model.playerId);
            this.playerSessionId(model.playerSessionId);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        public PlacedPlayerSession build() {
            return new PlacedPlayerSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlacedPlayerSession> {
        public Builder playerId(String var1);

        public Builder playerSessionId(String var1);
    }
}

