/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.FleetStatus;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.services.gamelift.transform.FleetAttributesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FleetAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, FleetAttributes> {
    private final String fleetId;
    private final String fleetArn;
    private final String description;
    private final String name;
    private final Instant creationTime;
    private final Instant terminationTime;
    private final String status;
    private final String buildId;
    private final String serverLaunchPath;
    private final String serverLaunchParameters;
    private final List<String> logPaths;
    private final String newGameSessionProtectionPolicy;
    private final String operatingSystem;
    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    private final List<String> metricGroups;

    private FleetAttributes(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.description = builder.description;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.buildId = builder.buildId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.operatingSystem = builder.operatingSystem;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String fleetArn() {
        return this.fleetArn;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant terminationTime() {
        return this.terminationTime;
    }

    public FleetStatus status() {
        return FleetStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String buildId() {
        return this.buildId;
    }

    public String serverLaunchPath() {
        return this.serverLaunchPath;
    }

    public String serverLaunchParameters() {
        return this.serverLaunchParameters;
    }

    public List<String> logPaths() {
        return this.logPaths;
    }

    public ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public String newGameSessionProtectionPolicyString() {
        return this.newGameSessionProtectionPolicy;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemString() {
        return this.operatingSystem;
    }

    public ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    public List<String> metricGroups() {
        return this.metricGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetAttributes)) {
            return false;
        }
        FleetAttributes other = (FleetAttributes)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationTime(), other.terminationTime()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.buildId(), other.buildId()) && Objects.equals(this.serverLaunchPath(), other.serverLaunchPath()) && Objects.equals(this.serverLaunchParameters(), other.serverLaunchParameters()) && Objects.equals(this.logPaths(), other.logPaths()) && Objects.equals(this.newGameSessionProtectionPolicyString(), other.newGameSessionProtectionPolicyString()) && Objects.equals(this.operatingSystemString(), other.operatingSystemString()) && Objects.equals(this.resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy()) && Objects.equals(this.metricGroups(), other.metricGroups());
    }

    public String toString() {
        return ToString.builder((String)"FleetAttributes").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("CreationTime", (Object)this.creationTime()).add("TerminationTime", (Object)this.terminationTime()).add("Status", (Object)this.statusString()).add("BuildId", (Object)this.buildId()).add("ServerLaunchPath", (Object)this.serverLaunchPath()).add("ServerLaunchParameters", (Object)this.serverLaunchParameters()).add("LogPaths", this.logPaths()).add("NewGameSessionProtectionPolicy", (Object)this.newGameSessionProtectionPolicyString()).add("OperatingSystem", (Object)this.operatingSystemString()).add("ResourceCreationLimitPolicy", (Object)this.resourceCreationLimitPolicy()).add("MetricGroups", this.metricGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.of(clazz.cast(this.fleetArn()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "TerminationTime": {
                return Optional.of(clazz.cast(this.terminationTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "BuildId": {
                return Optional.of(clazz.cast(this.buildId()));
            }
            case "ServerLaunchPath": {
                return Optional.of(clazz.cast(this.serverLaunchPath()));
            }
            case "ServerLaunchParameters": {
                return Optional.of(clazz.cast(this.serverLaunchParameters()));
            }
            case "LogPaths": {
                return Optional.of(clazz.cast(this.logPaths()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.of(clazz.cast(this.newGameSessionProtectionPolicyString()));
            }
            case "OperatingSystem": {
                return Optional.of(clazz.cast(this.operatingSystemString()));
            }
            case "ResourceCreationLimitPolicy": {
                return Optional.of(clazz.cast(this.resourceCreationLimitPolicy()));
            }
            case "MetricGroups": {
                return Optional.of(clazz.cast(this.metricGroups()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String description;
        private String name;
        private Instant creationTime;
        private Instant terminationTime;
        private String status;
        private String buildId;
        private String serverLaunchPath;
        private String serverLaunchParameters;
        private List<String> logPaths;
        private String newGameSessionProtectionPolicy;
        private String operatingSystem;
        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
        private List<String> metricGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetAttributes model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.description(model.description);
            this.name(model.name);
            this.creationTime(model.creationTime);
            this.terminationTime(model.terminationTime);
            this.status(model.status);
            this.buildId(model.buildId);
            this.serverLaunchPath(model.serverLaunchPath);
            this.serverLaunchParameters(model.serverLaunchParameters);
            this.logPaths(model.logPaths);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.operatingSystem(model.operatingSystem);
            this.resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            this.metricGroups(model.metricGroups);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getBuildId() {
            return this.buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getServerLaunchPath() {
            return this.serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        public final String getServerLaunchParameters() {
            return this.serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        public final Collection<String> getLogPaths() {
            return this.logPaths;
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String ... logPaths) {
            this.logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy != null ? this.resourceCreationLimitPolicy.toBuilder() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        public final Collection<String> getMetricGroups() {
            return this.metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        public FleetAttributes build() {
            return new FleetAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetAttributes> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder creationTime(Instant var1);

        public Builder terminationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(FleetStatus var1);

        public Builder buildId(String var1);

        public Builder serverLaunchPath(String var1);

        public Builder serverLaunchParameters(String var1);

        public Builder logPaths(Collection<String> var1);

        public Builder logPaths(String ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy var1);

        default public Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return this.resourceCreationLimitPolicy((ResourceCreationLimitPolicy)((ResourceCreationLimitPolicy.Builder)ResourceCreationLimitPolicy.builder().apply(resourceCreationLimitPolicy)).build());
        }

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);
    }
}

