/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.EC2InstanceCountsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EC2InstanceCounts
implements StructuredPojo,
ToCopyableBuilder<Builder, EC2InstanceCounts> {
    private final Integer desired;
    private final Integer minimum;
    private final Integer maximum;
    private final Integer pending;
    private final Integer active;
    private final Integer idle;
    private final Integer terminating;

    private EC2InstanceCounts(BuilderImpl builder) {
        this.desired = builder.desired;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.pending = builder.pending;
        this.active = builder.active;
        this.idle = builder.idle;
        this.terminating = builder.terminating;
    }

    public Integer desired() {
        return this.desired;
    }

    public Integer minimum() {
        return this.minimum;
    }

    public Integer maximum() {
        return this.maximum;
    }

    public Integer pending() {
        return this.pending;
    }

    public Integer active() {
        return this.active;
    }

    public Integer idle() {
        return this.idle;
    }

    public Integer terminating() {
        return this.terminating;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desired());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.idle());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminating());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceCounts)) {
            return false;
        }
        EC2InstanceCounts other = (EC2InstanceCounts)obj;
        return Objects.equals(this.desired(), other.desired()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.pending(), other.pending()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.idle(), other.idle()) && Objects.equals(this.terminating(), other.terminating());
    }

    public String toString() {
        return ToString.builder((String)"EC2InstanceCounts").add("DESIRED", (Object)this.desired()).add("MINIMUM", (Object)this.minimum()).add("MAXIMUM", (Object)this.maximum()).add("PENDING", (Object)this.pending()).add("ACTIVE", (Object)this.active()).add("IDLE", (Object)this.idle()).add("TERMINATING", (Object)this.terminating()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DESIRED": {
                return Optional.of(clazz.cast(this.desired()));
            }
            case "MINIMUM": {
                return Optional.of(clazz.cast(this.minimum()));
            }
            case "MAXIMUM": {
                return Optional.of(clazz.cast(this.maximum()));
            }
            case "PENDING": {
                return Optional.of(clazz.cast(this.pending()));
            }
            case "ACTIVE": {
                return Optional.of(clazz.cast(this.active()));
            }
            case "IDLE": {
                return Optional.of(clazz.cast(this.idle()));
            }
            case "TERMINATING": {
                return Optional.of(clazz.cast(this.terminating()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2InstanceCountsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer desired;
        private Integer minimum;
        private Integer maximum;
        private Integer pending;
        private Integer active;
        private Integer idle;
        private Integer terminating;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceCounts model) {
            this.desired(model.desired);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
            this.pending(model.pending);
            this.active(model.active);
            this.idle(model.idle);
            this.terminating(model.terminating);
        }

        public final Integer getDESIRED() {
            return this.desired;
        }

        @Override
        public final Builder desired(Integer desired) {
            this.desired = desired;
            return this;
        }

        public final void setDESIRED(Integer desired) {
            this.desired = desired;
        }

        public final Integer getMINIMUM() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMINIMUM(Integer minimum) {
            this.minimum = minimum;
        }

        public final Integer getMAXIMUM() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMAXIMUM(Integer maximum) {
            this.maximum = maximum;
        }

        public final Integer getPENDING() {
            return this.pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final void setPENDING(Integer pending) {
            this.pending = pending;
        }

        public final Integer getACTIVE() {
            return this.active;
        }

        @Override
        public final Builder active(Integer active) {
            this.active = active;
            return this;
        }

        public final void setACTIVE(Integer active) {
            this.active = active;
        }

        public final Integer getIDLE() {
            return this.idle;
        }

        @Override
        public final Builder idle(Integer idle) {
            this.idle = idle;
            return this;
        }

        public final void setIDLE(Integer idle) {
            this.idle = idle;
        }

        public final Integer getTERMINATING() {
            return this.terminating;
        }

        @Override
        public final Builder terminating(Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        public final void setTERMINATING(Integer terminating) {
            this.terminating = terminating;
        }

        public EC2InstanceCounts build() {
            return new EC2InstanceCounts(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EC2InstanceCounts> {
        public Builder desired(Integer var1);

        public Builder minimum(Integer var1);

        public Builder maximum(Integer var1);

        public Builder pending(Integer var1);

        public Builder active(Integer var1);

        public Builder idle(Integer var1);

        public Builder terminating(Integer var1);
    }
}

