/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo;
import software.amazon.awssdk.services.gamelift.model.MatchmakingConfigurationStatus;
import software.amazon.awssdk.services.gamelift.model.Player;
import software.amazon.awssdk.services.gamelift.model.PlayerListCopier;
import software.amazon.awssdk.services.gamelift.transform.MatchmakingTicketMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MatchmakingTicket
implements StructuredPojo,
ToCopyableBuilder<Builder, MatchmakingTicket> {
    private final String ticketId;
    private final String configurationName;
    private final String status;
    private final String statusReason;
    private final String statusMessage;
    private final Instant startTime;
    private final Instant endTime;
    private final List<Player> players;
    private final GameSessionConnectionInfo gameSessionConnectionInfo;
    private final Integer estimatedWaitTime;

    private MatchmakingTicket(BuilderImpl builder) {
        this.ticketId = builder.ticketId;
        this.configurationName = builder.configurationName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.statusMessage = builder.statusMessage;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.players = builder.players;
        this.gameSessionConnectionInfo = builder.gameSessionConnectionInfo;
        this.estimatedWaitTime = builder.estimatedWaitTime;
    }

    public String ticketId() {
        return this.ticketId;
    }

    public String configurationName() {
        return this.configurationName;
    }

    public MatchmakingConfigurationStatus status() {
        return MatchmakingConfigurationStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<Player> players() {
        return this.players;
    }

    public GameSessionConnectionInfo gameSessionConnectionInfo() {
        return this.gameSessionConnectionInfo;
    }

    public Integer estimatedWaitTime() {
        return this.estimatedWaitTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.players());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionConnectionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedWaitTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchmakingTicket)) {
            return false;
        }
        MatchmakingTicket other = (MatchmakingTicket)obj;
        return Objects.equals(this.ticketId(), other.ticketId()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.players(), other.players()) && Objects.equals(this.gameSessionConnectionInfo(), other.gameSessionConnectionInfo()) && Objects.equals(this.estimatedWaitTime(), other.estimatedWaitTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ticketId() != null) {
            sb.append("TicketId: ").append(this.ticketId()).append(",");
        }
        if (this.configurationName() != null) {
            sb.append("ConfigurationName: ").append(this.configurationName()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.players() != null) {
            sb.append("Players: ").append(this.players()).append(",");
        }
        if (this.gameSessionConnectionInfo() != null) {
            sb.append("GameSessionConnectionInfo: ").append(this.gameSessionConnectionInfo()).append(",");
        }
        if (this.estimatedWaitTime() != null) {
            sb.append("EstimatedWaitTime: ").append(this.estimatedWaitTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketId": {
                return Optional.of(clazz.cast(this.ticketId()));
            }
            case "ConfigurationName": {
                return Optional.of(clazz.cast(this.configurationName()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "Players": {
                return Optional.of(clazz.cast(this.players()));
            }
            case "GameSessionConnectionInfo": {
                return Optional.of(clazz.cast(this.gameSessionConnectionInfo()));
            }
            case "EstimatedWaitTime": {
                return Optional.of(clazz.cast(this.estimatedWaitTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MatchmakingTicketMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ticketId;
        private String configurationName;
        private String status;
        private String statusReason;
        private String statusMessage;
        private Instant startTime;
        private Instant endTime;
        private List<Player> players;
        private GameSessionConnectionInfo gameSessionConnectionInfo;
        private Integer estimatedWaitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchmakingTicket model) {
            this.ticketId(model.ticketId);
            this.configurationName(model.configurationName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.statusMessage(model.statusMessage);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.players(model.players);
            this.gameSessionConnectionInfo(model.gameSessionConnectionInfo);
            this.estimatedWaitTime(model.estimatedWaitTime);
        }

        public final String getTicketId() {
            return this.ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MatchmakingConfigurationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<Player.Builder> getPlayers() {
            return this.players != null ? (Collection)this.players.stream().map(Player::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder players(Collection<Player> players) {
            this.players = PlayerListCopier.copy(players);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Player ... players) {
            this.players(Arrays.asList(players));
            return this;
        }

        public final void setPlayers(Collection<Player.BuilderImpl> players) {
            this.players = PlayerListCopier.copyFromBuilder(players);
        }

        public final GameSessionConnectionInfo.Builder getGameSessionConnectionInfo() {
            return this.gameSessionConnectionInfo != null ? this.gameSessionConnectionInfo.toBuilder() : null;
        }

        @Override
        public final Builder gameSessionConnectionInfo(GameSessionConnectionInfo gameSessionConnectionInfo) {
            this.gameSessionConnectionInfo = gameSessionConnectionInfo;
            return this;
        }

        public final void setGameSessionConnectionInfo(GameSessionConnectionInfo.BuilderImpl gameSessionConnectionInfo) {
            this.gameSessionConnectionInfo = gameSessionConnectionInfo != null ? gameSessionConnectionInfo.build() : null;
        }

        public final Integer getEstimatedWaitTime() {
            return this.estimatedWaitTime;
        }

        @Override
        public final Builder estimatedWaitTime(Integer estimatedWaitTime) {
            this.estimatedWaitTime = estimatedWaitTime;
            return this;
        }

        public final void setEstimatedWaitTime(Integer estimatedWaitTime) {
            this.estimatedWaitTime = estimatedWaitTime;
        }

        public MatchmakingTicket build() {
            return new MatchmakingTicket(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MatchmakingTicket> {
        public Builder ticketId(String var1);

        public Builder configurationName(String var1);

        public Builder status(String var1);

        public Builder status(MatchmakingConfigurationStatus var1);

        public Builder statusReason(String var1);

        public Builder statusMessage(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder players(Collection<Player> var1);

        public Builder players(Player ... var1);

        public Builder gameSessionConnectionInfo(GameSessionConnectionInfo var1);

        default public Builder gameSessionConnectionInfo(Consumer<GameSessionConnectionInfo.Builder> gameSessionConnectionInfo) {
            return this.gameSessionConnectionInfo((GameSessionConnectionInfo)((GameSessionConnectionInfo.Builder)GameSessionConnectionInfo.builder().apply(gameSessionConnectionInfo)).build());
        }

        public Builder estimatedWaitTime(Integer var1);
    }
}

