/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.QueueArnsListCopier;
import software.amazon.awssdk.services.gamelift.transform.MatchmakingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MatchmakingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, MatchmakingConfiguration> {
    private final String name;
    private final String description;
    private final List<String> gameSessionQueueArns;
    private final Integer requestTimeoutSeconds;
    private final Integer acceptanceTimeoutSeconds;
    private final Boolean acceptanceRequired;
    private final String ruleSetName;
    private final String notificationTarget;
    private final Integer additionalPlayerCount;
    private final String customEventData;
    private final Instant creationTime;
    private final List<GameProperty> gameProperties;
    private final String gameSessionData;

    private MatchmakingConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.gameSessionQueueArns = builder.gameSessionQueueArns;
        this.requestTimeoutSeconds = builder.requestTimeoutSeconds;
        this.acceptanceTimeoutSeconds = builder.acceptanceTimeoutSeconds;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.ruleSetName = builder.ruleSetName;
        this.notificationTarget = builder.notificationTarget;
        this.additionalPlayerCount = builder.additionalPlayerCount;
        this.customEventData = builder.customEventData;
        this.creationTime = builder.creationTime;
        this.gameProperties = builder.gameProperties;
        this.gameSessionData = builder.gameSessionData;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<String> gameSessionQueueArns() {
        return this.gameSessionQueueArns;
    }

    public Integer requestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    public Integer acceptanceTimeoutSeconds() {
        return this.acceptanceTimeoutSeconds;
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String notificationTarget() {
        return this.notificationTarget;
    }

    public Integer additionalPlayerCount() {
        return this.additionalPlayerCount;
    }

    public String customEventData() {
        return this.customEventData;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public String gameSessionData() {
        return this.gameSessionData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalPlayerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEventData());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchmakingConfiguration)) {
            return false;
        }
        MatchmakingConfiguration other = (MatchmakingConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.gameSessionQueueArns(), other.gameSessionQueueArns()) && Objects.equals(this.requestTimeoutSeconds(), other.requestTimeoutSeconds()) && Objects.equals(this.acceptanceTimeoutSeconds(), other.acceptanceTimeoutSeconds()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.notificationTarget(), other.notificationTarget()) && Objects.equals(this.additionalPlayerCount(), other.additionalPlayerCount()) && Objects.equals(this.customEventData(), other.customEventData()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.gameSessionData(), other.gameSessionData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.gameSessionQueueArns() != null) {
            sb.append("GameSessionQueueArns: ").append(this.gameSessionQueueArns()).append(",");
        }
        if (this.requestTimeoutSeconds() != null) {
            sb.append("RequestTimeoutSeconds: ").append(this.requestTimeoutSeconds()).append(",");
        }
        if (this.acceptanceTimeoutSeconds() != null) {
            sb.append("AcceptanceTimeoutSeconds: ").append(this.acceptanceTimeoutSeconds()).append(",");
        }
        if (this.acceptanceRequired() != null) {
            sb.append("AcceptanceRequired: ").append(this.acceptanceRequired()).append(",");
        }
        if (this.ruleSetName() != null) {
            sb.append("RuleSetName: ").append(this.ruleSetName()).append(",");
        }
        if (this.notificationTarget() != null) {
            sb.append("NotificationTarget: ").append(this.notificationTarget()).append(",");
        }
        if (this.additionalPlayerCount() != null) {
            sb.append("AdditionalPlayerCount: ").append(this.additionalPlayerCount()).append(",");
        }
        if (this.customEventData() != null) {
            sb.append("CustomEventData: ").append(this.customEventData()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.gameProperties() != null) {
            sb.append("GameProperties: ").append(this.gameProperties()).append(",");
        }
        if (this.gameSessionData() != null) {
            sb.append("GameSessionData: ").append(this.gameSessionData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "GameSessionQueueArns": {
                return Optional.of(clazz.cast(this.gameSessionQueueArns()));
            }
            case "RequestTimeoutSeconds": {
                return Optional.of(clazz.cast(this.requestTimeoutSeconds()));
            }
            case "AcceptanceTimeoutSeconds": {
                return Optional.of(clazz.cast(this.acceptanceTimeoutSeconds()));
            }
            case "AcceptanceRequired": {
                return Optional.of(clazz.cast(this.acceptanceRequired()));
            }
            case "RuleSetName": {
                return Optional.of(clazz.cast(this.ruleSetName()));
            }
            case "NotificationTarget": {
                return Optional.of(clazz.cast(this.notificationTarget()));
            }
            case "AdditionalPlayerCount": {
                return Optional.of(clazz.cast(this.additionalPlayerCount()));
            }
            case "CustomEventData": {
                return Optional.of(clazz.cast(this.customEventData()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "GameProperties": {
                return Optional.of(clazz.cast(this.gameProperties()));
            }
            case "GameSessionData": {
                return Optional.of(clazz.cast(this.gameSessionData()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MatchmakingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> gameSessionQueueArns;
        private Integer requestTimeoutSeconds;
        private Integer acceptanceTimeoutSeconds;
        private Boolean acceptanceRequired;
        private String ruleSetName;
        private String notificationTarget;
        private Integer additionalPlayerCount;
        private String customEventData;
        private Instant creationTime;
        private List<GameProperty> gameProperties;
        private String gameSessionData;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchmakingConfiguration model) {
            this.name(model.name);
            this.description(model.description);
            this.gameSessionQueueArns(model.gameSessionQueueArns);
            this.requestTimeoutSeconds(model.requestTimeoutSeconds);
            this.acceptanceTimeoutSeconds(model.acceptanceTimeoutSeconds);
            this.acceptanceRequired(model.acceptanceRequired);
            this.ruleSetName(model.ruleSetName);
            this.notificationTarget(model.notificationTarget);
            this.additionalPlayerCount(model.additionalPlayerCount);
            this.customEventData(model.customEventData);
            this.creationTime(model.creationTime);
            this.gameProperties(model.gameProperties);
            this.gameSessionData(model.gameSessionData);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getGameSessionQueueArns() {
            return this.gameSessionQueueArns;
        }

        @Override
        public final Builder gameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueueArns(String ... gameSessionQueueArns) {
            this.gameSessionQueueArns(Arrays.asList(gameSessionQueueArns));
            return this;
        }

        public final void setGameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
        }

        public final Integer getRequestTimeoutSeconds() {
            return this.requestTimeoutSeconds;
        }

        @Override
        public final Builder requestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
            return this;
        }

        public final void setRequestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
        }

        public final Integer getAcceptanceTimeoutSeconds() {
            return this.acceptanceTimeoutSeconds;
        }

        @Override
        public final Builder acceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
            return this;
        }

        public final void setAcceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getNotificationTarget() {
            return this.notificationTarget;
        }

        @Override
        public final Builder notificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        public final void setNotificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
        }

        public final Integer getAdditionalPlayerCount() {
            return this.additionalPlayerCount;
        }

        @Override
        public final Builder additionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
            return this;
        }

        public final void setAdditionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
        }

        public final String getCustomEventData() {
            return this.customEventData;
        }

        @Override
        public final Builder customEventData(String customEventData) {
            this.customEventData = customEventData;
            return this;
        }

        public final void setCustomEventData(String customEventData) {
            this.customEventData = customEventData;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        public MatchmakingConfiguration build() {
            return new MatchmakingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MatchmakingConfiguration> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder gameSessionQueueArns(Collection<String> var1);

        public Builder gameSessionQueueArns(String ... var1);

        public Builder requestTimeoutSeconds(Integer var1);

        public Builder acceptanceTimeoutSeconds(Integer var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder ruleSetName(String var1);

        public Builder notificationTarget(String var1);

        public Builder additionalPlayerCount(Integer var1);

        public Builder customEventData(String var1);

        public Builder creationTime(Instant var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameSessionData(String var1);
    }
}

