/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.VpcPeeringAuthorization;

@SdkInternalApi
public class VpcPeeringAuthorizationMarshaller {
    private static final MarshallingInfo<String> GAMELIFTAWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameLiftAwsAccountId").build();
    private static final MarshallingInfo<String> PEERVPCAWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeerVpcAwsAccountId").build();
    private static final MarshallingInfo<String> PEERVPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeerVpcId").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<Instant> EXPIRATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationTime").build();
    private static final VpcPeeringAuthorizationMarshaller INSTANCE = new VpcPeeringAuthorizationMarshaller();

    public static VpcPeeringAuthorizationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VpcPeeringAuthorization vpcPeeringAuthorization, ProtocolMarshaller protocolMarshaller) {
        if (vpcPeeringAuthorization == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)vpcPeeringAuthorization.gameLiftAwsAccountId(), GAMELIFTAWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringAuthorization.peerVpcAwsAccountId(), PEERVPCAWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringAuthorization.peerVpcId(), PEERVPCID_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringAuthorization.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringAuthorization.expirationTime(), EXPIRATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

